* Program examples for c2xx                          *
* PM - Program memory    DM - Data memory            *
* Command file         : c203.cmd                    *
* Assembler batch file : a.bat                       *
* Linker batch file    : l.bat                       *
* Function: Nonstop transmit                         *
*           MODE - Burst mode                        *
*           CLKX - internal CLXCT =1                 *
*           FSN  - 1 				     *
*           FSX  - internal                          *
*           xmit FIFO level - 4                      *
*                                                    *
* Check: Frame sync must be inverted                 *
* Rev 2.0                                            *
* Written by: Sam Saba/ASP/St,TX       Date: 7/17/97 *
        .title  " ESSP  "       ; Title 
	.copy "init.h"    	; Variable and register declaration
        .copy "vector.h"        ; Vector label declaration     
	.text

start:
	CLRC CNF                ; Block B0 in DM, as CNFD
	LDP #0h                 ; set DP=0
	SETC INTM               ; Disable all interrupts
	splk #0000h,60h		; I/O wait states =zero
        out 60h, wsgr
        splk #0cf0eh,60h        ; reset the serial port 
	out 60h, sspcr		  
        splk #0cf3eh,60h        ; Burst mode
        out 60h,sspcr		; enable Sync port, 4 word fifo,
				; CLX/FSR as outputs. 
*ESSP register initialization
        splk #0001h,60h         ; Variable CLKX
        out  60h,SSPCT          ; CLKX = CLKOUT1/(2*(CLXCT+1))
        splk #0000h,60h
        out  60h,SSPMC
	splk #4000h,60h         ; FSN =1, PRSEN =0       
        out  60h,SSPST          ; PRSEN should be the last bit 
        splk #4100h,60h         ; to be turned on in the ESSP          
        out  60h,SSPST          ; programming sequence for 
				; reliable operation
	

main:   splk #08h,imr		; enable receive interrupt
	clrc intm		
	splk #1717h,61h		; dummy data for tx
	splk #55aah,62h		
	splk #7171h,63h		
	splk #0aa55h,64h
	splk #0ffh,7fh
        mar *,ar1		; load ar1 with rx buffer
	lar ar1, #rxbuf
	lar ar0, #size
	out 61h,sdtr
	out 62h,sdtr
	out 63h,sdtr
	out 64h,sdtr
	
loop:	nop			; wait for transmit buffer empty
        clrc xf			; clear xf flag
        idle
	b loop
codtx
       splk #0010h, ifr	        ; clear tx intr flag		
       clrc intm
       ret	
	
codrx:  
       setc xf
       in *+,sdtr
       in *+,sdtr
       in *+,sdtr
       in *+,sdtr
       rpt 7fh
       nop
       out 61h,sdtr		; transmit again
       out 62h,sdtr		; transmit 1717h
       out 63h,sdtr
       out 64h,sdtr
       mar *,ar0
       banz skip,ar1		; buffer limit check
       lar ar1,#rxbuf
       lar ar0,#size			
       in 65h,sspcr 
skip:  splk #0008h, ifr      	; clear ifr bit due to this interrupt  
       clrc intm
       ret			
inpt1: 	ret
inpt23:	ret
time:  	ret
uart:  	ret	
	.end                    ; Assembler module end directive -optional

* Notes : Loopback DX-DR, FSX-FSR and CLKX-CLKR externally
* If the program works properly, 1717 55aa 7171 aa55 should be written
* cyclically in memory starting from 300h to 320h