* Program examples for c2xx                          *
* PM - Program memory    DM - Data memory            *
* Command file         : c203.cmd                    *
* Assembler batch file : a.bat                       *
* Linker batch file    : l.bat                       *
* Function: Continuous transmit                      *
*           MODE - burst mode                        *
*           CLKX - internal CLXCT =1                 *
*           FSX  - internal                          *
*           xmit FIFO level - 4                      *
*                                                    *
*Check:  CLKX rate defined by CLKOUT1/(2*(CLXCT+1))  *
*        CLKX rate = 5Mhz = 200ns cycle              *  
*                                                    *
* Written by: Sam Saba/ASP/St,TX       Date: 7/17/97 *
        .title  " ESSP  "       ; Title 
	.copy "init.h"    	; Variable and register declaration
        .copy "vector.h"        ; Vector label declaration     
	.text

start:
	CLRC CNF                ; Block B0 in DM, as CNFD
	LDP #0h                 ; set DP=0
	SETC INTM               ; Disable all interrupts
	splk #0000h,60h		; I/O wait states =zero
        out 60h, wsgr
        splk #0cf0eh,60h        ; reset the serial port by writing
	out 60h, sspcr		; zeros at NOR/RES, + loop back  
        splk #0cf3eh,60h
        out 60h,sspcr		; enable Sync port, 4 word fifo,
				; CLX/FSR as outputs. Continous mode
*ESSP register initialization
        splk #01h,60h            ; CLKOUT1/4 = 5Mhz= 200ns
        out  60h,SSPCT          ; CLKX = CLKOUT1/(2*(CLXCT+1))
        splk #0,60h
        out  60h,SSPMC
        splk #4100h,60h         ; b 0100 0001 0000 0000 =4100h         
        out  60h,SSPST          ; 
	

main:   splk #08h,imr		; enable rinit interrupt
	clrc intm		
	splk #1717h,61h		; dummy data for tx
	splk #7171h,63h		;
	splk #0aa55h,64h
	splk #55aah,62h		; transmit 55aah on tx
        splk #0ffh,7fh
        mar *,ar1		; load ar1 with rx buffer
	lar ar1, #rxbuf
	lar ar0, #size
	out 62h,sdtr
	out 61h,sdtr
	out 63h,sdtr
	out 64h,sdtr
	
loop:	nop			; wait for transmit buffer empty
        clrc xf			; clear xf flag
        idle
	b loop
codtx
       splk #0010h, ifr	        ; clear tx intr flag		
       clrc intm
       ret	
	
codrx:  
       setc xf
       in 6ah,SSPST 
       in *+,sdtr
       in 6bh,SSPST
       in *+,sdtr
       in 6ch,SSPST
       in *+,sdtr
       in 6dh,SSPST
       in *+,sdtr
       in 6eh,SSPST
       rpt 7fh
       nop
       in 70h,SSPST
       out 62h,sdtr		; transmit 0x55aah again
       in 71h,SSPST
       out 61h,sdtr		; transmit 1717h
       in 72h,SSPST
       out 63h,sdtr
       in 73h,SSPST
       out 64h,sdtr
       in 74h,SSPST
       mar *,ar0
       banz skip,ar1		; buffer check
       lar ar1,#rxbuf
       lar ar0,#size			
       in 65h,sspcr 
skip:  splk #0008h, ifr      	; clear ifr bit due to this interrupt  
       clrc intm
       ret			
inpt1: 	ret
inpt23:	ret
time:  	ret
uart:  	ret	
	.end                    ; Assembler module end directive -optional
