* Program examples for c2xx                          *
* PM - Program memory    DM - Data memory            *
* Command file         : c203.cmd                    *
* Assembler batch file : a.bat                       *
* Linker batch file    : l.bat                       *
* Function: Non-stop transmit                        *
*           MODE - Burst mode                        *
*           CLKX - internal (CLXCT = 3)              *
*           FSX  - internal (FSXCT = 3f)             *
*           xmit FIFO level - 4                      *
*                                                    *
* Check:     Multi_channel bit enabled in SSPMC      *
*           Xmit 4 words in burst mode               *
* Caution: If 4 channels are chosen, then FSXCT >=35 *
* Rev 2.0                                            *
* Written by: Sam Saba/ASP/St,TX       Date: 7/17/97 *

        .title  " ESSP  "       ; Title
	.copy "init.h"    	; Variable and register declaration
        .copy "vector.h"        ; Vector label declaration     
	.text

start:
	CLRC CNF                ; Block B0 in DM, as CNFD
	LDP #0h                 ; set DP=0
	SETC INTM               ; Disable all interrupts
	splk #0000h,60h		; I/O wait states =zero
        out 60h, wsgr
        splk #0cf0eh,60h        ; reset the serial port 
	out 60h, sspcr		 
        splk #0cf3eh,60h        ; Burst mode
        out 60h,sspcr		; enable Sync port, 4 word fifo,
				; CLX/FSR as outputs. 

*ESSP register initialization
        splk #07F03h,60h        ; CLKX = 5 MHz (for 40MHz CLKOUT1)
        out  60h,SSPCT          ; CLKX = CLKOUT1/(2*(CLXCT+1))
        splk #0038h,60h         ; b 0000 0000 0011 1000 = 0038h
        out  60h,SSPMC		; Multichannel bit =1, 4 channels
        splk #2100h,60h         ; b 0010 0001 0000 0000 =2100h         
        out  60h,SSPST          ;
	

main:   splk #10h,imr           ; enable xmit interrupt
	clrc intm		
	splk #1717h,61h		; dummy data for tx
	splk #55aah,62h		
	splk #7171h,63h		
	splk #0aa55h,64h
        splk #0ffh,7fh
        mar *,ar1		; load ar1 with rx buffer
	lar ar1, #rxbuf
	lar ar0, #size
	out 61h,sdtr
	out 62h,sdtr
	out 63h,sdtr
	out 64h,sdtr
	
loop:	nop			; wait for transmit buffer empty
        clrc xf			; clear xf flag
        idle
	b loop
codtx:
       in 70h,SSPST		; Read FIFO status
       out 61h,sdtr		; transmit again
       in 71h,SSPST
       out 62h,sdtr		
       in 72h,SSPST
       out 63h,sdtr
       in 73h,SSPST
       out 64h,sdtr
       in 74h,SSPST
       splk #0008h, ifr	        ; clear tx intr flag		
       clrc intm
       ret	
	
codrx:  
skip:  splk #0008h, ifr      	; clear ifr bit due to this interrupt  
       clrc intm
       ret			
inpt1: 	ret
inpt23:	ret
time:  	ret
uart:  	ret	
	.end                    ; Assembler module end directive -optional

* Notes: This program DOES NOT loopback serial data.
* However the CLKX and FSX rates can be checked. 