* Program examples for c2xx                          *
* PM - Program memory    DM - Data memory            *
* Command file         : c203.cmd                    *
* Assembler batch file : a.bat                       *
* Linker batch file    : l.bat                       *
* Function: Continuous transmit                      *
*           MODE - Burst mode                        *
*           CLKX - EXTERNAL                          *
*           FSX  - EXTERNAL                          *
*           xmit FIFO level - 4                      *
*                                                    *
* Check :  XF toggle for DR change                   *                                                    
*                                                    *
* Written by: Sam Saba/ASP/St,TX       Date: 7/17/97 *

        .title  " ESSP Burst mode"    ; Title 
	.copy "init.h"    	; Variable and register declaration
        .copy "vector.h"        ; Vector label declaration     
	.text

start:
	CLRC CNF                ; Block B0 in DM, as CNFD
	LDP #0h                 ; set DP=0
	SETC INTM               ; Disable all interrupts
	splk #0000h,60h		; I/O wait states =zero
        out 60h, wsgr
        splk #0cf02h,60h        ; reset the serial port by writing
	out 60h, sspcr		; zeros at NOR/RES, 
        splk #0cf32h,60h
        out 60h,sspcr		; enable Sync port, 4 word fifo,
                                ; CLX input, FSR as outputs. Burst mode
*ESSP register initialization
        splk #0ffffh,60h        ; 
        out  60h,SSPCT          ; 
        splk #0001h,60h         ; GPC enabled GPI NOT enabled       
        out  60h,SSPMC          ; b 0000 0000 0000 0101 =0005h
        splk #0100h,60h         ; b 0000 0011 0000 0000 =0300h         
        out  60h,SSPST          ; External CLKX  

main:   splk #0h,imr            ; enable rinit interrupt
	splk #1717h,61h		; dummy data for tx
	splk #55aah,62h		
	splk #7171h,63h		
	splk #0aa55h,64h
        splk #0ffh,7fh
        mar *,ar1		; load ar1 with rx buffer
	lar ar1, #rxbuf
	lar ar0, #size
        out 62h,sdtr            ; transmit 0x55aah again
	
loop:	nop			; wait for transmit buffer empty

        in 60h,SSPST
        bit 60h,0
        bcnd loop,ntc
        clrc xf
        nop
        nop
        setc xf

loop1   in 60h,SSPST
        bit 60h,0
        bcnd loop1,tc
        clrc xf
        nop
        nop
        setc xf
        b loop

codtx   ret
	
codrx:  
       splk #0008h, ifr         ; clear ifr bit due to this interrupt
       clrc intm
       ret			
inpt1: 	ret
inpt23:	ret
time:  	ret
uart:  	ret	
	.end                    ; Assembler module end directive -optional
