* Program examples for c2xx                          *
* PM - Program memory    DM - Data memory            *
* Command file         : c203.cmd                    *
* Assembler batch file : a.bat                       *
* Linker batch file    : l.bat                       *
* Function: Nonstop transmit                         *
*           MODE - burst mode                        *
*           CLKX - External                          *
*           FSX  - External                          *
*           xmit FIFO level - 4                      *
* Rev 2.0					     *
* Written by: Sam Saba/ASP/St,TX       Date: 7/17/97 *

        .title  " ESSP  "       ; Title 
	.copy "init.h"    	; Variable and register declaration
        .copy "vector.h"        ; Vector label declaration     
	.text

start:
	CLRC CNF                ; Block B0 in DM
	LDP #0h                 ; set DP=0
	SETC INTM               ; Disable all interrupts
	splk #0000h,60h		; wait states =zero
        out 60h, wsgr
        splk #0cf02h,60h        ; reset the serial port 
	out 60h, sspcr		  
        splk #0cf32h,60h
        out 60h,sspcr		; enable Sync port, 4 word fifo,
                                
*ESSP register initialization
        splk #0000h,60h          
        out  60h,SSPCT           
        splk #0000h,60h
        out  60h,SSPMC
        splk #0000h,60h                  
        out  60h,SSPST          ; PRSEN =0

main:   splk #08h,imr		; enable receive interrupt
	clrc intm		
	splk #1717h,61h		; dummy transmit data
	splk #55aah,62h		
	splk #7171h,63h		
	splk #0aa55h,64h
        splk #0ffh,7fh
        mar *,ar1		; load ar1 with rx buffer
	lar ar1, #rxbuf		; rxbuf @ 300h
	lar ar0, #size		; size of rxbuf = 20h
	out 61h,sdtr
	out 62h,sdtr
	out 63h,sdtr
	out 64h,sdtr		; Tx FIFO is full @ this point
	
loop:	nop			; wait for transmit buffer empty
        clrc xf			; clear xf flag
        idle
	b loop

codtx:	
       splk #0010h, ifr	        ; clear tx intr flag		
       clrc intm
       ret	
	
codrx:  
       setc xf
       in 6ah,SSPST 		; Read SSPST for FIFO status
       in *+,sdtr
       in 6bh,SSPST
       in *+,sdtr
       in 6ch,SSPST
       in *+,sdtr
       in 6dh,SSPST
       in *+,sdtr
       in 6eh,SSPST

       in 70h,SSPST		; Read SSPST for FIFO status
       out 62h,sdtr		
       in 71h,SSPST
       out 61h,sdtr		
       in 72h,SSPST
       out 63h,sdtr
       in 73h,SSPST
       out 64h,sdtr
       in 74h,SSPST
       mar *,ar0
       banz skip,ar1		; buffer limit check
       lar ar1,#rxbuf
       lar ar0,#size			
       in 65h,sspcr 
skip:  splk #0008h, ifr      	; clear ifr bit due to this interrupt  
       clrc intm
       ret			
inpt1: 	ret
inpt23:	ret
time:  	ret
uart:  	ret	
	.end                    ; Assembler module end directive 

* Notes : Loopback DX-DR, FSX-FSR and CLKX-CLKR
* If the program works properly, 1717 55aa 7171 aa55 should be written
* cyclically in memory starting from 300h to 320h
* The status of transmit and receive FIFOs will be progressively
* available in 6ah through 74h.
