;*********************************************************************
;
; Filename:    CONV_ENC.ASM
;
; Author:  Chris Buehler, Jonas Keating
; Date:  9/20/95
; Last revision:  10/16/95
;
;*********************************************************************
;
; Description:  Contains routines:
;	         1) do_convolutional_encoder
;	         2) compute_c0
;	         3) compute_u0
;
; Algorithm:
;
;*********************************************************************
;
; Usage:  Assumes data is stored in necessary variables.  Puts output
;         into memory locations.
;
; Inputs:  s_early,s_late, conv_enc_input, conv_enc_tab,
;          c_new_r, c_new_i, c_old_r, c_old_i
;
; Outputs:  y1234, state, y0, c0
;
;*********************************************************************
;
; Comments:
;
;*********************************************************************

  .mmregs
  .text

  .global do_convolutional_encoder
  .global compute_c0
  .global compute_u0

  .global s_early,s_late, conv_enc_input, conv_enc_tab, y1234, state, y0
  .global c_new_r, c_new_i, c_old_r, c_old_i, c0
  .global v0,u0

do_convolutional_encoder:

;// y1234 = conv_enc_input[s_early][s_late];
  lacc	s_early,3
  or	s_late
  add	#conv_enc_input
  samm	AR0
  mar	*,AR0
  nop
  lacl	*
  sacl	y1234

;// y0 = (conv_enc_tab[state][y1234&3])&1;
  and 	#3
  sacb
  lacc	state,2
  orb
  add	#conv_enc_tab
  samm	AR0
;// state = (conv_enc_tab[state][y1234&3])>>1;
  mar	*,AR0
  nop
  lacl	*
  sfr
  sacl  state
  and	#1
  sacl	y0
  ret

compute_c0:
;//  long int sum1,sum2;
;//  sum1 = (c_old_r+c_old_i)>>1;
;//  sum2 = (c_new_r+c_new_i)>>1;
;//  c0 = ((sum1^sum2)&1);
  lacc	c_old_r
  add	c_old_i
  sfr
  sacb
  lacc	c_new_r
  add	c_new_i
  sfr
  xorb
  and	#1
  sacl	c0
  ret

compute_u0:
;//  u0 = (y0^c0^v0)&1;
  lacc	y0
  xor	c0
  xor	v0
  and	#1
  sacl	u0
  ret

  .end
