;*********************************************************************
;
; Filename:  DATA.ASM
;
; Author:  Chris Buehler, Jonas Keating
; Date:  9/10/95
; Last revision:  12/20/95
;
;*********************************************************************
;
; Description:  Contains declarations for all data used in the
;		transmitter.
;
; Algorithm:  None.
;
;*********************************************************************
;
; Comments:  Be sure to modify the '.space' command at the end of
;	     each data page when adding variables.
;
;*********************************************************************

  .sect "intdata"

unit         .set        512
ntaps        .set        8

  .global	datastart,randstat
  .global	testxf,tcont
  .global	m, n, numshells
  .global	rot_table, rot1, rot2, rot3
  .global	bitstream
  .global	xx, xx_10, xx_7
  .global	xy, xy_10, xy_7
  .global	outbufferx, endbufferx
  .global	outbuffery, endbuffery
  .global	outbuffer, endbuffer
  .global	A,B,C,D,E,F,G,H
  .global	r0,r1,r2,r3,r4,r5
  .global       mjk
  .global       qbits,ibits,q
  .global       vx,vy
  .global	ux,uy
  .global	yx,yy
  .global	tx,ty
  .global	preal,pimag
  .global	c_old_i,c_old_r,c_new_i,c_new_r
  .global       s_early,s_late
  .global       c0,y0,v0,u0
  .global       y1234,z,w,state
  .global	conv_enc_input,conv_enc_tab
  .global	g2,g4,z8
  .global	coords
  .global	xlast, ylast, ysend, xycount
  .global	int1data
  .global	int1jtable, sendx, sendy, readh, writeh, p4,p16,p24,badcommand
  .global	scaleup,scaledown,start96,start144,start192,die
  .global	data_from_PC,data_done,data_to_PC
  .global	i1comm, i1commadd, ysave, filtadd, saveAR0
  .global	bitbuf,data_present
  .global	shellmask,scale,PP0,go,MP_sequence
  .global	quant_addr,parse_addr,g2_addr,g4_addr,z8_addr,MP_speed
  .global	g2_14_19,g4_14_19,z8_14_19
  .global	parse_data96, quantize96
  .global	parse_data144,quantize144
  .global	parse_data192,quantize192
  .global	hreal,himag,speed_flag
  .global	points,pointadd

; ---------------------START OF DATA PAGE 2----------------------------

datastart:	.word  1,2,3,4,5 	; 5 temp variables

randstat:  	.long 0h                ; scrambler state variable
					; stored:  lsb..msb
					;           1..18..23..32

testxf:		.word 0			; sync signal state variable
tcont:		.word 30h		; target control register copy
m:		.word 0
n:		.word 0			; mapping frame counter 'n'

;rot_table: 	.word 0,rot1,rot2,rot3
;					; rotation function jump table
;                      a t a d
;bitstream:	.long 61746164h         ; "data"
bitstream	.long 0h,0h
xx:		.word 0,0,0,0,0,0,0
xx_7:		.word 0,0,0
xx_10:		.word 0;,0
xy:		.word 0,0,0,0,0,0,0
xy_7:           .word 0,0,0
xy_10:		.word 0;,0

outbufferx:	.word 1,2,3
endbufferx:	.word 4

outbuffery:	.word 1,2,3
endbuffery:	.word 4

outbuffer:	.word 1,2,3,4,5,6,7
endbuffer:	.word 8

numshells:	.word 12
g2_addr:	.word g2_14_19
g4_addr:	.word g4_14_19
z8_addr:	.word z8_14_19

A:		.word 0
B:		.word 0
C:		.word 0
D:		.word 0
E:		.word 0
F:		.word 0
G:		.word 0
H:		.word 0
r0:		.long 0
r1:		.long 0
r2:		.long 0
r3:		.long 0
r4:		.long 0
r5:		.long 0
mjk:            .word 0,0,0,0,0,0,0,0

q		.word 0
qbits:		.word 0,0,0,0,0,0,0,0
ibits:		.word 0,0,0,0

vx:		.word 0
vy:		.word 0
ux:		.word 0
uy:		.word 0
yx:		.word 0
yy:		.word 0
preal:		.word 0
pimag:		.word 0
c_old_r:	.word 0
c_old_i:	.word 0
c_new_r:	.word 0
c_new_i:	.word 0
s_early:	.word 0
s_late:		.word 0
c0:		.word 0
y0:		.word 0
v0:		.word 0
u0:		.word 0
y1234:		.word 0
z:		.word 0
w:		.word 0
state:		.word 0

xlast: 		.word 0
ylast:		.word 0
ysend:		.word 0
xycount:	.word 0
shellmask:	.word 7h
scale:          .word 2
tx:		.word 0
ty:             .word 0

	.space  0*16

; -----------------127 words of data in data page 2--------------------

; -----------------------START OF DATA PAGE 3--------------------------

conv_enc_input:	.word 0  	; c_e_i[0][0]
		.word 0  	; c_e_i[0][1]
		.word 1  	; c_e_i[0][2]
		.word 1  	; c_e_i[0][3]
		.word 8  	; c_e_i[0][4]
		.word 8  	; c_e_i[0][5]
		.word 9  	; c_e_i[0][6]
		.word 9  	; c_e_i[0][7]
		.word 3  	; c_e_i[1][0]
		.word 2  	; c_e_i[1][1]
		.word 2  	; c_e_i[1][2]
		.word 3  	; c_e_i[1][3]
		.word 11  	; c_e_i[1][4]
		.word 10  	; c_e_i[1][5]
		.word 10  	; c_e_i[1][6]
		.word 11  	; c_e_i[1][7]
		.word 5  	; c_e_i[2][0]
		.word 5  	; c_e_i[2][1]
		.word 4  	; c_e_i[2][2]
		.word 4  	; c_e_i[2][3]
		.word 13  	; c_e_i[2][4]
		.word 13  	; c_e_i[2][5]
		.word 12  	; c_e_i[2][6]
		.word 12  	; c_e_i[2][7]
		.word 6  	; c_e_i[3][0]
		.word 7  	; c_e_i[3][1]
		.word 7  	; c_e_i[3][2]
		.word 6  	; c_e_i[3][3]
		.word 14  	; c_e_i[3][4]
		.word 15  	; c_e_i[3][5]
		.word 15  	; c_e_i[3][6]
		.word 14  	; c_e_i[3][7]
		.word 8  	; c_e_i[4][0]
		.word 8  	; c_e_i[4][1]
		.word 9  	; c_e_i[4][2]
		.word 9  	; c_e_i[4][3]
		.word 0  	; c_e_i[4][4]
		.word 0  	; c_e_i[4][5]
		.word 1  	; c_e_i[4][6]
		.word 1  	; c_e_i[4][7]
		.word 11  	; c_e_i[5][0]
		.word 10  	; c_e_i[5][1]
		.word 10  	; c_e_i[5][2]
		.word 11  	; c_e_i[5][3]
		.word 3  	; c_e_i[5][4]
		.word 2  	; c_e_i[5][5]
		.word 2  	; c_e_i[5][6]
		.word 3  	; c_e_i[5][7]
		.word 13  	; c_e_i[6][0]
		.word 13  	; c_e_i[6][1]
		.word 12  	; c_e_i[6][2]
		.word 12  	; c_e_i[6][3]
		.word 5  	; c_e_i[6][4]
		.word 5  	; c_e_i[6][5]
		.word 4  	; c_e_i[6][6]
		.word 4  	; c_e_i[6][7]
		.word 14  	; c_e_i[7][0]
		.word 15  	; c_e_i[7][1]
		.word 15  	; c_e_i[7][2]
		.word 14  	; c_e_i[7][3]
		.word 6  	; c_e_i[7][4]
		.word 7  	; c_e_i[7][5]
		.word 7  	; c_e_i[7][6]
		.word 6  	; c_e_i[7][7]

conv_enc_tab:	.word 0  	; c_e_t[0][0]
		.word 2  	; c_e_t[0][1]
		.word 12  	; c_e_t[0][2]
		.word 14  	; c_e_t[0][3]
		.word 25  	; c_e_t[1][0]
		.word 27  	; c_e_t[1][1]
		.word 21  	; c_e_t[1][2]
		.word 23  	; c_e_t[1][3]
		.word 2  	; c_e_t[2][0]
		.word 0  	; c_e_t[2][1]
		.word 14  	; c_e_t[2][2]
		.word 12  	; c_e_t[2][3]
		.word 27  	; c_e_t[3][0]
		.word 25  	; c_e_t[3][1]
		.word 23  	; c_e_t[3][2]
		.word 21  	; c_e_t[3][3]
		.word 4  	; c_e_t[4][0]
		.word 6  	; c_e_t[4][1]
		.word 8  	; c_e_t[4][2]
		.word 10  	; c_e_t[4][3]
		.word 29  	; c_e_t[5][0]
		.word 31  	; c_e_t[5][1]
		.word 17  	; c_e_t[5][2]
		.word 19  	; c_e_t[5][3]
		.word 6  	; c_e_t[6][0]
		.word 4  	; c_e_t[6][1]
		.word 10  	; c_e_t[6][2]
		.word 8  	; c_e_t[6][3]
		.word 31  	; c_e_t[7][0]
		.word 29  	; c_e_t[7][1]
		.word 19  	; c_e_t[7][2]
		.word 17  	; c_e_t[7][3]
		.word 8  	; c_e_t[8][0]
		.word 10  	; c_e_t[8][1]
		.word 4  	; c_e_t[8][2]
		.word 6  	; c_e_t[8][3]
		.word 17  	; c_e_t[9][0]
		.word 19  	; c_e_t[9][1]
		.word 29  	; c_e_t[9][2]
		.word 31  	; c_e_t[9][3]
		.word 10  	; c_e_t[10][0]
		.word 8  	; c_e_t[10][1]
		.word 6  	; c_e_t[10][2]
		.word 4  	; c_e_t[10][3]
		.word 19  	; c_e_t[11][0]
		.word 17  	; c_e_t[11][1]
		.word 31  	; c_e_t[11][2]
		.word 29  	; c_e_t[11][3]
		.word 12  	; c_e_t[12][0]
		.word 14  	; c_e_t[12][1]
		.word 0  	; c_e_t[12][2]
		.word 2  	; c_e_t[12][3]
		.word 21  	; c_e_t[13][0]
		.word 23  	; c_e_t[13][1]
		.word 25  	; c_e_t[13][2]
		.word 27  	; c_e_t[13][3]
		.word 14  	; c_e_t[14][0]
		.word 12  	; c_e_t[14][1]
		.word 2  	; c_e_t[14][2]
		.word 0  	; c_e_t[14][3]
		.word 23  	; c_e_t[15][0]
		.word 21  	; c_e_t[15][1]
		.word 27  	; c_e_t[15][2]
		.word 25  	; c_e_t[15][3]

; -----------------128 words of data in data page 3--------------------

; -----------------------START OF DATA PAGE 4--------------------------
g2:		.word 1, 2, 3, 4, 5, 6, 5, 4, 3, 2, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
g4:		.word 1, 4, 10, 20, 35, 56, 80, 104, 125, 140, 146, 140, 125, 104, 80, 56, 35, 20, 10, 4, 1, 0, 0
z8:		.long 0  	; z8[0]
		.long 1  	; z8[1]
		.long 9  	; z8[2]
		.long 45  	; z8[3]
		.long 165  	; z8[4]
		.long 495  	; z8[5]
		.long 1287  	; z8[6]
		.long 2995  	; z8[7]
		.long 6363  	; z8[8]
		.long 12510  	; z8[9]
		.long 22990  	; z8[10]
		.long 39798  	; z8[11]
		.long 65286  	; z8[12]
		.long 101974  	; z8[13]
		.long 152262  	; z8[14]
		.long 218070  	; z8[15]
		.long 300454  	; z8[16]
		.long 399267  	; z8[17]
		.long 512955  	; z8[18]
		.long 638543  	; z8[19]
		.long 771831  	; z8[20]
		.long 907785  	; z8[21]
		.long 1041073  	; z8[22]
		.long 1166661  	; z8[23]

;		.long 1280349  	; z8[24]
;		.long 1379162  	; z8[25]
;		.long 1461546  	; z8[26]
;		.long 1527354  	; z8[27]
;		.long 1577642  	; z8[28]
;		.long 1614330  	; z8[29]
;		.long 1639818  	; z8[30]
;		.long 1656626  	; z8[31]
;		.long 1667106  	; z8[32]
;		.long 1673253  	; z8[33]
;		.long 1676621  	; z8[34]
;		.long 1678329  	; z8[35]
;		.long 1679121  	; z8[36]
;		.long 1679451  	; z8[37]
;		.long 1679571  	; z8[38]
;		.long 1679607  	; z8[39]
;		.long 1679615  	; z8[40]

  .space 36*16

; -----------------114 words of data in data page 4--------------------

; -----------------------START OF DATA PAGE 5--------------------------



g2_14_19:	.word 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1
		.word 0, 0, 0, 0, 0, 0, 0, 0, 0,  0,  0,  0,  0,  0, 0, 0, 0, 0, 0, 0, 0, 0
g4_14_19:	.word 1, 4, 10, 20, 35, 56, 84, 120, 165, 220, 286, 364, 451, 544, 640, 736, 829, 916, 994, 1060, 1111, 1144
		.word 1156, 1144, 1111, 1060, 994, 916, 829, 736, 640, 544, 451, 364, 286, 220, 165, 120, 84, 56, 35, 20, 10, 4, 1, 0, 0, 0

  .space 35*16

; ------------------68 words of data in data page 5--------------------

; -----------------------START OF DATA PAGE 6--------------------------


z8_14_19:	.long 0  		; z8[0]
		.long 1  		; z8[1]
		.long 9  		; z8[2]
		.long 45  		; z8[3]
		.long 165  		; z8[4]
		.long 495  		; z8[5]
		.long 1287  		; z8[6]
		.long 3003  		; z8[7]
		.long 6435  		; z8[8]
		.long 12870  		; z8[9]
		.long 24310  		; z8[10]
		.long 43758  		; z8[11]
		.long 75582  		; z8[12]
		.long 125962  		; z8[13]
		.long 203418  		; z8[14]
		.long 319410  		; z8[15]
		.long 488994  		; z8[16]
		.long 731511  		; z8[17]
		.long 1071279  		; z8[18]
		.long 1538251  		; z8[19]
		.long 2168595  		; z8[20]
		.long 3005145  		; z8[21]
		.long 4097665  		; z8[22]
		.long 5502861  		; z8[23]
		.long 7284069  		; z8[24]
		.long 9510568  		; z8[25]
		.long 12256488  	; z8[26]
		.long 15599304  	; z8[27]
		.long 19617928  	; z8[28]
		.long 24390432  	; z8[29]
		.long 29991456  	; z8[30]
		.long 36489376  	; z8[31]
		.long 43943328  	; z8[32]
		.long 52400205  	; z8[33]
		.long 61891765  	; z8[34]
		.long 72432009  	; z8[35]
		.long 84015009  	; z8[36]
		.long 96613331  	; z8[37]
		.long 110177163  	; z8[38]
		.long 124634223  	; z8[39]
		.long 139890487  	; z8[40]
		.long 155831742  	; z8[41]
		.long 172325934  	; z8[42]
		.long 189226246  	; z8[43]
		.long 206374806  	; z8[44]
		.long 223606890  	; z8[45]
		.long 240755450  	; z8[46]
		.long 257655762  	; z8[47]
		.long 274149954  	; z8[48]

;		.long 290091209  	; z8[49]
;		.long 305347473  	; z8[50]
;		.long 319804533  	; z8[51]
;		.long 333368365  	; z8[52]
;		.long 345966687  	; z8[53]
;		.long 357549687  	; z8[54]
;		.long 368089931  	; z8[55]
;		.long 377581491  	; z8[56]
;		.long 386038368  	; z8[57]
;		.long 393492320  	; z8[58]
;		.long 399990240  	; z8[59]
;		.long 405591264  	; z8[60]
;		.long 410363768  	; z8[61]
;		.long 414382392  	; z8[62]
;		.long 417725208  	; z8[63]
;		.long 420471128  	; z8[64]
;		.long 422697627  	; z8[65]
;		.long 424478835  	; z8[66]
;		.long 425884031  	; z8[67]
;		.long 426976551  	; z8[68]
;		.long 427813101  	; z8[69]
;		.long 428443445  	; z8[70]
;		.long 428910417  	; z8[71]
;		.long 429250185  	; z8[72]
;		.long 429492702  	; z8[73]
;		.long 429662286  	; z8[74]
;		.long 429778278  	; z8[75]
;		.long 429855734  	; z8[76]
;		.long 429906114  	; z8[77]
;		.long 429937938  	; z8[78]
;		.long 429957386  	; z8[79]
;		.long 429968826  	; z8[80]
;		.long 429975261  	; z8[81]
;		.long 429978693  	; z8[82]
;		.long 429980409  	; z8[83]
;		.long 429981201  	; z8[84]
;		.long 429981531  	; z8[85]
;		.long 429981651  	; z8[86]
;		.long 429981687  	; z8[87]
;		.long 429981695  	; z8[88]

  .space 30*16

; ------------------98 words of data in data page 6--------------------

; -----------------------START OF DATA PAGE 7--------------------------

coords:	.word   1,   1,  -3,   1,   1,  -3,  -3,  -3,   1,   5
	.word   5,   1,  -3,   5,   5,  -3,   5,   5,  -7,   1
	.word   1,  -7,  -7,  -3,  -3,  -7,  -7,   5,   5,  -7
	.word   1,   9,   9,   1,  -3,   9,   9,  -3,  -7,  -7
	.word   5,   9,   9,   5, -11,   1,   1, -11,  -7,   9
	.word -11,  -3,   9,  -7,  -3, -11, -11,   5,   5, -11
	.word   9,   9,   1,  13,  13,   1, -11,  -7,  -7, -11
	.word  -3,  13,  13,  -3,   5,  13,  13,   5, -11,   9
	.word   9, -11,  -7,  13,  13,  -7, -15,   1,   1, -15
	.word -15,  -3,  -3, -15, -11, -11,   9,  13,  13,   9
	.word -15,   5,   5, -15, -15,  -7,  -7, -15,   1,  17
	.word  11,  13,  17,   1,  13, -11,  -3,  17,  17,  -3
	.word -15,   9,   9, -15,   5,  17,  17,   5

; -----------------128 words of data in data page 7--------------------

; -----------------------START OF DATA PAGE 8--------------------------

	.word  -7,  17
	.word  13,  13,  17,  -7, -15, -11, -11, -15, -19,   1
	.word   1, -19,   9,  17,  17,   9, -19,  -3,  -3, -19
	.word -19,   5,   5, -19, -15,  13,  13, -15, -11,  17
	.word -19,  -7,  17, -11,  -7, -19,   1,  21, -19,   9
	.word  21,   1,   9, -19,  -3,  21,  21,  -3, -15, -15
	.word  13,  17,  17,  13,   5,  21,  21,   5, -19, -11
	.word -11, -19,  -7,  21,  21,  -7, -15,  17,  17, -15
	.word   9,  21,  21,   9, -19,  13, -23,   1,  13, -19
	.word   1, -23, -23,  -3,  -3, -23, -23,   5,   5, -23
	.word -11,  21,  21, -11,  17,  17, -23,  -7,  -7, -23
	.word -19, -15, -15, -19,  13,  21,  21,  13, -23,   9
	.word   9, -23,   1,  25,  25,   1,  -3,  25,  25,  -3
	.word   5,  25, -19,  17,  25,   5

; -----------------128 words of data in data page 8--------------------

; -----------------------START OF DATA PAGE 9--------------------------

	.word -23, -11,  17, -19
	.word -11, -23, -15,  21,  21, -15,  -7,  25,  25,  -7
	.word -23,  13,  13, -23,   9,  25,  25,   9, -19, -19
	.word  17,  21,  21,  17, -27,   1,   1, -27, -27,  -3
	.word  -3, -27, -11,  25,  25, -11, -27,   5, -23, -15
	.word -15, -23,   5, -27, -27,  -7,  -7, -27,  13,  25
	.word  24,  13, -19,  21,  21, -19, -27,   9,   9, -27
	.word -23,  17,  17, -23,   1,  29,  29,   1,  -3,  29
	.word -15,  25,  29,  -3, -27, -11,  25, -15, -11, -27
	.word   5,  29,  29,   5,  21,  21,  -7,  29,  29,  -7
	.word -23, -19, -19, -23, -27,  13,  13, -27,  17,  25
	.word  25,  17,   9,  29,  29,   9, -27, -15, -15, -27
	.word -11,  29, -31,   1,  29, -11,   1, -31, -23,  21
	.word -31,  -3,  21, -23

; -----------------128 words of data in data page 9--------------------

; -----------------------START OF DATA PAGE 10--------------------------

	.word  -3, -31, -19,  25, -31,  5
	.word  25, -19,   5, -31,  13,  29,  29,  13, -31,  -7
	.word  -7, -31, -27,  17,  17, -27, -31,   9,   9, -31
	.word -23, -23, -15,  29,  21,  25,  25,  21,  29, -15
	.word -31, -11, -11, -31,   1,  33,  33,   1, -27, -19
	.word -19, -27,  -3,  33,  33,  -3,   5,  33,  33,   5
	.word  17,  29,  29,  17, -31,  13,  13, -31,  -7,  33
	.word  33,  -7, -23,  25,  25, -23,   9,  33, -27,  21
	.word  33,   9,  21, -27, -31, -15, -15, -31, -19,  29
	.word  29, -19, -11,  33,  33, -11, -35,   1,   1, -35

  .space 32*16
; -----------------96 words of data in data page 10--------------------

; -----------------------START OF DATA PAGE 11--------------------------

int1data:
int1jtable:	.word sendx, sendy,readh,writeh,p4,p16,p24,scaleup,scaledown
		.word start96,start144,start192,die,data_from_PC
		.word data_done,data_to_PC,badcommand
i1comm	       	.word 0
i1commadd	.word badcommand
ysave:		.word 0
filtadd:	.word 0
saveAR0:	.word 0
go:		.word 0			; 0=waiting, 1=9600, 2=14400, 3=19200
data_present:	.word 0
bitbuf:      	.word 0,0,0,0

PP0:    ; stored 2:14
	.word  16384,      0
	.word  16384,      0
	.word  16384,      0
	.word  16384,      0
	.word  -8191,  14188
	.word -14188,   8191
	.word -16384,      0
	.word -14188,  -8191
	.word  16384,      0
	.word   8192,  14188
	.word  -8191,  14188
	.word -16384,      0
	.word  16384,      0
	.word      0,  16384
	.word -16384,      0
	.word      0, -16384
	.word  -8191,  14188
	.word  -8192, -14188
	.word  16384,      0
	.word  -8191,  14188
	.word  16384,      0
	.word -14188,   8191
	.word   8192, -14188
	.word      0,  16384
	.word  16384,      0
	.word -16384,      0
	.word  16384,      0
	.word -16384,      0
	.word  -8191,  14188
	.word  14188,  -8192
	.word -16384,      0
	.word  14188,   8191
	.word  16384,      0
	.word  -8192, -14188
	.word  -8191,  14188
	.word  16384,      0
	.word  16384,      0
	.word      0, -16384
	.word -16384,      0
	.word      0,  16384
	.word  -8191,  14188
	.word   8192,  14188
	.word  16384,      0
	.word   8192, -14188
	.word  16384,      0
	.word  14188,  -8192
	.word   8191, -14188
	.word      0, -16384

	.space 4*16

MP_sequence:	.word 0, 0FFFFh, 0FFFFh
speed_flag:	.word 01h, 0Ah, 0Ch, 0Eh, 0Dh, 0Ah, 0Bh, 0Eh, 01311h
quant_addr:	.word quantize144
parse_addr:	.word parse_data144
MP_speed:	.word 0

rot_table: 	.word 0,rot1,rot2,rot3
					; rotation function jump table

;hreal:	.word	-2458,123,-2
hreal:  .word   0,0,0
himag: 	.word	0,0,0

  .sect "extdata"

points:  .space 256*16
pointadd: .word points

.end
