;*********************************************************************
;
; Filename:  GETLABEL.ASM
;
; Author:  Chris Buehler
; Date:  10/20/95
; Last revision:  11/12/95
;
;*********************************************************************
;
; Description:  Contains routines:
;	         1) get_binary_subset_label
;
; Algorithm:  Quantizes yx and yy and determines their subset.
;	      See Appendix D for explanation of algorithm.
;
;*********************************************************************
;
; Usage:  call get_binary_subset_label
;
; Inputs:  yx, yy
;
; Outputs:  yx, yy
;
;*********************************************************************
;
; Comments:  This gets a binary subset label of a point.
;
;*********************************************************************

  .mmregs
  .text

  .include macros.inc

  .global get_binary_subset_label
  .global yx,yy


get_binary_subset_label:
;//  yx = yx - 1;
;//  yx >>= 1;
  lacc	yx
  sub	#1
  sfr
  sacl	yx

;//  j1 = yx&1;
  and	#1
  sacl	temp1

;//  yy = yy - 1;
;//  yy >>= 1;
  lacc	yy
  sub	#1
  sfr
  sacl	yy

;//  j0 = (yx + yy)&1;
  add	yx
  and	#1
  sacl	temp0

;//  yx = yx>>1;
  lacc	yx
  sfr
  sacl 	yx

;//  yy = (yy - j1 - j0)>>1;
  lacc	yy
  sub	temp1
  sub	temp0
  sfr
  sacl	yy

;//  j2 = ((yx+yy)&1)^(j0&(!j1));
  add	yx
  and	#1
  sacb
  lacc	temp1
  xor	#1
  and	temp0
  xorb

;//  ACC = (j2<<2) + (j1<<1) + j0;
  sfl
  or	temp1
  sfl
  or	temp0
  ret

  .end
