;*********************************************************************
;
; Filename:  INITEVM.ASM
;
; Author:  Chris Buehler
; Date:  9/2/95
; Last revision:  11/6/95
;
;*********************************************************************
;
; Description:  Contains routines:
;	         1) initDSP
;		 2) initEVM
;
; Algorithm:  Initializes the EVM chip.
;
;*********************************************************************
;
; Usage:  call initDSP
;	       or
;	  call initEVM
;
; Inputs:  None.
;
; Outputs:  A correctly set EVM.
;
;*********************************************************************
;
; Comments:  Any changes should be mirrored in the reciever.
;
;*********************************************************************

  .mmregs

  .include macros.inc

  .global initevm, initDSP

  .text

aiccommand0  .set 0366ch	; set A = 27, A (prime) =0;
aiccommand1  .set 00001h
aiccommand2  .set 02852h	; set B = 20;
aiccommand3  .set 02a7h

initDSP:
  ldp   #0
				; turn off interrupts
  setc  INTM
  clrc  CNF
  setc  SXM
  clrc  OVM
				; set up wait states
  splk  #0, CWSR
  splk  #0, PDWSR
  splk  #05555h, IOWSR
  splk  #0h,IMR
				; set up memory mode
  splk  62, PMST        	; OVLY = 1, NDX = 1 (!), MP = 1, RAM = 1
				; we may want TRM = 1 as well

  splk  #08h,SPC        	; reset serial port
  opl   #0c0h,SPC       	; enable xmit and recv
  ret

initevm: 			; set up simple initialization
  ldp   #0

  splk  #0h, PA2        	; set AIC_RESET low
  rpt   #40h            	; wait a bit
  nop
  splk  #0,DXR          	; initialize serial port with 0
  splk  #030h, PA2      	; set AIC_RESET high

				; now got to send the AIC init commands
  lacc #3
  poll_xmit
  lacc #aiccommand0
  poll_xmit
  lacc #3
  poll_xmit
  lacc #aiccommand2
  poll_xmit
  lacc #3
  poll_xmit
  lacc #aiccommand3
  poll_xmit
  ret


  .end
