;*********************************************************************
;
; Filename:  INTS.ASM
;
; Author:  Chris Buehler, Jonas Keating
; Date:  9/20/95
; Last revision:  12/16/95
;
;*********************************************************************
;
; Description:  Contains the interrupt routines.
;
; Algorithm:  Interrupt 1 reads input from the PC, branches to the
;	      appropriate routine via a jump table, and executes the
;	      corresponding code.
;
;*********************************************************************
;
; Usage:  Just enable interupts.
;
; Inputs:  PA2 and inputs specific to each possible routine
;
; Outputs:  PA1 and outputs specific to each possible routine
;
;*********************************************************************
;
; Comments:  Each possible branch must restore AR0 before returning.
;            I1commadd contains states between interupts.
;
;*********************************************************************

  .mmregs
  .include macros.inc

MAXCOMMAND	.set    16

  .global	datastart,outbuffer
  .global       _main2
  .global	tcont,scale
  .global	xlast, ylast, ysend,xx,xy,tx,ty
  .global	xycount
  .global	int1data
  .global	int1jtable, sendx, sendy, readh,writeh, p4, p16, p24,badcommand
  .global	scaleup,scaledown,start96,start144,start192,die
  .global	data_from_PC,data_done,data_to_PC
  .global       i1comm,i1commadd, ysave, filtadd, saveAR0, go
  .global	hreal,himag
  .global	shellmask,bitstream,bitbuf,data_present

  .sect "vectors"
RS      B       _main2	       ; reset interrupt
INT1    B       _int1          ;External interrupt 1
INT2    B       _int1          ;External interrupt 2
INT3    B       _int1          ;External interrupt 3
TINT    B       _int4          ;Timer interrupt
RINT    B       _rint          ;Serial port receive interrupt
XINT    B       _xint          ;Serial port transmit interrupt
TRNT    B       _trnt          ;TDM port receive interrupt
TXNT    B       _txnt          ;TDM port transmit interrupt
INT4    B       _int1          ;External interrupt 4
	.space  14*16          ;Reserves space -- 14 words
	.space  2*16           ;Software trap routine
NMI     B       _nonmask       ;Nonmaskable external interrupt
	.space  2*16           ;Reserved space
	.space  24*16          ;12 software interrupt vectors


  .text

;interrupt handlers
_int1:
	ldpk	int1data
	sar	AR0,saveAR0
	lamm	PA2 			; check for command sent by host
	and	#1
	bcnd	i1_nocomm,EQ		; if = 0, then data accessed


	lamm	PA1			; read the sent command, clear flag
	sacl	i1comm
	bcnd	badcommand,LT		;   if command < 0 then BAD
	sub	#MAXCOMMAND
	bcnd	badcommand,GT		;   if command > MAX then BAD
					; form subroutine address
	add	#(int1jtable+MAXCOMMAND)
	samm	AR0
	mar	*,AR0
	nop
	lacc	*
	sacl	i1commadd		; save command address
i1_nocomm:
	clearmsg
	ldpk	int1data
	lacl	i1commadd		; load command address
	bacc				; branch to command address


data_to_PC:
	ldpk	int1data
	splk	#data_to_PC2, i1commadd
	splk	#(bitstream-1), filtadd
data_to_PC2:
	ldpk	int1data
	lacl	filtadd
	add	#1
	samm	AR0
	mar	*,AR0
	sacl	filtadd
	lacc	*
	samm	PA0
	lar	AR0,saveAR0
	rete

data_from_PC:
	ldpk	int1data
	lacl    data_present
	bcnd	no_data_waiting_to_send,EQ
	b       data_still_sitting_in_bitbuf
no_data_waiting_to_send:
	splk	#data_from_PC1, i1commadd
	splk	#(bitbuf-1),filtadd
data_still_sitting_in_bitbuf:
	samm	PA0
	lar	AR0,saveAR0
	rete
data_from_PC1:
	ldpk	int1data
	splk	#data_from_PC2, i1commadd
	samm	PA0
	lar	AR0,saveAR0
	rete
data_from_PC2:
	ldpk	int1data
	lacl	filtadd
	add	#1
	samm	AR0
	mar	*,AR0
	sacl	filtadd
	lamm	PA0
	sacl	*
	lar	AR0,saveAR0
	rete

data_done:
	ldpk	int1data
	splk	#1,data_present		; flag data waiting to send
	samm	PA0
	lar	AR0,saveAR0
	rete

start96:
	ldpk	int1data
	splk	#1,go
	samm	PA0
	splk	#sendx,i1commadd
	lar	AR0,saveAR0
	rete
start144:
	ldpk	int1data
	splk	#2,go
	samm	PA0
	splk	#sendx,i1commadd
	lar	AR0,saveAR0
	rete
start192:
	ldpk	int1data
	splk	#3,go
	samm	PA0
	splk	#sendx,i1commadd
	lar	AR0,saveAR0
	rete
die:
	ldpk	int1data
	splk	#0,go
	samm	PA0
	splk	#sendx,i1commadd
	lar	AR0,saveAR0
	rete

scaleup:
	ldpk	datastart
	lacl	scale
	add	#1
	sacl	scale
	samm	PA0
	ldpk	int1data
	lar	AR0,saveAR0
	rete

scaledown:
	ldpk	datastart
	lacl	scale
	bcnd	scale_zero,EQ
	sub	#1
	sacl	scale
scale_zero:
	samm	PA0
	ldpk	int1data
	lar	AR0,saveAR0
	rete

p4:
	ldpk	datastart
	splk	#0,shellmask
	samm	PA0
	ldpk	int1data
	lar	AR0,saveAR0
	rete
p16:
	ldpk	datastart
	splk	#3,shellmask
	samm	PA0
	ldpk	int1data
	lar	AR0,saveAR0
	rete
p24:
	ldpk	datastart
	splk	#7,shellmask
	samm	PA0
	ldpk	int1data
	lar	AR0,saveAR0
	rete
sendx:
	ldpk	datastart
	lacl	tx
	samm	PA0
	lacl	ty
	ldpk	int1data
	sacl	ysave
	splk	#sendy, i1commadd
	lar	AR0,saveAR0
	rete
sendy:
	ldpk	int1data
	lacl	ysave
	samm	PA0
	splk	#sendx, i1commadd
	lar	AR0,saveAR0
	rete
readh:
	ldpk	int1data
	splk	#readh2, i1commadd
	splk	#(hreal-1), filtadd
readh2:
	ldpk	int1data
	lacl	filtadd
	add	#1
	samm	AR0
	mar	*,AR0
	sacl	filtadd
	lacc	*
	samm	PA0
	lar	AR0,saveAR0
	rete
writeh:
	ldpk	int1data
	splk	#writeh2, i1commadd
	splk	#(hreal-1),filtadd
	samm	PA0
	lar	AR0,saveAR0
	rete
writeh2:
	ldpk	int1data
	lacl	filtadd
	add	#1
	samm	AR0
	mar	*,AR0
	sacl	filtadd
	lamm	PA0
	sacl	*
	lar	AR0,saveAR0
	rete

badcommand:
	ldpk	int1data
	lacc	#badcommand
	sacl	i1commadd
	lacc	#666
	samm	PA0
	lar	AR0,saveAR0
	rete


_int2:  rete
_int3:  rete
_tint:  rete
_rint:  rete
_xint:
	mar     *,AR5                   ; set ARP to int counter (AR5)
	banz	ar5notzero,*,AR5
	b       ar5zero
ar5notzero:
	mar     *-,AR3                  ; decrement counter, set ARP to AR3
					; (the output buffer)
ar5zero:mar	*,AR3
	ldpk	scale
	lacc    *+,2                    ; load output value, shifted by 2

	sfr				;   also increments output pointer
	rpt	scale
	  sfl
	samm    DXR                     ; send output to serial port
	cmpr    2                       ; check to see if output pointer
					;   is past end of buffer (ARCR = end)
	bcnd    nochange, NTC
	lar     AR3, #outbuffer         ; if past, reload with beginning of
					;  buffer
nochange:
	rete

_trnt:  rete
_txnt:  rete
_int4:  rete
_nonmask:      rete


.end

