/* Linker command file for C206 bootloader  */

MEMORY
{

PAGE 0: /* PM  */

/*EX1_PM  :ORIGIN=0H   ,  LENGTH=0fdffH   2K external RAM */

B0_PM   :ORIGIN=0000H, LENGTH=0350H  /* BLOCK MAP IN CNF=1 */
B0_PM1  :ORIGIN=0400H, length=0300H

PAGE 1: /* DM  */

REGS    :ORIGIN=0H   ,  LENGTH=60H    /* MEM-MAPPED REGS */
BLK_B2  :ORIGIN=60H  ,  LENGTH=20H    /* BLOCK B2  */
BLK_B0  :ORIGIN=100H ,  LENGTH=200H   /* BLOCK B0, */
BLK_B1  :ORIGIN=300H ,  LENGTH=200H   /* BLOCK B1  */
EX1_DM  :ORIGIN=0800H,  LENGTH=7800H /* EXTERNAL DATA RAM */
GM_DM   :ORIGIN=8000H,  LENGTH=8000H /*EXTERNAL DATA RAM AS GLOBAL */

PAGE 2: /* I/O SPACE */
IO_IN   :ORIGIN=0FFF0H, LENGTH=0FH    /* I/O MAPPED PERIPHERAL */
IO_EX   :ORIGIN=0000H,  LENGTH=0FFF0H /* EXT.I/O MAPPED PERIPHERAL */

                               
}

SECTIONS

{
        vectors   :{}  > B0_PM   PAGE 0
        bootload  :{}  > B0_PM   PAGE 0
        alaw      :{}  > B0_PM1  PAGE 0
        ulaw      :{}  > B0_PM1  PAGE 0

/*        .bss    :{}  > EX1_DM   PAGE 1 */
	   new    :{}  > BLK_B2   PAGE 1
          .data   :{}  > 0x1100   PAGE 1
}
