;*H*************************************************************************
; TI Proprietary Information - Internal Data
; Copyright (c) 1993-1999, Texas Instruments Incorporated
; All rights reserved
;***************************************************************************
;***************************************************************************
;
; DESCRIPTION:
;
;     Truely inclusive monitor include file
;       for C25LP HLL Real-Time Debugger.
;
;     This real-time monitor was developed by H.Roland Hoar.
;
; STATUS:
;
;     This monitor version is dated 24th of June 1997.
;     It is intended for use with HLL Debugger versions "1.19" or later.
;     The MON_RELEASE mnemonic has the hexadecimal value '1019'.
;
;     This document has page feed characters spaced for 66 lines per page.
;     Its page alignment is adjusted to ensure
;         attractive two-page-per-sheet printing.
;
;***************************************************************************
;
               .page 
;***************************************************************************
; GLOBAL DECLARATIONS
;***************************************************************************
               .global  MON_SE_CNFG, MON_RT_CNFG, MON_GO, MON_RESET
               .global  MON_EINTR, MON_ETRAP
               .global  MON_TRAP_ENTRY, MON_INTR_ENTRY, MON_ENTRY
               .global  MON_WAIT, MON_WAIT_B2
               .global  MON_TRAP_VEC
               .global  MON_PGE0_DP, MON_RGST_DP
               .global  MON_TEMP_PC, MON_TEMP_ST0, MON_TEMP_ST1
               .global  MON_TEMP_ACCL, MON_TEMP_ACCH
               .global  MON_ACCL, MON_ACCH
               .global  MON_ST0_SAVE, MON_IMR_SAVE
               .global  MON_TWO_SAVE, MON_INT_MSK
               .global  MON_START, MON_STOP
               .global  MON_ROOT, MON_RELEASE, MON_POINTER
;
               .page 
;***************************************************************************
; REALTIME DECLARATIONS
;***************************************************************************
;
;---------------------------------------------------------------------------
; Configure selected interrupts so that if they are in the enabled state
; on entry to the monitor, they will be disabled within the monitor and
; re-enabled on exit from the monitor.
;
; This behaviour allows the user to breakpoint and single-step the
; service routines corresponding to interrupts that are disabled
; within the monitor.
;
; The MON_USER_INTx mnemonics select which interrupts shall be manipulated:
;   A zero value selects them for possible disabling/enabling.
;   A one value leaves them unaffected.
; Don't get confused, remember that MON_USER_INTx occupies bit x-1
; in the Interrupt Mask and Flag Registers in the low data memory space.
; 
; The default is to always disable/enable the Emulation Interrupt (INT7),
; and to not manipulate the other user interrupts.
;---------------------------------------------------------------------------
MON_USER_INT1          .set  1 ; Default is to be unaffected.
MON_USER_INT2          .set  1 ; Default is to be unaffected.
MON_USER_INT3          .set  1 ; Default is to be unaffected.
MON_USER_INT4          .set  1 ; Default is to be unaffected.
MON_USER_INT5          .set  1 ; Default is to be unaffected.
MON_USER_INT6          .set  1 ; Default is to be unaffected.
MON_USER_INT7          .set  0 ; This is the emulation interrupt.
MON_USER_INT8          .set  1 ; Default is to be unaffected.
;
               .page 
;---------------------------------------------------------------------------
; Configure the monitor to either have its MON_EINTR_VECS and MON_ETRAP_VECS
; macros placed directly in the interrupt vector table at the bottom
; of program memory: or have branch instructions that lead to the
; macros placed in the interrupt vector table.
;
; If the interrupt latency must be minimised, then option MON_VECTOR_MACRO
; should be used. In this case the two macros are manually placed
; in the fixed ROM-based interrupt vector table at the bottom of
; program memory, with statements such as:
;
;   MON_EINTR  mon_eintr_vecs ; this macro is located at 0x000E@prgm.
;                             ; it uses 14 words in the vector table.
;                             ; thus it replaces 7 branch instructions.
;
;   MON_ETRAP  mon_etrap_vecs ; this macro is located at 0x0026@prgm.
;                             ; it uses 8 words in the vector table.
;                             ; thus it replaces 4 branch instructions.
;
; If a re-mappable interrupt vector table is required, at the expense
; of interrupt latency, then option MON_VECTOR_BRANCH should be used
; to automatically include the macros in the monitor itself.
; When a re-mappable vector table is used, the fixed branch instructions
; in the ROM-based vector table do not lead directly to target routines,
; instead they lead to an intermediate RAM-based vector table with
; branch operands that can be modified as required by the user.
; In this case two branch instructions must be manually placed
; in the fixed ROM-based interrupt vector table at the bottom
; of program memory.  These two branches may reach the macros
; indirectly via the RAM-based vector table at the cost of
; additional interrupt latency.  They may also bypass the second
; vector table and lead directly to the macros as shown below:
;
;              B  MON_EINTR   ; this branch is located at 0x000E@prgm.
;                             ; it uses 2 words in the vector table.
;
;              B  MON_ETRAP   ; this macro is located at 0x0026@prgm.
;                             ; it uses 2 words in the vector table.
;
; The default is to require the macros to be in the vector table so as
; to minimise interrupt latency on entering and exiting the monitor.
;---------------------------------------------------------------------------
MON_VECTOR_MACRO       .set 0
MON_VECTOR_BRANCH      .set 1
MON_VECTOR             .set MON_VECTOR_MACRO ; <- Edit only this line.
;
               .page 
;---------------------------------------------------------------------------
; Configure the monitor to ensure the Interrupt Mode bit (INTM) in the
; Status Register #0 (ST0) is always cleared (interrupts enabled) on
; entry to the monitor, or its value is unaltered on entry to the monitor.
; In understanding this option first remember that the INTM bit is never
; altered while in the monitor, or on exit from it.
;
; The option MON_INT_ALTR_ENB configures the monitor so that the INTM bit
; is always cleared (enabled) on entry to the monitor. Then when the
; HLL Debugger is used to interactively STEP or RUN/HALT code containing
; a DINT instruction, the DINT instruction will have no effect.
; So the interrupt service routines will remain enabled.
;
; The option MON_INT_ALTR_NOT configures the monitor so that the INTM bit
; is not altered on entry to the monitor. Then when the HLL Debugger is
; used to interactively STEP or RUN/HALT code containing a DINT
; instruction, the DINT instruction will disable all interrupts.
; So the interrupt service routines will be disabled until a later EINT
; instruction is reached by a later STEP or RUN/HALT in the HLL Debugger.
;
; The default is always clear (enable) the INTM bit on entering the monitor.
;---------------------------------------------------------------------------
MON_INT_ALTR_NOT       .set  0 ; 
MON_INT_ALTR_ENB       .set  1 ; This option adds one word of code.
MON_INT_ALTR           .set  MON_INT_ALTR_ENB ; <- Edit only this line.
;
;---------------------------------------------------------------------------
; Configure the location in data memory of the up to 17 words used to
; store-to and load-from the values that represent the image of the
; application's register values. They are either: located explicitly in
; page zero, or anywhere in data memory. This is done by setting MON_RGST
; to be MON_RGST_ZRO or MON_RGST_ANY respectively.
;
; The value chosen must match the location of the section "mon_rgst" that
; represents these registers. This is specified in the linker command file.
;
; Use of page zero cuts the size of the monitor code, reduces the
; manipulation of the DP and ST1-0 registers, and shortens the length of
; ETRAP/ERET protected code, but takes a big chunk of block B2 in page zero.
;
; The default of page zero is a smaller monitor.
;---------------------------------------------------------------------------
MON_RGST_ZRO           .set 0
MON_RGST_ANY           .set 1 ; This option adds 9 words of code.
MON_RGST               .set MON_RGST_ZRO ; <- Edit only this line.
;
;---------------------------------------------------------------------------
; Configure the monitor to use a particular auxilliary register for its
; indirect addressing operations. The monitor code will hide its use of
; this register within ETRAP/ERET sequences that disable all interrupts
; (including the NMI) and save/restore the value.
;
; The default is to use 0 (AR0).
; It is unlikely that there is any reason to change this option.
;---------------------------------------------------------------------------
MON_AR_VALUE           .set 0 ; The acceptable values are 0-7.
;
               .page 
;---------------------------------------------------------------------------
; Configure the monitor to exclude the code for accessing the IO memory
; space or include it if the application does access that memory.
;
; The option MON_IO_MAP_USE_NOT disables access to the IO memory space
; by the monitor. This option is recognised by the HLL Debugger which will
; then discard attempts to write and read this memory.  This option has
; the advantage of minimising the monitors size and avoids the tedium of
; allocating patches of RAM for monitor use.
;
; The option MON_IO_MAP_USE_RAM requires that there be three words of RAM
; available, at any fixed location in program memory, for the sole use of
; the monitor.  These words are represented by the section named "mon_ioio"
; in the monitor source and linker command files.  This option has the
; advantage of no effect on the interrupt latency, but the disadvantge
; that B0 may not be used if the application switches it between low data
; memory and high program memory. This option is of obvious use when the
; monitor is loaded into RAM when developing or debugging an application.
;
; The option MON_IO_MAP_USE_ROM requires that there be three words of bank
; B0 RAM available, for the sole use of the monitor. The application may
; freely switch B0 between low data memory and high program memory. These
; three words are represented by the sections named "mon_b0p0" and
; "mon_b0p1" for program and data memory, in the monitor source and linker
; command files.  This option is of obvious use when the monitor is
; embedded in ROM, as bank B0 RAM is available on all devices.  It has the
; disadvantage of increasing the interrupt latency and monitor size.
;
; The default is to not access any IO memory space.
;---------------------------------------------------------------------------
MON_IO_MAP_USE_NOT     .set 00000h
MON_IO_MAP_USE_RAM     .set 00002h ; This option adds 17 words of code.
MON_IO_MAP_USE_ROM     .set 00003h ; This option adds 27 words of code.
MON_IO_MAP_USE         .set MON_IO_MAP_USE_NOT ; <- Edit only this line.
;
               .page 
;---------------------------------------------------------------------------
; Configure the monitor include the code for auto-incrementing addresses
; so as to increase its speed, or exclude the code and reduce its size.
;
; The option MON_AUTO_INC_NONE excludes all monitor code that supports
; blind or controlled auto-incrementing of its address buffer.  This
; cuts the monitor size by 6 words.  The HLL Debugger must explicitly
; communicate an address value to the monitor before almost every access.
; This reduces, by a third to a half, the speed of memory downloads and
; window updates.
;
; The option MON_AUTO_INC_BASIC excludes the monitor code that supports
; controlled auto-incrementing of its address buffer.  It includes the
; code that supports blind auto-incrementing after every memory access.
; This cuts the monitor size by 3 words.  The HLL Debugger only needs
; to communicate an initial address value to the monitor at the start
; of block transfers such as window updates and memory downloads.
; During internal operation of the HLL Debugger there is a need to
; repeatidly access the same memory location. These operations must
; explicitly supply the monitor with an address before every access.
; This slightly reduces the speed of the HLL Debugger and monitor.
;
; The option MON_AUTO_INC_EXTRA includes all monitor code that supports
; both blind and controlled auto-incrementing of its address buffer.
; The HLL Debugger only needs to communicate the minimum number of
; address values to the monitor, both at the start of block transfers
; such as window updates and memory downloads, and at the start of
; internal operation of the HLL Debugger that repeatidly access the
; same memory location.  This maximises the speed of the HLL debugger
; and monitor by minimising the number of address values that need
; to be communicated by the HLL debugger to the monitor.
;
; The default of MON_AUTO_INC_EXTRA is a faster but larger monitor.
;---------------------------------------------------------------------------
MON_AUTO_INC_NONE      .set 00000h ; This option cuts 6 words of code.
MON_AUTO_INC_BASIC     .set 00008h ; This option cuts 3 words of code.
MON_AUTO_INC_EXTRA     .set 0000Ch
MON_AUTO_INC           .set MON_AUTO_INC_EXTRA ; <- Edit only this line.
;
               .page 
;---------------------------------------------------------------------------
; Configure the error detection.
;
; This option is implemented in the monitor but not yet in the HLL Debugger.
; With the release 1.07-1.19 HLL Debugger's the default value must be used.
;
; As of Release 1.19 on 24th June '97 I think this option will probably not
; be implemented in the HLL Debugger because no-one expresses interest.
;
; The default of none is a smaller monitor.
;---------------------------------------------------------------------------
MON_ERROR_CHECK_NONE   .set 00000h
MON_ERROR_CHECK_BASIC  .set 00020h
MON_ERROR_CHECK_EXTRA  .set 00030h
MON_ERROR_CHECK        .set MON_ERROR_CHECK_NONE ; <- Edit only this line.
;
               .page 
;---------------------------------------------------------------------------
; Configure the MON_RT_CNFG routine and the location of the "mon_etrap"
; macro that are used to initialise the message passing logic and to
; signal the occurence of a reset to the HLL Debugger.
;
; Because of this the user cannot set software or hardware breakpoints in
; any code that is executed before MON_RT_CNFG and "mon_etrap".
;
; The communication initiated between the HLL Debugger and monitor when
; this code is executed takes a relatively long time (1-2ms), thus the
; user may need to place them after time critical initialisation routines.
;
; To establish communication between the HLL Debugger and monitor requires
; the execution of the MON_RT_CNFG routine first, and then possibly the
; "mon_etrap" macro. The interrupts must also be globally enabled, but
; at a time convienent for the application.
;
; If the MON_RESET_MESG_DEFAULT option is chosen then the "mon_etrap" macro
; macro is placed in the MON_RT_CNFG routine with the message passing
; initialisation code.  This makes for simple monitor installation,
; This is also the most extensively tested option and in realtime operation
; provides solid breakpoint behaviour and reliable reset recovery.
;
; If the MON_RESET_MESG_CUSTOM option is chosen then the "mon_etrap" macro
; and its following NOP labelled MON_RESET are excluded from the code
; for MON_RT_CNFG. The user must explicitly add then to later user code.
;
; If the MON_RESET_MESG_FLOW option is chosen then the "mon_etrap" macro
; and its following NOP labelled MON_RESET are excluded from the code
; for MON_RT_CNFG. They are not relocated anywhere else.
; Extra code is added to MON_RT_CNFG and MON_SE_CNFG to initialise the
; message passing logic.  The deletion in MON_RT_CNFG is to allow the
; user to RUN or GO through the MON_RT_CNFG routine in stopmode without
; entering the monitor at "mon_etrap" and hanging in an endless loop at
; MON_WAIT.
;
; The default MON_RESET_MESG_DEFAULT is easiest to install and understand.
; The other options should not be used without prior discussion with me.
;---------------------------------------------------------------------------
MON_RESET_MESG_DEFAULT .set 00000h
MON_RESET_MESG_CUSTOM  .set 00080h
MON_RESET_MESG_FLOW    .set 000C0h
MON_RESET_MESG         .set MON_RESET_MESG_DEFAULT ; <- Edit only this line.
;
               .page 
;---------------------------------------------------------------------------
; Configure the manner in which the monitor saves the PC, ST0 & ST1,
; ACCL & ACCH when the monitor is entered via emulation interrupt or trap.
; These registers are always are saved and restored inside the ETRAP/ERET
; protected code at monitor entry and exit, thus ensuring an exact snapshot
; of them is taken and given at these times.
;
; If the MON_CORE_EXACT option is chosen then the snapshots of the
; core CPU registers (which were saved inside the ETRAP protected code,
; at monitor entry) are also copied to their final locations inside ETRAP
; protected code.  The disadvantage is that the duration of the protected
; code is increased by about 10 cycles.
;
; If the MON_CORE_LAZY option is chosen then the snapshots of the
; core CPU registers (which were saved inside the ETRAP protected code,
; at monitor entry) are copied to their final locations outside ETRAP
; protected code.  The advantage is that the duration of the protected
; code is not increased.
;
; The default is to be lazy and reduce the duration of the ETRAP/ERET code.
; This default should not need to be changed in normal operation, it is
; provided mostly to give flexibility if debugging the monitor itself.
;---------------------------------------------------------------------------
MON_CORE_EXACT         .set 00000h
MON_CORE_LAZY          .set 00100h
MON_CORE               .set MON_CORE_LAZY ; <- Edit only this line.
;
;---------------------------------------------------------------------------
; Configure the manner in which the monitor saves and restores the image
; of the applications's CPU register values to optimise accuracy or
; ETRAP/ERET latency. The ACC and ST1-0 are always saved and restored
; in ETRAP/ERET protected code.
;
; If the MON_FULL_EXACT option is chosen then the full CPU registers
; (TOS, PLO, PHI, TREG, AR0-7) are saved and restored inside the ETRAP/ERET
; protected code at monitor entry and exit, thus ensuring an exact snapshot
; of them is taken and given at these times. The disadvantage is that the
; duration of the protected code increases by about 15 cycles each.
; 
; If the MON_FULL_LAZY option is chosen then the full CPU registers
; (TOS, PLO, PHI, TREG, AR0-7) are saved and restored outside the ETRAP/ERET
; protected code at monitor entry and exit, this means that the values of
; these registers may have been modified by interrupt driven service routines
; and so are an inexact snapshot of their values at monitor entry and exit.
; The advantage is that the duration of the protected code is not increased.
;
; The default is to be lazy and reduce the duration of the ETRAP/ERET code.
; This default should not need to be changed in normal operation, it is
; provided mostly to give flexibility if debugging the monitor itself.
;---------------------------------------------------------------------------
MON_FULL_EXACT         .set 00000h
MON_FULL_LAZY          .set 00200h
MON_FULL               .set MON_FULL_LAZY ; <- Edit only this line.
;
               .page 
;---------------------------------------------------------------------------
; Configure the monitor to include the system emulator device's
; configuration routine MON_SE_CNFG and the table MON_SE_VALUE
; that it uses in the "mon_main" section (MON_SE_CNFG_USE_YES)
; so that the user can call MON_SE_CNFG in his reset code to
; initialise a system emulator device.
;
; Alternatively all this can be excluded if the monitor is to be used
; in an ordinary produstion device (MON_SE_CNFG_USE_NOT). In this case
; MON_SE_CNFG is reduced to a RET instruction and the table MON_SE_CNFG
; is eliminated entirely.
;
; The default is to not include the configuration routine and table.
;---------------------------------------------------------------------------
MON_SE_CNFG_USE_NOT    .set 00000h
MON_SE_CNFG_USE_YES    .set 00400h ; This option adds 31 words of code.
MON_SE_CNFG_USE        .set MON_SE_CNFG_USE_NOT ; <- Edit only this line.
;
               .page 
;---------------------------------------------------------------------------
; Configure the monitor to wait for permission from the application's
; interrupt driven code, before performing certain HLL Debugger commands:
;
;     STOPMODE       "STOP", exit realtime and enter stopmode,
;     STEP-n, RUN-n  "SNGL", single-step or single-run,
;     RUN, UPDATE    "EVER", run-forever or window update while running.
;
; If the monitor is to be configured to never wait, then set MON_WAIT_USE
; to MON_WAIT_USE_NOT, in which case the four wait options will be ignored
; and the MON_WAIT_B2 memory location will not be used.
;
; The default is to not wait before any of the stop,
; single-step/single-run or run-forever commands.
;---------------------------------------------------------------------------
MON_WAIT_USE_NOT       .set 00000h
MON_WAIT_USE_YES       .set 00800h ; This option adds 9 words of code.
MON_WAIT_USE           .set MON_WAIT_USE_NOT ; <- Edit only this line.
;
MON_WAIT_STOP_NOT      .set 00000h
MON_WAIT_STOP_YES      .set 01000h
MON_WAIT_STOP          .set MON_WAIT_STOP_NOT ; <- Edit only this line.
;
MON_WAIT_SNGL_NOT      .set 00000h
MON_WAIT_SNGL_YES      .set 02000h
MON_WAIT_SNGL          .set MON_WAIT_SNGL_NOT ; <- Edit only this line.
;
MON_WAIT_EVER_NOT      .set 00000h
MON_WAIT_EVER_YES      .set 04000h
MON_WAIT_EVER          .set MON_WAIT_EVER_NOT ; <- Edit only this line.
;
               .page 
;---------------------------------------------------------------------------
; Configure the monitor to support C2XX devices
; with extended addressing in program memory.
;
; The MON_XTND_PROG options are used to decide if the monitor
; will support an extended data memory address space.
;
; If the MON_XTND_PROG_OFF option is chosen then extended addressing in
; program memory is disabled. This option should be chosen if the monitor
; is being installed with a C2XX device that does not include extra
; hardware to implement extended addressing in program memory. In this case
; the MON_PMAP_PAGE, MON_PMAP_ADDR and MON_PMAP_VALU options are ignored.
;
; If the MON_XTND_PROG_ON option is chosen then extended addressing in
; program memory is enabled. This option should be chosen if the monitor
; is being installed with a C2XX device that does include extra hardware
; to implement extended addressing in program memory. In this case the
; MON_PMAP_PAGE, MON_PMAP_ADDR and MON_PMAP_VALU options are also used.
;
; The MON_PMAP_ADDR and MON_PMAP_PAGE options are used to specify
; the address of the program memory mapping register in the program,
; data or io memory spaces.
;
; The default is to not support extended addressing in program memory.
;---------------------------------------------------------------------------
MON_XTND_PROG_OFF      .set 00000h
MON_XTND_PROG_ON       .set 00008h ; This option adds 26 words of code.
MON_XTND_PROG          .set MON_XTND_PROG_OFF ; <- Edit only this line.
;
MON_PMAP_PAGE_PROG     .set 00000h
MON_PMAP_PAGE_DATA     .set 00001h
MON_PMAP_PAGE_IO       .set 00002h
MON_PMAP_PAGE          .set MON_PMAP_PAGE_IO ; <- Edit only this line.
;
MON_PMAP_ADDR          .set 08000h ; <- Edit only this line.
;
               .page 
;---------------------------------------------------------------------------
; Configure the monitor to support C2XX devices
; with extended addressing in data memory.
;
; The MON_XTND_DATA options are used to decide if the monitor
; will support an extended data memory address space.
;
; If the MON_XTND_DATA_OFF option is chosen then extended addressing in
; data memory is disabled. This option should be chosen if the monitor
; is being installed with a C2XX device that does not include extra
; hardware to implement extended addressing in data memory. In this case
; the MON_DMAP_PAGE, MON_DMAP_ADDR and MON_DMAP_VALU options are ignored.
;
; If the MON_XTND_DATA_ON option is chosen then extended addressing in
; data memory is enabled. This option should be chosen if the monitor
; is being installed with a C2XX device that does include extra hardware
; to implement extended addressing in data memory. In this case the
; MON_DMAP_PAGE, MON_DMAP_ADDR and MON_DMAP_VALU options are also used.
;
; The MON_DMAP_ADDR and MON_DMAP_PAGE options are used to specify
; the address of the data memory mapping register in the program,
; data or io memory spaces.
;
; The default is to not support extended addressing in data memory.
;---------------------------------------------------------------------------
MON_XTND_DATA_OFF      .set 00000h
MON_XTND_DATA_ON       .set 00008h ; This option adds 26 words of code.
MON_XTND_DATA          .set MON_XTND_DATA_OFF ; <- Edit only this line.
;
MON_DMAP_PAGE_PROG     .set 00000h
MON_DMAP_PAGE_DATA     .set 00001h
MON_DMAP_PAGE_IO       .set 00002h
MON_DMAP_PAGE          .set MON_DMAP_PAGE_IO ; <- Edit only this line.
;
MON_DMAP_ADDR          .set 08001h ; <- Edit only this line.
;
               .page 
;***************************************************************************
; GLOBAL DECLARATIONS
;***************************************************************************
;
;---------------------------------------------------------------------------
; Define extended addressing mnemonics MON_XTND_EITHER and MON_XTND_BOTH.
;
; This should not be modified.
;---------------------------------------------------------------------------
MON_XTND_OFF   .set   0
MON_XTND_ON    .set   1
               .eval  MON_XTND_OFF, MON_XTND_EITHER
               .eval  MON_XTND_OFF, MON_XTND_BOTH
;
               .if (MON_XTND_PROG == MON_XTND_PROG_ON)
               .eval  MON_XTND_ON, MON_XTND_EITHER
               .endif ; (MON_XTND_PROG == MON_XTND_PROG_ON)
               .if (MON_XTND_DATA == MON_XTND_DATA_ON)
               .eval  MON_XTND_ON, MON_XTND_EITHER
               .endif ; (MON_XTND_PROG == MON_XTND_DATA_ON)
;
               .if (MON_XTND_DATA == MON_XTND_DATA_ON)
               .if (MON_XTND_PROG == MON_XTND_PROG_ON)
               .eval  MON_XTND_ON, MON_XTND_BOTH
               .endif ; (MON_XTND_PROG == MON_XTND_PROG_ON)
               .endif ; (MON_XTND_PROG == MON_XTND_DATA_ON)
;
               .if (MON_XTND_EITHER == MON_XTND_ON)
               .asg MON_TWO_SAVE, MON_IMR_SAVE
               .asg MON_TWO_SAVE, MON_ST0_SAVE
               .endif ; (MON_XTND_EITHER == MON_XTND_ON)
;
               .page 
;---------------------------------------------------------------------------
; Define global symbols for debug purposes.
;
; This should not be modified.
;---------------------------------------------------------------------------
MON_DEBUG_NOT  .set 0
MON_DEBUG_YES  .set 1 
MON_DEBUG      .set MON_DEBUG_NOT
;
               .if (MON_DEBUG)
               .global  PRM_CMND
               .global  PRM_ADRS
               .global  PRM_XTND
               .global  MON_MACHINE 
               .global  MON_STATUS
               .global  MON_TRAP_VEC
               .global  MON_IMR_SAVE
               .global  MON_ST0_SAVE
               .global  MON_TWO_SAVE
               .global  MON_WAIT_B2
               .global  MON_TEMP0
               .global  MON_TEMP1
               .global  MON_TEMP2
               .global  MON_TEMP3
               .global  MON_TEMP4
               .endif ; (MON_DEBUG)
;
               .if (MON_DEBUG)
               .global  MON_PC
               .global  MON_ST0
               .global  MON_ST1
               .global  MON_PLO
               .global  MON_PHI
               .global  MON_TREG
               .global  MON_TOS
               .global  AUXREG0
               .global  AUXREG1
               .global  AUXREG2
               .global  AUXREG3
               .global  AUXREG4
               .global  AUXREG5
               .global  AUXREG6
               .global  AUXREG7
               .global  MON_PMAP
               .global  MON_DMAP
               .endif ; (MON_DEBUG)
;
               .if (MON_DEBUG)
               .global  MON_UNUSED, MON_ADRDWR
               .global  MON_PMRD, MON_PMWR
               .global  MON_DMRD, MON_DMWR
               .global  MON_IORD, MON_IOWR
               .global  MON_QUICKGO, MON_EXECUTE, MON_EXIT
               .global  MON_XTND_PROG, MON_XTND_DATA, MON_XTND_EITHER
               .global  MON_SAVE_CORE, MON_SAVE_FULL
               .endif ; (MON_DEBUG)
;
               .page 
;***************************************************************************
; REALTIME MACROS
;***************************************************************************
;
;---------------------------------------------------------------------------
; Define MON_ESTOP macro.
;
; This macro should not be modified
;---------------------------------------------------------------------------
mon_estop      .macro
               .word   0be90h
               .endm
;
;---------------------------------------------------------------------------
; Define MON_ETRAP macro.
;
; This macro should not be modified
;---------------------------------------------------------------------------
mon_etrap      .macro
               .word   0beb7h ; was 0beb7h
               .endm
;
;---------------------------------------------------------------------------
; Define MON_ERET macro.
;
; This macro should not be modified.
;---------------------------------------------------------------------------
mon_eret       .macro
               .word   0be96h ; was 0be96h
               .endm
;
               .page 
;***************************************************************************
; This page is intentionally left blank.
;***************************************************************************
;
               .page 
;---------------------------------------------------------------------------
; This is MON_EINTR_VECS macro for the code that is to be located in the
; interrupt vector table between addresses 0x000E - 0x001B at the
; low end of the program memory space. It occupies fourteen words.
;
; The location this macro is placed at should be labelled MON_EINTR.
;
; This macro must not be located anywhere other than at address 0x000E.
; This macro must not be modified.
;---------------------------------------------------------------------------
mon_eintr_vecs .macro
;              Begin the vector 0x000E - 0x001B code.
;
               SST   #0, MON_TEMP_ST0 ; Save ST0
               SST   #1, MON_TEMP_ST1 ; Save ST1
               LDP   #MON_PGE0_DP     ; Set DP to PAGE0.
               POPD  MON_TEMP_PC      ; Save the PC.
;
               .if (MON_RGST == MON_RGST_ANY)
               SACL  MON_TEMP_ACCL    ; Save the low accumalator.
               SACH  MON_TEMP_ACCH    ; Save the high accumalator.
               .endif
               .if (MON_RGST == MON_RGST_ZRO)
               SACL  MON_ACCL         ; Save the low accumalator.
               SACH  MON_ACCH         ; Save the high accumalator.
               .endif
;
               LACL  IMR              ; Disable selected interrupts.
               SACL  MON_IMR_SAVE     ;
               ANDK  #(MON_INT_MSK)   ;
               SACL  IMR              ;
;
               EINT                   ; Enable interrupts.
;
               B     MON_INTR_ENTRY   ; Go to the fixed entry point
                                      ; for emulation interrupts.
;
;              End the vector 0x000E - 0x001B code.
               .endm
;
               .page 
;---------------------------------------------------------------------------
; This is MON_ETRAP_VECS macro for the code that is to be located in the
; interrupt vector table between addresses 0x0026 - 0x002D at the
; low end of the program memory space. It occupies eight words.
;
; The location this macro is placed at should be labelled MON_ETRAP.
;
; Note that single-step/run, software breakpoint and ETRAP opcodes
; that cause entry into this code do not affect the global interrupt
; status status bit, thus the EINT used in the vector "mon_eintr_vecs"
; macro is not required here.
;
; The HLL Debugger requires the mnemonics MON_RELEASE and MON_POINTER to
; be located at MON_ROOT (addresses 0x002C and 0x002D in program memory).
;
; This macro must not be located anywhere other than at address 0x0026.
; This macro must not be modified.
;---------------------------------------------------------------------------
mon_etrap_vecs .macro
;              Begin the vector 0x0026 - 0x002D code.
;
               SST   #0, MON_TEMP_ST0 ; Save ST0
               SST   #1, MON_TEMP_ST1 ; Save ST1
               LDP   #MON_PGE0_DP     ; Set DP to PAGE0.
               POPD  MON_TEMP_PC      ; Save the PC.
                                      ; Note we cannot save it directly
                                      ; to MON_PC if MON_RGST_ZRO as this
                                      ; macro is used inside the monitor.
;
               PSHD  MON_TRAP_VEC     ; Load the emulation trap vector.  
               RET                    ; Go to the variable entry point
                                      ; for emulation traps, whose
                                      ; default value is MON_TRAP_ENTRY.
;
MON_ROOT       .word MON_RELEASE      ; Release number of the monitor.
               .word MON_POINTER      ; Pointer to monitor constants.
;
;              End the vector 0x0026 - 0x002D code.
               .endm
;
