;===========================================================================
; Module Name: 	FC_PWM_O_DRV	
;
; File Name:	pwmodrv.asm					
;                  
; Description:		
;
;			|~~~~~~~~~~~~~~~|
;	Mfunc_c1o------>|		|----->o  CMPR1 (EV register)
;	Mfunc_c2o------>|FC_PWM_O_DRV	|----->o  CMPR2 (EV register)
;	Mfunc_c3o------>|		|----->o  CMPR3 (EV register)
;	Mfunc_p	o------>|		|----->o  T1PER (EV register)
;	limit	o------>|		|
;			|_______________|
;
;
; Target dependency:	x240/243/2407 Event Manager Timer1 & Full Compare
; To Select the target device see x24x_app.h file.
;
;
;
; History:
;
; Last Update: 7-11-2000
;===========================================================================
;(To use this Module, copy this section to main system file)
;		.ref	FC_PWM_O_DRV
;		.ref	FC_PWM_O_DRV_INIT			;function call
;		.ref	Mfunc_c1, Mfunc_c2, Mfunc_c3, Mfunc_p	;Inputs
;		.ref	limit					;Input
;	Note: CMPR1, CMPR2, CMPR3, T1PER are defined in .h file
;===========================================================================
;Module definitions for external reference.
		.def	FC_PWM_O_DRV				;function call
		.def	FC_PWM_O_DRV_INIT			;function call
		.def	Mfunc_c1, Mfunc_c2, Mfunc_c3, Mfunc_p	;Inputs
		.def	limit					;Input
;===========================================================================
		.include	x24x_app.h



Mfunc_c1		.usect "pwmodrv",1 	
Mfunc_c2		.usect "pwmodrv",1	
Mfunc_c3		.usect "pwmodrv",1	
Mfunc_p			.usect "pwmodrv",1 	
period_max		.usect "pwmodrv",1 	
period			.usect "pwmodrv",1	 
plimit			.usect "pwmodrv",1 	
limit			.usect "pwmodrv",1
compare_1  		.usect "pwmodrv",1
compare_2 		.usect "pwmodrv",1 
compare_3		.usect "pwmodrv",1
;===================================
FC_PWM_O_DRV_INIT:
;===================================

	LDP	#limit
	SPLK	#0, limit

;---target dependancy---------------
	.if (x240)	;target dependancy

FPERIOD	.set	1000		;1000 x 50nS = 50uS,  i.e. 20KHz PWM
 
	;Initialize period info
;		POINT_B0        		
		LDP		#period_max		
		SPLK	#FPERIOD, period_max
		SPLK	#7FFFh, Mfunc_p

		POINT_EV
		SPLK	#FPERIOD, T1PER				

			;5432109876543210
			;||||!!!!||||!!!!
		SPLK	#1001000001000000b,T1CON  	;Asym

	;Configure Simple & Full Compare registers
;		SPLK	#01F8h, DBTCON			;400nS @ 50nS clk
;		SPLK	#02F8h, DBTCON			;800nS @ 50nS clk
;		SPLK	#03F8h, DBTCON			;1.2uS @ 50nS clk
;		SPLK	#04F8h, DBTCON			;1.6uS @ 50nS clk
;		SPLK	#05F8h, DBTCON			;2.0uS @ 50nS clk
;		SPLK	#06F8h, DBTCON			;2.4uS @ 50nS clk
;		SPLK	#07F8h, DBTCON			;2.8uS @ 50nS clk
		SPLK	#08F8h, DBTCON			;3.2uS @ 50nS clk
;		SPLK	#0000h, DBTCON			;Disabled, i.e. Zero

		SPLK	#0000011001100110b,ACTR 	;Full Action Cntl
		SPLK	#0010011000000111b,COMCON	;Compare Cntl
		SPLK	#1010011000000111b,COMCON	;Compare Cntl
			;||||!!!!||||!!!!
			;5432109876543210
		POINT_B0
		RET
	.endif
;-----------------------------------

;---target dependancy---------------
	.if (x243)	;target dependancy

;FPERIOD	.set	1000		;1000 x 50nS = 50uS,  i.e. 20KHz PWM
;FPERIOD	.set	1334		; 1334 x 50nS = 66uS,  i.e 15kHz PWM
FPERIOD		.set	667
 
	;Initialize period info
;		POINT_B0        		
		LDP		#period_max		
		SPLK	#FPERIOD, period_max
		SPLK	#7FFFh, Mfunc_p

		POINT_EV
		SPLK	#FPERIOD, T1PER			;temporary init only		

			    ;5432109876543210
			    ;||||!!!!||||!!!!
;		SPLK	#1001000001000000b,T1CON  	;Asym
 		SPLK	#1000100001000000b,T1CON	;Symm
	;Configure Simple & Full Compare registers
;		SPLK	#01ECh, DBTCON			;400nS @ 50nS clk
;		SPLK	#02ECh, DBTCON			;800nS @ 50nS clk
		SPLK	#03ECh, DBTCON			;1.2uS @ 50nS clk
;		SPLK	#04ECh, DBTCON			;1.6uS @ 50nS clk
;		SPLK	#05ECh, DBTCON			;2.0uS @ 50nS clk
;		SPLK	#06ECh, DBTCON			;2.4uS @ 50nS clk
;		SPLK	#07ECh, DBTCON			;2.8uS @ 50nS clk
;		SPLK	#08ECh, DBTCON			;3.2uS @ 50nS clk
;		SPLK	#0000h, DBTCON			;Disabled, i.e. Zero

;		SPLK	#0000011001100110b,ACTR 	;Full Action Cntl
 		SPLK	#0000001001100110b,ACTR 	;Full Action
		SPLK	#1010011000000000b,COMCON	;Compare Cntl
			;||||!!!!||||!!!!
			;5432109876543210

	;Enable Primary function on CMP1-CMP6 PWM outputs	
		POINT_PF2					;OCRA.6 - OCRA.11
		LACC	OCRA 
		OR	#0000001111000000b      
;		OR	#0000111111000000b 		; for 3 Phase
			;||||!!!!||||!!!!
			;5432109876543210
		SACL	OCRA
		POINT_B0
		RET
	.endif
;-----------------------------------

;---target dependancy---------------
	.if (x2407)	;target dependancy

FPERIOD	.set	2000		;2000 x 25nS = 50uS,  i.e. 20KHz PWM

	;Initialize period info

		LDP		#period_max		
		SPLK	#FPERIOD, period_max
		SPLK	#7FFFh, Mfunc_p

		POINT_EV
		SPLK	#FPERIOD, T1PER			;temporary init only		

			    ;5432109876543210
			    ;||||!!!!||||!!!!
		SPLK	#1001000001000000b,T1CON  	;Asym
;		SPLK	#1000100001000000b,T1CON  	;Sym

	;Configure Simple & Full Compare registers
;		SPLK	#01ECh, DBTCON			;200nS @ 25nS clk
;		SPLK	#02ECh, DBTCON			;400nS @ 25nS clk
;		SPLK	#03ECh, DBTCON			;600nS @ 25nS clk
;		SPLK	#04ECh, DBTCON			;0.8uS @ 25nS clk
;		SPLK	#05ECh, DBTCON			;1.0uS @ 25nS clk
		SPLK	#06ECh, DBTCON			;1.2uS @ 25nS clk
;		SPLK	#07ECh, DBTCON			;1.4uS @ 25nS clk
;		SPLK	#08ECh, DBTCON			;1.6uS @ 25nS clk
;		SPLK	#0000h, DBTCON			;Disabled, i.e. Zero

		SPLK	#0000011001100110b,ACTR 	;Full Action Cntl
		SPLK	#1010011000000000b,COMCON	;Compare Cntl
			;||||!!!!||||!!!!
			;5432109876543210

;Enable Primary function on PWM1-PWM6 PWM outputs	
		POINT_PF2					;OCRA.6 - OCRA.11
		LACC	OCRA
		OR	#0000111111000000b
			;||||!!!!||||!!!!
			;5432109876543210
		SACL	OCRA
		POINT_B0
		RET
	.endif
;-----------------------------------


;===================================
FC_PWM_O_DRV:
;===================================
;Convert "Period" (Q15) modulation function to Q0

		LDP		#period_max		
		LT		Mfunc_p
		MPY		period_max	;P = period x period_max
		PAC
		SACH	period,1
		LACC	period
		SFR
		SACL	period	;period = period / 2
		
;Bipolar case
;------------
DCG1		SPM	1
;Convert "Compare 1" (Q15) modulation function to Q0
		LT	Mfunc_c1
		MPY	period	; P = Mfunc_c1 x period/2
		PAC			;
		ADDH	period	; offset by period/2     		
		SACH	compare_1    
		
		LACC	period  	
		SUB		compare_1     
		BCND	negcycle, GT
		LACC	period,1
		SUB		compare_1
		SACL	plimit    
		LACC	limit
		SUB		plimit
		BCND	update, LT
		LACC	period,1
		SUB		#10
		SACL	compare_1
		B		update
		
negcycle
		LACC	compare_1
		SUB		limit
		BCND	update, GEQ
		LACC	#10
		SACL	compare_1
		
update	LACC	compare_1


		POINT_EV 
		SACL	CMPR1   
		


;Convert "Compare 2" (Q15) modulation function to Q0

		LDP		#period_max		
DCG2	LT	Mfunc_c2
		MPY	period	; P = Mfunc_c2 x period/2
		PAC			;
		ADDH	period	; offset by period/2
		SACH	compare_2  
		
		LACC	period
		SUB		compare_2
		BCND	negcycle2, GT
		LACC	period,1
		SUB		compare_2
		SACL	plimit
		LACC	limit
		SUB		plimit
		BCND	update2, LT
		LACC	period,1
		SUB		#10
		SACL	compare_2
		B		update2
		
negcycle2

		LACC	compare_2
		SUB		limit
		BCND	update2, GEQ
		LACC	#10
		SACL	compare_2

update2	LACC	compare_2 

		POINT_EV 
		SACL	CMPR2

;Convert "Compare 3" (Q15) modulation function to Q0

		LDP	#period_max		  
DCG3		LT	Mfunc_c3
		MPY	period	; P = Mfunc_c3 x period/2
		PAC			;
		ADDH	period	; offset by period/2
;		SACH	compare_3   

		SACH	compare_3    
		
		LACC	period  	
		SUB		compare_3     
		BCND	negcycle, GT
		LACC	period,1
		SUB		compare_3
		SACL	plimit    
		LACC	limit
		SUB		plimit
		BCND	update3, LT
		LACC	period,1
		SUB		#10
		SACL	compare_3
		B		update3
		
negcycle3
		LACC	compare_3
		SUB		limit
		BCND	update3, GEQ
		LACC	#10
		SACL	compare_3
		
update3	LACC	compare_3


		POINT_EV 
		SACL	CMPR3   

		SPM	0

		POINT_B0
		RET
