;===========================================================================
; Module Name: 	RAMP_CNTL
;
; Filename:	RMP_CNTL.asm
;
; Description:	
;
;			|~~~~~~~~~~~~~~~|
; target_value o------->|		|----->o  setpt_value
;    			|   RAMP_CNTL	|
; s_eq_t_flg   o------->|		|----->o  s_eq_t_flg
;			|_______________|
;	
; Target:	C2xx core only
;
; Last Update: 06-21-2000
;===========================================================================
;(To use this Module, copy this section to main system file)
;		.ref	RAMP_CNTL, RAMP_CNTL_INIT	; function call
;		.ref	target_value 			; Inputs
;		.ref	setpt_value, s_eq_t_flg		; Outputs
;===========================================================================
;Module definitions for external reference.
		.def	RAMP_CNTL, RAMP_CNTL_INIT	; function call
		.def	target_value 			; Inputs
		.def	setpt_value, s_eq_t_flg		; Outputs
;===========================================================================
UPPER_LIMIT	.set	7500h
LOWER_LIMIT	.set	300h

RMP_DLY_MAX	.set	7			;7x50uS = 350 uS between steps.

target_value	.usect "rmp_cntl",1
setpt_value	.usect "rmp_cntl",1
s_eq_t_flg	.usect "rmp_cntl",1
rmp_delay_cntr	.usect "rmp_cntl",1


RAMP_CNTL_INIT:
		LDP	#setpt_value
		SPLK	#0h,setpt_value
		SPLK	#0h,rmp_delay_cntr
		RET

RAMP_CNTL:
		LDP	#target_value
		LACC	target_value
		SUB	setpt_value
		BCND	SET_FLG, EQ		; If Set point = target 
						; set s_eq_t_flg = 7FFFh then exit
		LACC	rmp_delay_cntr
		ADD	#1
		SACL	rmp_delay_cntr
		SUB	#RMP_DLY_MAX
		BCND	SRC_EXIT, LT

CHNG_VALUE:
		LACC	target_value
		SUB	setpt_value
		BCND	INC_VALUE, GT

DEC_VALUE	LACC	setpt_value
		SUB	#1
		SACL	setpt_value
		SUB	#LOWER_LIMIT
		BCND	SRC_1, GEQ
		SPLK	#LOWER_LIMIT, setpt_value
		B	SRC_1

INC_VALUE	LACC	setpt_value	   ;If max then Inc Frequency
		ADD	#1
		SACL	setpt_value
		SUB	#UPPER_LIMIT
		BCND	SRC_1, LEQ
		SPLK	#UPPER_LIMIT, setpt_value
SRC_1:
		SPLK	#0, rmp_delay_cntr

SRC_EXIT
		RET

SET_FLG
		SPLK	#7FFFh, s_eq_t_flg
		RET
