;===========================================================================
; Module Name: S Y S _ I N I T				      
;
; File Name:	Sys_init.asm
;
; Description:  Initializes F24x/xx devices
;
;
; History:
;
; Last Update: 06-26-2000
;===========================================================================
		.include	x24x_app.h
		.def	SYS_INIT
		.ref	GPR0

SYS_INIT:
;---target dependancy---------------
	.if (x240)

		POINT_PG0
		SETC	INTM			;Disable interrupts
		SPLK	#0h, IMR		;Mask all Ints
		SPLK	#0FFh, IFR		;Clear all Int Flags
		CLRC	SXM			;Clear Sign Extension Mode
		CLRC	OVM			;Reset Overflow Mode
		CLRC	CNF			;Config Block B0 to Data mem.
		LAR	AR1, #03C0h		;Init s/w stack pointer
		MAR	*,AR1

		POINT_B0
		SPLK	#04h, GPR0		;Set 0 wait states for XMIF
		OUT	GPR0, WSGR

		POINT_PF1
		SPLK	#0041h,PLL_CNTL1	;Disable PLL first.=CPUCLK/2,
		SPLK	#00B1h,PLL_CNTL2	;CLKIN(XTAL)=10MHz, PLL*2.0=20MHz
;		SPLK	#0081h,PLL_CNTL1	;CLKMD=PLL Enable,f_SYSCLK=f_CPUCLK/2
        	SPLK	#0080h,PLL_CNTL1	;CLKMD=PLL Enable,f_SYSCLK=f_CPUCLK/4
		SPLK	#40C0h,SYSCR		;CLKOUT=CPUCLK

	;Comment out if WD is to be active
		SPLK	#006Fh, WD_CNTL 	;Disable WD if VCCP=5V
		KICK_DOG
		RET
	.endif
;-----------------------------------


;---target dependancy---------------
	.if (x243)
		POINT_PG0
		SETC	INTM			;Disable interrupts
		SPLK	#0h, IMR		;Mask all Ints
		SPLK	#0FFh, IFR		;Clear all Int Flags

;Init PDP interrupt flag after reset		
		LDP	#PIRQR0>>7
		LACC	PIRQR0		; Clear pending PDP flag
		AND	#0FFFEh
		SACL	PIRQR0
		POINT_EV
		LACC	EVIFRA		; Clear PDP int flag
		OR	#0001h
		SACL	EVIFRA 


		POINT_PG0
		CLRC	SXM			;Clear Sign Extension Mode
		CLRC	OVM			;Reset Overflow Mode
		CLRC	CNF			;Config Block B0 to Data mem.
		SPM	0
		LAR	AR1, #03C0h		;Init s/w stack pointer
		MAR	*,AR1

		POINT_B0
		SPLK	#0040h, GPR0	;Set 0 wait states for XMIF
		OUT	GPR0, WSGR

		POINT_PF1
		SPLK	#40C0h,SYSCR	;CLKOUT=CPUCLK

	;Comment out if WD is to be active
		SPLK	#006Fh, WD_CNTL 	;Disable WD if VCCP=5V
		KICK_DOG
		RET
	.endif
;-----------------------------------

;---target dependancy---------------
	.if (x2407)
		POINT_PG0
		SETC	INTM			;Disable interrupts
		SPLK	#0h, IMR		;Mask all Ints
		SPLK	#0FFh, IFR		;Clear all Int Flags

;Init PDP interrupt flag after reset		
		LDP	#PIRQR0>>7
		LACC	PIRQR0		; Clear pending PDP flag
		AND	#0FFFEh
		SACL	PIRQR0
		LACC	PIRQR2		; Clear pending PDP flag
		AND	#0FFFEh
		SACL	PIRQR2
		POINT_EV
		LACC	EVAIFRA		; Clear PDPINTA flag
		OR	#0001h
		SACL	EVAIFRA 
		LDP	#EVBIFRA>>7
		LACC	EVBIFRA		; Clear PDPINTB flag
		OR	#0001h
		SACL	EVBIFRA 
		
		POINT_PG0
		CLRC	SXM			;Clear Sign Extension Mode
		CLRC	OVM			;Reset Overflow Mode
		CLRC	CNF			;Config Block B0 to Data mem.
		SPM	0
		LAR	AR1, #03C0h		;Init s/w stack pointer
		MAR	*,AR1

		POINT_B0
		SPLK	#00C0h, GPR0	;Set 1 wait states for I/O space
		OUT	GPR0, WSGR

		POINT_PF1 
   
		.if (x4_PLL)  
    		SPLK	#0085h, SCSR1	; x4 PLL, ADC en, EV1 en, clr Ill Addr flg         
		.endif 
 
    		.if (x2_PLL)  
    		SPLK	#0285h, SCSR1	; x2 PLL, ADC en, EV1 en, clr Ill Addr flg
		.endif 
        
	;Comment out if WD is to be active
		SPLK	#006Fh, WD_CNTL 	;Disable WD if VCCP=5V
		KICK_DOG
		RET
	.endif
;-----------------------------------
