;===========================================================================
; Module Name: 	V_Hz_PROFILE	
;
; File Name:	VHz_prof.asm			      
;
; Description:	
;
;				|~~~~~~~~~~~~~~~~~|
;				|		  |
;	vhz_freq	o------>|  V_Hz_PROFILE   |----->o  v_out
;				|		  |
;				|_________________|
;
;
; Last Update: 06-22-2000
;
; History:
;===========================================================================
;(To use this Module, copy this section to main system file)
;		.ref	V_Hz_PROFILE, V_Hz_PROFILE_INIT		;function call
;		.ref	vhz_freq				;Inputs
;		.ref	v_out					;Outputs
;		.ref	FL, FH, Fmax, Vmax, Vmin, vf_slope	;Parameters
;===========================================================================
;Module definitions for external reference.
		.def	V_Hz_PROFILE, V_Hz_PROFILE_INIT		;function call
		.def	vhz_freq				;Inputs
		.def	v_out					;Outputs
		.def	FL, FH, Fmax, Vmax, Vmin, vf_slope	;Parameters
;===========================================================================
; Config Information:
;	For FL = 20%, FL = .2 x 32767 = 6553
;	For FH = 50%, FH = .5 x 32767 = 16383
;	For Vmin = 20%, Vmin = .2 x 32767 = 6540
;	VF_SLOPE = (Vmax - Vmin)/(FH - FL) x 4097
;		   = (1 - 0.2)/(0.5 - 0.2) x 4097 = 10920
;
		.include	x24x_app.h

;---------------------------------------------------------------------------
;User configurable default parameter values

FL_		.set	6553		;Low Freq point on profile(Q15)
FH_		.set	16383		;High Freq point on profile(Q15)
Fmax_		.set	7FFFh		;Max value (i.e. 0.999.. in Q15)
VF_SLOPE_	.set	10920		;Volts/Hz slope 2.67 in Q12 format
Vmax_		.set	32767		;0.999..  in Q15
Vmin_		.set	6540		;0.200..  in Q15 (This is also the offset)
;---------------------------------------------------------------------------------
				
vhz_freq	.usect	"vhz_prof",1	
v_out     	.usect	"vhz_prof",1   	
vf_slope	.usect	"vhz_prof",1  	
FL		.usect	"vhz_prof",1
FH		.usect	"vhz_prof",1
Fmax		.usect	"vhz_prof",1
Vmax		.usect	"vhz_prof",1
Vmin		.usect	"vhz_prof",1
GPR0_vhz	.usect	"vhz_prof",1

V_Hz_PROFILE_INIT:
						
		LDP	#vhz_freq					
		SPLK	#VF_SLOPE_, vf_slope
		splk	#FL_, FL
		splk	#FH_, FH
		splk	#Fmax_, Fmax
		splk	#Vmax_, Vmax
		splk	#Vmin_, Vmin
		RET

V_Hz_PROFILE:
					
		LDP	#vhz_freq					
PROFILE1	LACC	vhz_freq
		SUB	FL			;Is Freq<=FL
		BCND	PROFILE2, GT
		LACC	Vmin
		SACL	v_out			;V is in Q15
		B	V_Hz_END

PROFILE2	LACC	vhz_freq
		SUB	FH
		BCND	PROFILE3, GT

		LACC	vhz_freq		;Acc = FREQ_IN
		SUB	FL			;Acc = FREQ_IN - FL
		SACL	GPR0_vhz
		LT	GPR0_vhz
		MPY	vf_slope		;P = vf_slope * (FREQ_IN - FL)
		PAC				;Q12 * Q15 --> Q27
		SACH	v_out,4		;convert result to Q15 format
		LACC	v_out
		ADD	Vmin			;Offset is in Q15
		SACL	v_out			;v_out = vf_slope * (FREQ_IN - FL) + Vmin
		B	V_Hz_END

PROFILE3	LACC	Vmax
		SACL	v_out			;v_out is in Q15
V_Hz_END:
		RET
