;*************************************************************
; File Name:	x24x_app.h
; Originator:	Digital Control Systems
;			Texas Instruments
;
; Description:	X24x Peripheral Registers + other useful definitions
;
; Target:		x240/1/2/3, x/2402/4/6/7
;
; Last Update:	7-11-2000
;**************************************************************

;--------------------------------------------------------------
; Select the target device by setting 1
;--------------------------------------------------------------
x240		.set	0	; C/F240
x241		.set	0	; F241
x242		.set	0	; C242
x243		.set	1	; C/F243
x2402		.set	0	; C/F2402
x2404		.set	0	; C2404
x2406		.set	0	; C/F2406
x2407		.set	0	; F2407

;For F2407EVM only
;Select PLL multiplication ratio
x2_PLL	.set	1
x4_PLL	.set	0


;--------------------------------------------------------------
; On Chip Periperal Register Definitions
;--------------------------------------------------------------

;C2xx Core Registers
;~~~~~~~~~~~~~~~~~~~~
IMR		.set	0004h		; Int Mask
GREG		.set	0005h		; Global memory allocation
IFR		.set	0006h		; Int Flag
ABRPT		.set	01fh		; Analysis BreakPoint
WSGR		.set	0FFFFh	; Wait State Control (IO space mapped)

;System Module Registers
;~~~~~~~~~~~~~~~~~~~~~~~
PIRQR0	.set	7010h		; Peripheral Interrupt Request Reg0(241/2/3,240x only)
PIRQR1	.set	7011h		; Peripheral Interrupt Request Reg1(241/2/3,240x only)
PIRQR2	.set	7012h		; Peripheral Interrupt Request Reg2(240x only)


SYSCR		.set	7018h		; System Control (X240 only)
SYSSR		.set	701Ah		; System Status (X240 only)
SYSIVR	.set 	701Eh		; System Int Vector (X240 only)

SSCR		.set 	7018h		; System Stat & Contr (X241/2/3 only)
PIVR		.set 	701Eh		; Periph Int Vector (X241/2/3 only)

SCSR1		.set	07018h	; System contr & stat 1 (240x only)
SCSR2		.set	07019h	; System contr & stat 2 (240x only)

DIN		.set	0701Ch	; Device Identification Register

; External interrupt configuration registers
XINT1CR240	.set 	7070h		; Int1 (type A) config (X240 only)
XINT2CR240	.set 	7078h		; Int2 (type C) config (X240 only)
XINT3CR240	.set 	707Ah		; Int3 (type C) config (X240 only)
NMICR		.set 	7072h		; NMI (type A) config (X240 only)

XINT1CR	.set 	7070h		; Int1 config. X241/2/3, (X240x only)
XINT2CR	.set 	7071h		; Int2 config. X241/2/3, (X240x only)

XINT1_CNTL	.set	07070h		;Int1 (type A) Control reg
NMI_CNTL	.set	07072h		;Non maskable Int (type A) Control reg
XINT2_CNTL	.set	07078h		;Int2 (type C) Control reg
XINT3_CNTL	.set	0707Ah		;Int3 (type C) Control reg


; PLL configuration registers - X240 only
CKCR0		.set 	702ah		; PLL Clock Control 0 (X240 only)
CKCR1		.set 	702ch		; PLL Clock Control 1 (X240 only)

;Digital I/O
;~~~~~~~~~~~
OCRA		.set	07090h	; Output Control A
MCRA		.set	07090h		;I/O Mux Control Reg A
OCRB		.set	07092h	; Output Control B
MCRB		.set	07092h		;I/O Mux Control Reg B
OCRC		.set	07094h	; Output control C (X240x only)

ISRA 		.set 	7094h		; Input Status A (X240 only)
ISRB 		.set 	7096h		; Input Status B (X240 only)
IPSRA		.set	07094h		;Input Status Reg A
IPSRB		.set	07096h		;Input Status Reg B

PADATDIR	.set	07098h	; I/O port A Data & Direction
PBDATDIR	.set	0709Ah	; I/O port B Data & Direction
PCDATDIR	.set	0709Ch	; I/O port C Data & Direction
PDDATDIR	.set	0709Eh		;I/O port D Data & Direction reg.
PEDATDIR	.set	07095h	; I/O port D Data & Direction
PFDATDIR	.set	07096h	; I/O port D Data & Direction

;Watch-Dog(WD) / Real Time Int(RTI) / Phase Lock Loop(PLL) Registers
;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
RTI_CNTR	.set	07021h	; RTI Counter reg
WD_CNTR 	.set	07023h	; WD Counter reg
WD_KEY	.set	07025h	; WD Key reg
WDKEY		.set	WD_KEY
RTI_CNTL	.set	07027h	; RTI Control reg
WD_CNTL 	.set	07029h	; WD Control reg
WDCR		.set	WD_CNTL
PLL_CNTL1	.set	0702Bh	; PLL control reg 1
PLL_CNTL2	.set	0702Dh	; PLL control reg 2

;Analog-to-Digital Converter(ADC) registers - x240/1/2/3
;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
ADC_CNTL1	.set	07032h	; ADC Control reg 1
ADC_CNTL2	.set	07034h	; ADC Control reg 2
ADC_FIFO1	.set	07036h	; ADC FIFO data reg 1
ADC_FIFO2	.set	07038h	; ADC FIFO data reg 2

ADCTRL1	.set	07032h	; ADC Control reg 1
ADCTRL2	.set	07034h	; ADC Control reg 2
ADCFIFO1	.set	07036h	; ADC FIFO data reg 1
ADCFIFO2	.set	07038h	; ADC FIFO data reg 2

;--------------------------------------------------------------
; ADC Register declarations - x240x
;--------------------------------------------------------------
ADCL_CNTL1	 .set	070A0h	;ADC Control reg 1
ADCL_CNTL2	 .set	070A1h	;ADC Control reg 2
MAXCONV	 .set	070A2h	;Maximum conversions in sequence
CHSELSEQ1	 .set	070A3h	;Channel select fields: Results 3,2,1,0
CHSELSEQ2	 .set	070A4h	;Channel select fields: Results 7,6,5,4
CHSELSEQ3	 .set	070A5h	;Channel select fields: Results 11,10,9,8
CHSELSEQ4	 .set	070A6h	;Channel select fields: Results 15,14,13,12
AUTO_SEQ_SR	 .set	070A7h	;Auto-sequence status Register
ADC_RESULT0	 .set	070A8h	;Conversion result 0
ADC_RESULT1	 .set	070A9h	;Conversion result 1
ADC_RESULT2	 .set	070AAh	;Conversion result 2
ADC_RESULT3	 .set	070ABh	;Conversion result 3
ADC_RESULT4	 .set	070ACh	;Conversion result 4
ADC_RESULT5	 .set	070ADh	;Conversion result 5
ADC_RESULT6	 .set	070AEh	;Conversion result 6
ADC_RESULT7	 .set	070AFh	;Conversion result 7
ADC_RESULT8	 .set	070B0h	;Conversion result 8
ADC_RESULT9	 .set	070B1h	;Conversion result 9
ADC_RESULT10 .set	070B2h	;Conversion result 10
ADC_RESULT11 .set	070B3h	;Conversion result 11
ADC_RESULT12 .set	070B4h	;Conversion result 12
ADC_RESULT13 .set	070B5h	;Conversion result 13
ADC_RESULT14 .set	070B6h	;Conversion result 14
ADC_RESULT15 .set	070B7h	;Conversion result 15
CALIBRATION	 .set	070B8h	;Calibration Register


;Serial Peripheral Interface (SPI) Registers
;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
SPI_CCR 	.set	07040h	;SPI Config Control Reg 1
SPI_CTL 	.set	07041h	;SPI Operation Control Reg 2
SPI_STS 	.set	07042h	;SPI Status Reg
SPI_BRR 	.set	07044h	;SPI Baud rate control reg
SPI_EMU 	.set	07046h	;SPI Emulation buffer reg
SPI_BUF 	.set	07047h	;SPI Serial Input buffer reg
SPI_DAT 	.set	07049h	;SPI Serial Data reg
SPI_PC1 	.set	0704Dh	;SPI Port control reg1
SPI_PC2 	.set	0704Eh	;SPI Port control reg2
SPI_PRI 	.set	0704Fh	;SPI Priority control reg

;Serial Communications Interface (SCI) Registers
;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
SCI_CCNTL	.set	07050h	;SCI Comms Control Reg
SCI_CNTL1	.set	07051h	;SCI Control Reg 1
SCI_HBAUD	.set	07052h	;SCI Baud rate control
SCI_LBAUD	.set	07053h	;SCI Baud rate control
SCI_CNTL2	.set	07054h	;SCI Control Reg 2
SCI_RX_STAT	.set	07055h	;SCI Receive status reg
SCI_RX_EMU	.set	07056h	;SCI EMU data buffer
SCI_RX_BUF	.set	07057h	;SCI Receive data buffer
SCI_TX_BUF	.set	07059h	;SCI Transmit data buffer
SCI_PORT_C1	.set	0705Dh	;SCI Port control reg1
SCI_PORT_C2	.set	0705Eh	;SCI Port control reg2
SCI_PRI 	.set	0705Fh	;SCI Priority control reg

;Event Manager (EV)/Event Manager A (EVA) Registers
;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
GPTCON	.set	07400h	; General Timer Control
T1CNT		.set	07401h	; T1 Counter
T1CMP		.set	07402h	; T1 Compare Value
T1PER		.set	07403h	; T1 Period
T1CON		.set	07404h	; T1 Control
T2CNT		.set	07405h	; T2 Counter
T2CMP		.set	07406h	; T2 Compare Value
T2PER		.set	07407h	; T2 Period
T2CON		.set	07408h	; T2 Control

T3CNT		.set	07409h	; T3 Counter (240 Only)
T3CMP		.set	0740ah	; T3 Compare (240 Only)
T3PER		.set	0740bh	; T3 Period (240 Only)
T3CON		.set	0740ch	; T3 Control (240 Only)

COMCON	.set	07411h	; Compare Control
ACTR		.set	07413h	; Compare Output Action Control (240 Only)

SACTR		.set	07414h	; S Comp Output Action Control (240 Only)

DBTCON	.set	07415h	; Dead Band Control
CMPR1		.set	07417h	; Compare Value 1
CMPR2		.set	07418h	; Compare Value 2
CMPR3		.set	07419h	; Compare Value 3

SCMPR1	.set	0741ah	; S Comp Value 1 (240 Only)
SCMPR2	.set	0741bh	; S Comp Value 2 (240 Only)
SCMPR3	.set	0741ch	; S Comp Value 3 (240 Only)

CAPCON	.set	07420h	; Capture Control
CAPCONA	.set	07420h	; Capture Control
CAPFIFO 	.set	07422h	; Capture FIFO1-3/4 Status
FIFO1		.set	07423h	; Capture 1 FIFO Top
FIFO2		.set	07424h	; Capture 2 FIFO Top
FIFO3		.set	07425h	; Capture 3 FIFO Top
FIFO4		.set	07426h	; Capture 4 FIFO Top (240 Only)

FIFOBT1	.set	07427h	; Capture 1 FIFO Bottom (240x only)
FIFOBT2	.set	07428h	; Capture 2 FIFO Bottom (240x only)
FIFOBT3	.set	07429h	; Capture 3 FIFO Bottom (240x only)

IMRA		.set	0742ch	; Group A Int Mask
IMRB		.set	0742dh	; Group B Int Mask
IMRC		.set	0742eh	; Group C Int Mask
EVIMRA	.set	0742Ch	; Group A Int Mask
EVIMRB	.set	0742Dh	; Group B Int Mask
EVIMRC	.set	0742Eh	; Group C Int Mask
EVAIMRA	.set	0742Ch	; Group A Int Mask
EVAIMRB	.set	0742Dh	; Group B Int Mask
EVAIMRC	.set	0742Eh	; Group C Int Mask


IFRA		.set	0742fh	; Group A Int Flag
IFRB		.set	07430h	; Group B Int Flag
IFRC		.set	07431h	; Group C Int Flag
EVIFRA	.set	0742Fh	; Group A Int Flag 
EVIFRB	.set	07430h	; Group B Int Flag
EVIFRC	.set	07431h	; Group C Int Flag
EVAIFRA	.set	0742Fh	; Group A Int Flag 
EVAIFRB	.set	07430h	; Group B Int Flag
EVAIFRC	.set	07431h	; Group C Int Flag


IVRA		.set	07432h	; Group A Int ID (x240 only)
IVRB		.set	07433h	; Group B Int ID (x240 only)
IVRC		.set	07434h	; Group C Int ID (x240 only)
EVIVRA	.set	07432h	; Group A Int ID (x240 only)
EVIVRB	.set	07433h	; Group B Int ID (x240 only)
EVIVRC	.set	07434h	; Group C Int ID (x240 only)

;Event Manager B (EVB) Registers (240x Only)
;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
GPTCONB	.set	07500h	; General Timer Control
T3CNTB	.set	07501h	; T1 Counter
T3CMPB	.set	07502h	; T1 Comp Value
T3PERB	.set	07503h	; T1 Period
T3CONB	.set	07504h	; T1 Control
T4CNTB	.set	07505h	; T2 Counter
T4CMPB	.set	07506h	; T2 Comp Value
T4PERB	.set	07507h	; T2 Period
T4CONB	.set	07508h	; T2 Control

COMCONB	.set	07511h	; Compare Control
ACTRB		.set	07513h	; Compare Output Action Control
DBTCONB	.set	07515h	; Dead Band Control
CMPR4B	.set	07517h	; Comp Value 4
CMPR5B	.set	07518h	; Comp Value 5
CMPR6B	.set	07519h	; Comp Value 6

CAPCONB	.set	07520h	; Capture Control
CAPFIFOB 	.set	07522h	; Capture FIFO4-6 Status
FIFO4B	.set	07523h	; Capture 4 FIFO Top
FIFO5B	.set	07524h	; Capture 5 FIFO Top
FIFO6B	.set	07525h	; Capture 6 FIFO Top
FIFOBT4B	.set	07527h	; Capture 4 FIFO Bottom
FIFOBT5B	.set	07528h	; Capture 5 FIFO Bottom
FIFOBT6B	.set	07529h	; Capture 6 FIFO Bottom

IMRAB		.set	0752ch	; Group A Int Mask
IMRBB		.set	0752dh	; Group B Int Mask
IMRCB		.set	0752eh	; Group C Int Mask
EVBIMRA	.set	0752ch	; Group A Int Mask
EVBIMRB	.set	0752dh	; Group B Int Mask
EVBIMRC	.set	0752eh	; Group C Int Mask

IFRAB		.set	0752fh	; Group A Int Flag
IFRBB		.set	07530h	; Group B Int Flag
IFRCB		.set	07531h	; Group C Int Flag
EVBIFRA	.set	0752fh	; Group A Int Flag
EVBIFRB	.set	07530h	; Group B Int Flag
EVBIFRC	.set	07531h	; Group C Int Flag

;-----------------------------------------------------------------------------
; Constant defines
;-----------------------------------------------------------------------------
B0_SADDR	.set	00200h		;Block B0 start address
B0_EADDR	.set	002FFh		;Block B0 end address
B1_SADDR	.set	00300h		;Block B1 start address
B1_EADDR	.set	003FFh		;Block B1 end address
B2_SADDR	.set	00060h		;Block B2 start address
B2_EADDR	.set	0007Fh		;Block B2 end address

;Bit codes for Test bit instruction (BIT)
BIT15		.set	0000h	;Bit Code for 15
BIT14		.set	0001h	;Bit Code for 14
BIT13		.set	0002h	;Bit Code for 13
BIT12		.set	0003h	;Bit Code for 12
BIT11		.set	0004h	;Bit Code for 11
BIT10		.set	0005h	;Bit Code for 10
BIT9		.set	0006h	;Bit Code for 9
BIT8		.set	0007h	;Bit Code for 8
BIT7		.set	0008h	;Bit Code for 7
BIT6		.set	0009h	;Bit Code for 6
BIT5		.set	000Ah	;Bit Code for 5
BIT4		.set	000Bh	;Bit Code for 4
BIT3		.set	000Ch	;Bit Code for 3
BIT2		.set	000Dh	;Bit Code for 2
BIT1		.set	000Eh	;Bit Code for 1
BIT0		.set	000Fh	;Bit Code for 0

; Used by the SBIT0 & SBIT1 Macro
B15_MSK 	.set	8000h	;Bit Mask for 15
B14_MSK 	.set	4000h	;Bit Mask for 14
B13_MSK 	.set	2000h	;Bit Mask for 13
B12_MSK 	.set	1000h	;Bit Mask for 12
B11_MSK 	.set	0800h	;Bit Mask for 11
B10_MSK 	.set	0400h	;Bit Mask for 10
B9_MSK	.set	0200h	;Bit Mask for 9
B8_MSK	.set	0100h	;Bit Mask for 8
B7_MSK	.set	0080h	;Bit Mask for 7
B6_MSK	.set	0040h	;Bit Mask for 6
B5_MSK	.set	0020h	;Bit Mask for 5
B4_MSK	.set	0010h	;Bit Mask for 4
B3_MSK	.set	0008h	;Bit Mask for 3
B2_MSK	.set	0004h	;Bit Mask for 2
B1_MSK	.set	0002h	;Bit Mask for 1
B0_MSK	.set	0001h	;Bit Mask for 0

;External Data Space Registers
;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
EXTDATA	.set	8000h

;-----------------------------------------------------------------------
; M A C R O - Definitions
;-----------------------------------------------------------------------
SBIT0		.macro	DMA,MASK	; Clear bit Macro
		LACC	DMA
		AND	#(0FFFFh-MASK)
		SACL	DMA
		.endm

SBIT1		.macro	DMA,MASK	; Set bit Macro
		LACC	DMA
		OR	#MASK
		SACL	DMA
		.endm

KICK_DOG	.macro			;Watchdog reset macro
		LDP	#WD_KEY>>7
		SPLK	#05555h,WD_KEY
		SPLK	#0AAAAh,WD_KEY
		.endm

POINT_PG0	.macro
		LDP	#00h
		.endm

POINT_B0	.macro
		LDP	#04h
		.endm

POINT_PF1	.macro
		LDP	#0E0h
		.endm

POINT_PF2	.macro
		LDP	#0E1h
		.endm

POINT_EV	.macro
		LDP	#0E8h
		.endm


wd_rst_1	.set	055h		; watchdog timer reset string
wd_rst_2	.set	0aah		; watchdog timer reset string

