*================================================================================
*
*	TEXAS INSTRUMENTS, INC.		
*
*	40 BIT ADD
*
*	Revision Date:  04/29/97
*	
*	USAGE	This routine is C Callable and can be called as:
*		
*		long add40(long a, long b)
*
*		a --- first 40 bit value 
*               b --- second 40 bit value
*
*		If routine is not to be used as a C callable function then
*		you need to initialize values for all of the values passed
*		as these are assumed to be in registers as defined by the 
*		calling convention of the compiler, (refer to the C compiler
*		reference guide).
*
*	C CODE
*		This is the C equivalent of the assembly code.  Note that
*		the assembly code is hand optimized and restrictions may
*		apply.
*
*		long add40(long a,long b)
*		{
*			return(a + b);
*		}
*
*
*	DESCRIPTION
*
*		This routine takes two 40 bit values and calculates their
*               sum.  The inputs are 40-bit numbers, and the result is 
*       	a 40-bit number.
*	
*	ASSUMPTIONS
*
*         	1.  Only one sum is computed with a pair of 40-bit values.
*		2.  Multiple 40-bit adds can yield 1/2 cycle per 40-bit add	*                   on average.
*
*	CYCLES
*
*		3
*
*================================================================================
	.global _add40
	.text
_add40:
*** BEGIN Benchmark Timing
B_START:
		ADDU	.L1X	A5:A4,	B4,	A5:A4	; c_tmp = a_tmp + b_tmp

		ADD	.L1X	B5,	A5,	A5	; c_tmp = a_tmp + b_tmp
		EXTU	.S1	A5,	24, 24, A5	; extract bottom for store
B_END:
*** END Benchmark Timing
STOP:		B	.S2	B3
		NOP	5
