*==============================================================================
*
*	TEXAS INSTRUMENTS, INC.		
*
*	LATTICE FILTER	- FORWARD - SYNTHESIS
*
*	Revision Date:  05/21/97
*	
*	USAGE	This routine is C Callable and can be called as:
*	
*		int latsynth(int f, int n, short k[], short b[])
*
*		b[] --- array of coefficients
*               n   --- number of data samples
*		k[] --- array of filter gains
*		f   --- result of forward synthesis
*
*		If routine is not to be used as a C callable function then
*		you need to initialize values for all of the values passed
*		as these are assumed to be in registers as defined by the 
*		calling convention of the compiler, (refer to the C compiler
*		reference guide).
*
*	C CODE
*		This is the C equivalent of the assembly code.  Note that
*		the assembly code is hand optimized and restrictions may
*		apply.
*
*		int latsynth(int f, int n, short k[], short b[])
*		{
*			int             i;
*			f -= b[n - 1] * k[n - 1];
*			for (i = n - 2; i >= 0; i--) {
*				f -= b[i] * k[i];
*				b[i + 1] = b[i] + ((k[i] * (f >> 16)) >> 16);
*			}
*			b[0] = f >> 16;
*			return f;
*		}
*
*	DESCRIPTION
*	
*		This routine implements an forward synthesis lattice filter
*		and stores the result in f.  The filter consists of n data
*		samples.  The value of f is calculated by doing a multiply 
*		accumulate on the coefficients and filter gains.  New 
*		coefficients are calculated also. k and b arrays contain 16-bit
*		data.
*
*	
*	ASSUMPTIONS
*
*         	n is a multiple of 2
*
*	MEMORY NOTE:
*
*		Vectors b and k should be aligned on different half word
*		boundaries to avoid memory hits.
*
*	CYCLES
*   
*		2*n + 18
*
*==============================================================================

	.global _latsynth	
	.text

*** BEGIN Benchmark Timing ***
_latsynth:
	B	.S1	LOOP			; for
||	ZERO	.L1	A7
||	ZERO	.L2	B7
		
	MVK	.S1	7,	A1		; setup priming count
||	ADD	.S2	B4,	B4,	B1	; scale n for indexing

	B	.S2	LOOP			; for
||	ADD	.L1X	B1,	A6,	A6	; k[n]
||	ADD	.L2	B1,	B6,	B6	; b[n]

	ADD	.D2	3,	B4,	B0	; n+3, setup loop count

LOOP:
   [B0]	B	.S2	LOOP			; for
||	SHR	.S1	A2,	16,	A5	;* kf = (k' * (f>>16))>>16)
||	MPY	.M2	1,	B1,	B5	;** copy b' to b"
||	MPYHL	.M1	A4,	A0,	A2	;** k' * (f >> 16) 
||	MV	.L1	A3,	A0		;*** copy k to k'
||	LDH	.D1	*--A6,	A3		;****** k[n-1] = *--k
||	LDH	.D2	*--B6,	B7		;****** b[n-1] = *--b

   [A1]	ADD	.L1	-1,	A1,	A1	; decrement priming count
|| [B0]	ADD	.S2	-1,	B0,	B0	; decrement loop count
||[!A1]	STH	.D2	B4,	*+B6[7]		; b[n-1] = b" + kf
||	ADD	.L2X	A5,	B5,	B4	;* b" + kf 
|| [B0]	SUB	.S1	A4,	A7,	A4	;*** f -= b[n-1] * k[n-1]
||	MPY	.M2	1,	B7,	B1	;**** copy b to b'
||	MPY	.M1X	B7,	A3,	A7	;**** b[n-1] * k[n-1]

LOOP_END:
	SHR	.S1	A4,	16,	A6	; f >> 16
||	B	.S2	B3			; return

	STH	.D2	A6,	*+B6[6]		; b[0] = f >> 16

B_END:
*** END Benchmark Timing ***

	NOP	4	

