*================================================================================
*
*	TEXAS INSTRUMENTS, INC.		
*
*	40 Bit Multiply
*
*	Revision Date:  07/14/97
*	
*	USAGE	This routine is C Callable and can be called as:
*		
*		Long40 mpy40(Long40 a, Long40 b)
*
*		a --- first 40 bit input value
*               b --- second 40 bit input value
*
*		If routine is not to be used as a C callable function then
*		you need to initialize values for all of the values passed
*		as these are assumed to be in registers as defined by the 
*		calling convention of the compiler, (refer to the C compiler
*		reference guide).
*
*	C CODE
*		This is the C equivalent of the assembly code.  Note that
*		the assembly code is hand optimized and restrictions may
*		apply.
*
*		Long40 mpy40(Long40 a, Long40 b)
*		{
*		        Long40 c;
*		        c = (Long40) a * (Long40) b;
*		        return (c);
*		}
*		
*	DESCRIPTION
*
*		This routine takes two 40 bit integer values and calculates
*               their product.  The inputs are 40-bit integer, and the result
*		is a 40-bit integer.
*	
*	ASSUMPTIONS
*
*         	1. Only one sum is computed with a pair of 40-bit values.
*		2. The assembly code can be rewritten to give an average of
*                  1 40-bit multiply every 3 cycles when executing multiple
*                  multiplies.
*
*	CYCLES
*
*		8
*
*===============================================================================
	.global _mpy40
	.text

_mpy40:
*** BEGIN Benchmark Timing
B_START:

	MPYHLU	.M1x	A4,B4,A6	; c =(u short)(a>>16)*(u short)b
||	MPYHLU	.M2x	B4,A4,B6	; c1=(u short)(b>>16)*(u short)a

	MPYSU	.M1x	A5,B4,A5	; c3=((short) a>>32)*(u short)b
||	MPYSU	.M2x	B5,A4,B5	; c4=((short) b>>32)*(u short)a

	MPYU	.M1x	B4,A4,A7	; c2=(u short)a*(u short)b
||	MPYHU	.M2x	A4,B4,B4	; c5=((u short)(a>>16)*(u short)(b>>16))

	ADDU	.L1x	B6,A6,A5:A4	; c  += c1
||	ADD	.L2x	A5,B5,B5	; c4 += c3

	SHL	.S1	A5:A4,16,A5:A4	; c <<= 16
||	ADD	.L2	B5,B4,B5	; c4 += c5

	ADDU	.L1	A7,A5:A4,A5:A4	; c  += c4

	ADD	.L1x	B5,A5,A5	; c  += c4

        EXTU    .S1     A5,24,24,A5	; extract bottom for store


B_END:
*** END Benchmark Timing
STOP:	B	.S2	B3			; return to calling function
	NOP	5
