*===============================================================================
*
*	TEXAS INSTRUMENTS, INC.		
*
*	64 BIT SUBTRACT
*
*	Revision Date:  06/18/97
*	
*	USAGE	This routine is C Callable and can be called as:
*		
*		void sub64b(int alow, int ahigh, int blow, int bhigh, int *c)
*
*		alow  --- lsword to first 64 bit value 
*		ahigh --- msword to first 64 bit value
*               blow  --- lsword to second 64 bit value
*		bhigh --- msword to second 64 bit value
*		*c --- pointer to resultant 64 bit value
*
*		If routine is not to be used as a C callable function then
*		you need to initialize values for all of the values passed
*		as these are assumed to be in registers as defined by the 
*		calling convention of the compiler, (refer to the C compiler
*		reference guide).
*
*	C CODE
*		This is the C equivalent of the assembly code.  Note that
*		the assembly code is hand optimized and restrictions may
*		apply.
*
*		void sub64b(int alow, int ahigh, int blow, int bhigh, int *c)
*		{
*			c[0] = alow - blow;
*			c[1] = ahigh - bhigh;
*			if((unsigned) c[0] > (unsigned) alow)
*				c[1]--;
*		}
*
*
*	DESCRIPTION
*
*		This routine takes two 64 bit values and calculates their
*               difference.  The inputs are 64-bit numbers, which are broken
*		into two 32-bit values (least and most significant words), and
*		the result is a 64-bit number.
*	
*	ASSUMPTIONS
*
*         	1.  Only one difference is computed with pair of 64-bit values.
*		    The code can be reorganized to compute an average of two
*		    64-bit differences in three cycles. 
*		2.  Multi-word result uses a return pointer and requires STWs.
*
*	CYCLES
*
*		2 (3 with STWs)
*
*===============================================================================
	.global _sub64
	.text

_sub64:
*** BEGIN Benchmark Timing
B_START:

	SUBU	.L1	A4,	A6,	A1:A0	; c_tmp:c_low = a_low - b_low
||	SUB	.L2	B4,	B6,	B7	; c_high_tmp = a_high - b_high
||	ADD	.S2X	A8,	4,	B0	; update pointer to c_high

  [A1]	SUB	.L2	B7,	1,	B7	; c_high=c_high_tmp-carry

B_END:
*** END Benchmark Timing

	STW	.D1	A0,	*A8		; c_low stored
||	STW	.D2	B7,	*B0		; c_high stored
||	B	.S2	B3			; return to calling function

STOP:
	NOP	5
