*===============================================================================
*
*	TEXAS INSTRUMENTS, INC.		
*
*	
*	Revision Date:	06/22/98
*	
*	USAGE	This routine is C Callable and can be called as:
*		
*		a = isqrsp(b);
*
*		If the routine is not to be used as a C callable function,
*		then you need to initialize values for all of the parameters
*		passed to the function since these are assumed to be in
*		registers as defined by the calling convention of the
*		compiler, (refer to the TMS320C6x Optimizing C Compiler
*		User's Guide).
*
*	C CODE
*		This is the C equivalent for the assembly code.  Note that
*		the assembly code is hand optimized and restrictions may
*		apply.
*
*		float isqrsp(float x)
*		{
*		  int i;
*		  float y;
*
*		  y = _rsqrsp(x);
*
*		  for (i=0; i<2; i++)
*		  {
*		     y = y * (1.5f - (x * 0.5f * y * y);
*		  }
*
*		  return y;
*		}
*
*	DESCRIPTION
*
*		This routine calculates the single precision square root
*		reciprocal.
*
*	TECHNIQUES
*
*		1.  RSQRSP is used to get the reciprocal square root of the
*		    single precision value held in the register A4.  However,
*		    to increase the precision of the mantissa to the full
*		    23 bits, two iterations of the Newton-Rhapson algorithm
*		    are required.
*
*			y(n+1) = y(n)[1.5f - 0.5f * x * y(n) * y(n)]
*
*		    where,
*
*		    y(0) = seed value from the _rsqrsp intrinsic
*		    x = the input whose reciprocal sq.root is to be calculated										    *
*
*		    Due to the high number of dependencies and the long delay
*		    slots required in multsp and subsp, several nops are
*		    required in the loop.
*
*       ARGUMENTS PASSED
*
*		x	 ->  A4
*
*	CYCLES
*
*		34 Cycles
*
*===============================================================================*

	   .def    _isqrsp
	   .text

_isqrsp:

	   MVK	   .S2	   1,B0 	  ; Loop counter B0 = 1
||	   ZERO    .D2	   B4		  ; B4 = 0.5f
||	   ZERO    .D1	   A3		  ; A3 = 1.5f
||	   MV	   .L1	   A4,A0	  ; A0 = x
||	   RSQRSP  .S1	   A4,A4	  ; A4 = y = _rsqrsp(x)

	   MVKH    .S2	   0x3f000000,B4  ; B4 = 0.5f

LOOP:

	   MPYSP   .M1	   A4,A4,A2	  ; A2 = y * y
||	   MPYSP   .M2X    A0,B4,B1	  ; B1 = x * 0.5f
||	   MVKH    .S1	   0x3fc00000,A3  ; A3 = 1.5f
	   NOP		   3

	   MPYSP   .M1X    B1,A2,A2	  ; A2 = (x * 0.5f) * (y * y)
	   NOP		   3

	   SUBSP   .L1	   A3,A2,A2	  ; A2 = 1.5f - (x * 0.5f * y * y)
	   NOP		   1

     [!B0] B	   .S2	   B3		  ; Return to calling program
||    [B0] B	   .S1	   LOOP

      [B0] SUB	   .S2	   B0,1,B0
	   MPYSP   .M1	   A4,A2,A4	  ; A4 = y * (1.5f - x * 0.5f * y * y)
	   NOP		   3
