*===============================================================================
*
*	TEXAS INSTRUMENTS, INC.		
*
*	
*	Revision Date:	04/4/98
*	
*	USAGE	This routine is C Callable and can be called as:
*		
*		x = spinv(v);
*
*		If the routine is not to be used as a C callable function,
*		then you need to initialize values for all of the parameters
*		passed to the function since these are assumed to be in
*		registers as defined by the calling convention of the
*		compiler, (refer to the TMS320C6x Optimizing C Compiler
*		User's Guide).
*
*	C CODE
*		This is the C equivalent for the assembly code.  Note that
*		the assembly code is hand optimized and restrictions may
*		apply.
*
*		float spinv(float x)
*		{
*			float inver;
*			inver = 1/x;
*			return(inver);
*		}
*
*	DESCRIPTION
*
*		This routine calculates the product of a matrix vector multiplication
*
*	TECHNIQUES
*
*		1.  RCPSP is used to get the reciprocal of the double value	
*			held in register pair A4.  However, to increase 
*			the precision of the mantissa to the full 23 bits, 
*			two iterations of the Newton-Rhapson algorithm are 
*			required.  Due to the high number of dependencies and the
*			long delay slots required in multsp and subsp, several nops 
*			are required in the loop.  	
*
*       ARGUMENTS PASSED
*
*		x	 ->  A4
*
*	CYCLES
*
*		28 Cycles
*
*===============================================================================
	.global _spinv
	.text

_spinv:

*** BEGIN Benchmark Timing ***

		MVK	.S1	1,A2 ;counter
||		MVK	.S2	2,B9
||		MV	.L1	A4,A6

		RCPSP	.S1	A6,A4		
		INTSP	.L1X	B9,A5

loop:
		MPYSP	.M1	A6,A4,A8 	;  A8 = v*x[n] 
		NOP		3		
		SUBSP	.L1	A5,A8,A9	;  A9 = 2 - A8		
		NOP		1

	[A2]	B	.S1	loop
||     [!A2]	B	.S2	B3	

	[A2]	SUB	.D1	A2,1,A2	
		MPYSP	.M1	A9,A4,A4	;  A6 = A6*A9 = x[n]*(2-v*x[n])  
		NOP		3
B_END:
                            	