;**************************************************************
;  
;                 init1.asp
;  
;                 James M. Patterson
;  
;                 12-22-89
;  
;           (C) Texas Instruments Inc., 1992 
;  
;           Refer to the file 'license.txt' included with this 
;           this package for usage and license information. 
;  
;**************************************************************
;
;   TMS320C1x XDS/22 INITIALIZATION SCRIPT
;
;      James M. Patterson
;      Texas Instruments
;      370 South North Lake Boulevard
;      Altamonte Springs, Florida 32701
;


CLEAR					;CLEAR SCREEN

SET DISPLAY OFF

BOX  0 0 23 79 2		   ;DRAW A GREEN BOX
ATSAY  2 31 9  "SET XDS PARAMETERS"	;WHAT WE'RE DOING

;
;	CHECK FOR PARAMETER FILE
;

INIT	N9  0		    ;CLEAR FILE PRESENT FLAG
INIT	N8  0		    ;CLEAR FILE UPDATE FLAG

ISFILE	"XDS1INIT.PRM"

IF	SUCCESS
	INIT	N9  1
	FOPENI	 "XDS1INIT.PRM" TEXT	;OPEN THE PARM FILE

    ;READ INIT VALUES

	FGETS	S9  ;READ CLOCK SOURCE VALUE
	FGETS	S8  ;READ HEX NOTATION
	FGETS	S7  ;READ # OF EXTENDED ADDRESS BITS
	FGETS	S6  ;READ

    ;READ MAP VALUES

	FGETS	S5  ;READ EMU MEMORY SIZE
	FGETS	S4  ;READ WRITE PROTECT SIZE
	FGETS	S3  ;STOP ON WP VIOLATION?
	FGETS	S2  ;UNMAP EMU MEMORY ON MC/MP PIN?

	FCLOSEI     ;CLOSE THE INPUT FILE

ELSE		    ;FILE WASN'T THERE


    ;SET DEFAULT INIT PARAMETERS

	ASSIGN	S9  "OSC"
	ASSIGN	S8  "NONE"
	ASSIGN	S7  "0"

    ;SET DEFAULT MAP PARAMETERS

	ASSIGN	S6  "4.0K"	;EMU MEMORY SIZE
	ASSIGN	S5  "0" 	;WRITE PROTECT SIZE
	ASSIGN	S4  "NO"	;STOP ON WP VIOLATION
	ASSIGN	S3  "NO"	;UNMAP EMU MEMORY ON MC/MP PIN

ENDIF

IF  ZERO    N9			;WAS THERE A FILE?

    ATSAY   4 2 4   "COULDN'T FIND XDS1INIT.PRM"

ELSE

    ATSAY   4 2 10   "VALUES READ FROM XDS1INIT.PRM"

ENDIF

ATSAY	8   4	10  "EMULATOR CLOCK SOURCE:            "
ATSAY	8   38	14  S9

ATSAY	10 4   10  "HEX NOTATION:                     "
ATSAY	10 38  14  S8

ATSAY	12  4	10  "NUMBER OF EXTENDED ADDRESS BITS:  "
ATSAY	12  38	14  S7

ATSAY	15  4	10  "EMULATOR MEMORY SIZE:             "
ATSAY	15  38	14  S6

ATSAY	17  4	10  "WRITE PROTECT MEMORY SIZE:        "
ATSAY	17  38	14  S5

ATSAY	19  4	10  "STOP ON WRITE PROTECT VIOLATION:  "
ATSAY	19  38	14  S4

ATSAY	21  4	10  "UNMAP EMU MEMORY ON MC/MP PIN:    "
ATSAY	21  38 14   S3

    ;WANT TO USE THESE?

ATSAY	6   2	10  "ACCEPT THESE VALUES? (DEFAULT YES):   "
ATGET	6   38	14  3	S2		    ;READ RESPONSE

STRCMP	S2  "NO"    ;CHECK FOR NO

IF  NOT SUCCESS

    ATSAY  6   38  14  "YES"
    IF	ZERO	N9	;WAS THERE A FILE
	INIT	N8  1
    ENDIF
    GOTO DO_INIT

ENDIF

INIT	N8  1

GET_VALUES:

CLOCK_SOURCE:

    SCROLL  0	8   2	22  78	14  ;PARTIAL SCREEN CLEAR

    ATSAY   8	4   10	"EMULATOR CLOCK SOURCE:            "
    ATSAY   9	9   10	"0 - XDS EMULATOR BOARD CRYSTAL"
    ATSAY   10	9   10	"1 - OSCILLATOR ON YOUR TARGET BOARD"
    ATSAY   11	9   10	"2 - XDS EMULATOR BOARD OSCILLATOR "

    ATGET   8	38  14	1 S9

    SWITCH  S9

	CASE	"0"
	    ASSIGN  S9	"INTERNAL"
	ENDCASE

	CASE	"1"
	    ASSIGN  S9	"TARGET"
	ENDCASE

	CASE	"2"
	    ASSIGN  S9	"OSC"
	ENDCASE

	DEFAULT
	    ASSIGN  S9	"MUST BE 0, 1, OR 2"
	    PAUSE   2
	    GOTO    CLOCK_SOURCE
	ENDCASE

    ENDSWITCH

    ATSAY   8	38  14	"                                       "
    ATSAY   8	38  14	S9

    SCROLL  0	9   2	22  78	14  ;CLEAR LOWER SCREEN

HEX:

    ATSAY   10	4   10	"HEX NOTATION:                     "
    ATSAY   11	9   10	"0 - NONE:  ALL NUMBERS ARE HEXADECIMAL"
    ATSAY   12	9   10	"1 - TI:  HEXADECIMAL INPUT VALUES DESIGNATED AS:"
    ATSAY   13	9   10	">xxxx, 0Xxxxx, Xxxxx, Hxxxx, OR  xxxxH"
    ATSAY   14	9   10	"HEXADECIMAL NUMBERS DISPLAYED AS >xxxx"
    ATSAY   15	9   10	"2 - X:  SAME AS TI, EXCEPT HEXADECIMAL NUMBERS DISPLAYED AS Xxxxx"
    ATSAY   16	9   10	"3 - HS:  SAME AS TI, EXCEPT HEXADECIMAL NUMBERS DISPLAYE AS xxxxH"
    ATSAY   17	9   10	"4 - HP:  SAME AS TI, EXCEPT HEXADECIMAL NUMBERS DISPLAYED AS Hxxxx"

    ATGET 10 38 14 1 S8

	SWITCH	S8

		CASE	0
			ASSIGN	S8	"NONE"
		ENDCASE

		CASE	1
			ASSIGN	S8	"TI"
		ENDCASE

		CASE	2
			ASSIGN	S8	"X"
		ENDCASE

		CASE	3
			ASSIGN	S8	"HS"
		ENDCASE

		CASE	4
			ASSIGN	S8	"HP"
		ENDCASE

		DEFAULT
			ASSIGN	S8	"INVALID SELECTION"
			ATSAY 10 38 4 S8
			PAUSE 2
			GOTO HEX
		ENDCASE
	ENDSWITCH

	ATSAY	10  38	11  "                            "
	ATSAY	10  38	11  S8
	SCROLL	0   11	2   22	78  ;CLEAR LOWER SCREEN

EXT_ADDRESS:

    ATSAY   12	4   10	"NUMBER OF EXTENDED ADDRESS BITS:  "
    ATSAY   13	9   10"MIN = 0; MAX = 8"

    ATGET   12	38  11	1 S7

	SWITCH	S7
		CASE	"0"		;THESE ARE ALL VALID
		ENDCASE
		CASE	"1"
		ENDCASE
		CASE	"2"
		ENDCASE
		CASE	"3"
		ENDCASE
		CASE	"4"
		ENDCASE
		CASE	"5"
		ENDCASE
		CASE	"6"
		ENDCASE
		CASE	"7"
		ENDCASE
		CASE	"8"		;LAST VALID INPUT
		ENDCASE

		DEFAULT
			ASSIGN	S7	"VALUE MUST BE BETWEEN 0 AND 8"
			ATSAY	12 38 4 S7	 ;PRINT ERROR MESSAGE
			PAUSE	2
			GOTO EXT_ADDRESS
		ENDCASE
	ENDSWITCH


	ATSAY	12 38 11 S7
	SCROLL	0 13 2 22 78 11    ;PARTIAL SCREEN CLEAR

MEM_SIZE:

    ATSAY   15	4   10	"EMULATOR MEMORY SIZE:             "
    ATSAY   16	9   10	"0 - 4.0K"
    ATSAY   17	9   10	"1 - 1.5K"
    ATSAY   18	9   10	"2 - ALL MEMORY ON TARGET"
    ATGET   15	38  11	1   S6
    SWITCH  S6

	CASE	"0"
	    ASSIGN  S6	"4.0K"
	ENDCASE

	CASE	"1"
	    ASSIGN  S6	"1.5K"
	ENDCASE

	CASE	"2"
	    ASSIGN  S6	"ALL TARG"
	ENDCASE

	DEFAULT
	    ASSIGN  S6	"MUST BE 0, 1, OR 2"
	    ATSAY   15	38  4	S6
	    GOTO    MEM_SIZE
	ENDCASE
    ENDSWITCH

    ATSAY   15	38  11	"                              "
    ATSAY   15	38  11	S6
    SCROLL  0	16  2	22  78	11

WP_MEM_SIZE:

    ATSAY   17	4   10	"WRITE PROTECT MEMORY SIZE:        "
    ATSAY   18	9   10	"0 - NONE"
    ATSAY   19	9   10	"1 - 1.5K"
    ATSAY   20	9   10	"2 - 4.0K"

    ATGET   17	38  11	1   S5

    SWITCH  S5

	CASE	"0"
	    ASSIGN  S5	"0"
	ENDCASE

	CASE	"1"
	    ASSIGN  S5	"1.5K"
	ENDCASE

	CASE	"2"
	    ASSIGN  S5	"4.0K"
	ENDCASE

	DEFAULT
	    ASSIGN  S5	"MUST BE 0, 1, OR 2"
	    ATSAY   17	38  4	S5
	    PAUSE   2
	    GOTO    WP_MEM_SIZE
	ENDCASE

    ENDSWITCH

    ATSAY   17	38  11	"                   "
    ATSAY   17	38  11	S5
    SCROLL  0	18  2	22  78	11


    ATSAY   19	4   10	"STOP ON WRITE PROTECT VIOLATION:  "
    ATSAY   20	9   10	"0 - NO"
    ATSAY   21	9   10	"1 - YES"
    ATGET   19	39  11	1   S4

    SWITCH  S4

	CASE	"0"
	    ASSIGN  S4	"NO"
	ENDCASE

	CASE	"1"
	    ASSIGN  S4	"YES"
	ENDCASE

	DEFAULT
	    ASSIGN  S4	"MUST BE 0 OR 1"
	    ATSAY   19	38  4	S4
	    PAUSE   2
	    ATSAY   19	38  11	"                 "
	    GOTO    WP_MEM_SIZE
	ENDCASE

    ENDSWITCH

    ATSAY   19	38  11	S4
    SCROLL  0	20  2	22  78	11  ;CLEAR SCREEN

UNMAP:

    ATSAY   21	4   10	"UNMAP EMU MEMORY ON MC/MP PIN:    "
    ATSAY   22	9   10	"0 - NO, 1 - YES"
    ATGET   21	38  11	1   S3

    SWITCH  S3

	CASE	"0"
	    ASSIGN  S3	"NO"
	ENDCASE

	CASE	"1"
	    ASSIGN  S3	"YES"
	ENDCASE

	DEFAULT
	    ASSIGN  S3	"MUST BE 0 OR 1"
	    ATSAY   21	38  4	S3
	    PAUSE   2
	    ATSAY   21	38  11	"                "
	    GOTO    UNMAP
	ENDCASE

    ENDSWITCH

    ATSAY   21	38  11	S3

DO_INIT:

    IF	NOT ZERO    N8

    ATSAY   6	2   10	"UPDATING XDS1INIT.PRM                      "

    FOPENO  "XDS1INIT.PRM" TEXT

    ;WRITE INIT VALUES

	FPUTS	S9  ;WRITE CLOCK SOURCE VALUE
	FPUTC	"^J"

	FPUTS	S8  ;WRITE HEX NOTATION
	FPUTC	"^J"

	FPUTS	S7  ;WRITE # OF EXTENDED ADDRESS BITS
	FPUTC	"^J"

	FPUTS	S6  ;WRITE
	FPUTC	"^J"


    ;WRITE MAP VALUES

	FPUTS	S5  ;WRITE EMU MEMORY SIZE
	FPUTC	"^J"

	FPUTS	S4  ;WRITE WRITE PROTECT SIZE
	FPUTC	"^J"

	FPUTS	S3  ;STOP ON WP VIOLATION?
	FPUTC	"^J"

	FPUTS	S2  ;UNMAP EMU MEMORY ON MC/MP PIN?
	FPUTC	"^J"

	FCLOSEO     ;CLOSE THE OUTPUT FILE

    ENDIF

    CLEAR	;CLEAR THE SCREEN
    BOX 0   0	5   79	2   ;DRAW A GREEN BOX
    ATSAY   2	3   10	"INITIALIZING XDS"

    LOCATE  7	0	;POSITION CURSOR

INIT_XDS:

    ATSAY   2	3   10	"GET XDS ATTENTION"
    TRANSMIT	"^["
    WAITFOR "^M?"   1
    IF	NOT WAITFOR
	GOTO	INIT_XDS
    ENDIF

    SET DISPLAY ON  ;TURN XDS DISPLAY BACK ON

    ATSAY   2	3   10	"ISSUE XDS INIT COMMAND"

    TRANSMIT	"INIT^M"
    WAITFOR " = " 1
    IF NOT WAITFOR
	GOTO INIT_XDS
    ENDIF

    PAUSE   1
    TRANSMIT	S9
    WAITFOR	" = " 1
    IF	NOT WAITFOR
	TRANSMIT    "^M"
    ENDIF

    PAUSE   1
    TRANSMIT	S8
    WAITFOR	" = "	1
    IF	NOT WAITFOR
	TRANSMIT    "^M"
    ENDIF

    PAUSE   1
    TRANSMIT	S7
    WAITFOR	"^M?"  1
    IF	NOT WAITFOR
	TRANSMIT    "^M"
    ENDIF

    ATSAY   2	3   10	"ISSUE XDS MAP COMMAND      "

    PAUSE   1
    TRANSMIT	"MAP^M"
    WAITFOR " = "

    PAUSE   1
    TRANSMIT	S6
    WAITFOR	" = "	1
    IF	NOT WAITFOR
	TRANSMIT    "^M"
    ENDIF

    PAUSE   1
    TRANSMIT	S5
    WAITFOR	" = "
    IF	NOT WAITFOR
	TRANSMIT    "^M"
    ENDIF

    PAUSE   1
    TRANSMIT	S4
    WAITFOR	" = "
    IF	NOT WAITFOR
	TRANSMIT    "^M"
    ENDIF

    PAUSE   1
    TRANSMIT	S3
    WAITFOR	"^M?"	1
    IF	NOT WAITFOR
	TRANSMIT    "^M"
    ENDIF

    ATSAY   2	3   10	"XDS INITIALIZATION COMPLETE    "
