;**************************************************************
;  
;                 load.asp
;  
;                 James M. Patterson
;  
;                 12-22-89
;  
;           (C) Texas Instruments Inc., 1992 
;  
;           Refer to the file 'license.txt' included with this 
;           this package for usage and license information. 
;  
;**************************************************************
;
;   TMS320C1x XDS/22 OBJECT FILE LOADER SCRIPT
;
;
;      James M. Patterson
;      Texas Instruments
;      370 South North Lake Boulevard
;      Altamonte Springs, Florida 32701
;


CLEAR	 ;CLEAR SCREEN

BOX 0 0 5 79 14
LOCATE	 6 0
ATSAY 1 25 14 "LOADING TI TAGGED OBJECT FILE"

FOPENI	 "XDS1.PRG" TEXT		;TRY TO OPEN PARAMETER FILE

IF  SUCCESS
    FREAD     S0   80	N0
    FCLOSEI
    ATSAY     2 3 10 "OBJECT FILE NAME: "
    ATSAY     2 21 11 S0		    ;DISPLAY NAME
    ATSAY     3 3 10 "SPECIFY NEW FILE? N"
    ATGET     3 21 11 1 S1		   ;GET NEW NAME ?

    STRCMP    S1 "Y"

    IF SUCCESS
	 ATGET	   2 21 11 50 S0
    ENDIF
    GOTO    DO_LOAD

ELSE
    ATSAY     3 3 4 "CAN'T OPEN PARAMTER FILE XDS1.PRG"
ENDIF

GET_NAME:
    CLEAR
    BOX 0 0 5 79 14
    ATSAY 1 25 14 "LOADING TI TAGGED OBJECT FILE"
    ATSAY     2 3 10 "ENTER OBJECT FILE NAME:                      "
    ATGET     2 28 11 50 S0

DO_LOAD:

WAKE_UP:

SET DISPLAY OFF
TRANSMIT "^["
WAITFOR "^M?" 1

IF NOT WAITFOR
    CLEAR
    ATSAY   3 3 4 "GETTING EMULATOR'S ATTENTION"
    GOTO    WAKE_UP
ENDIF

LOCATE 4 3

TRANSMIT "DL(0,0,0,1)^M"          ;ISSUE COMMAND
WAITFOR "^M"                      ;WAIT FOR XDS

SET DISPLAY ON

LOCATE 6 0			  ;REPOSITION CURSOR

ATSAY	 4 3 1 "DOWNLOAD IN PROGRESS                      "
SENDFILE ASCII	   S0		  ;DOWNLOAD FILE
TRANSMIT "^W"                     ;TERMINATE DOWNLOAD

IF  SUCCESS
    ATSAY   3 3 14 "UPDATING PARAMTER FILE XDS1.PRG                   "
    FOPENO    "XDS1.PRG" TEXT	   ;OPEN PROG FILE
    FPUTS     S0		  ;UPDATE PROGRAM
    FCLOSEO			  ;CLOSE THE FILE
    ATSAY     4 3 11 "LOAD COMPLETE                        "
    LOCATE    8 0
    TERMINAL
ELSE
    CLEAR
    BOX 0 0 5 79 14
    ATSAY 1 25 14 "LOADING TI TAGGED OBJECT FILE"
    ATSAY 4 3 4 "COULDN'T LOAD "
    ATSAY 4 16 4 S0
    ATSAY   3 3 11 "TRY AGAIN? (DEFAULT YES)                     "
    ATGET   3 29 10 3 S1
    STRCMP  S1	"NO"

    IF	SUCCESS
	CLEAR
	TERMINAL
	TRANSMIT    "^["
    ELSE
	ATSAY	3 36 10 "YES"
	GOTO	GET_NAME:
    ENDIF

ENDIF

TERMINAL
