;*********************************************************************
;
; Filename:  DATA.ASM   (receiver)
;
;
; Author:  Chris Buehler, Jonas Keating
; Date:  11/20/95
; Last revision: 12/23/95
;
;*********************************************************************
;
; Description:  Declares all the static data used for the decode portion
;		of the receiver.  Also reserves space for variables.
;		This includes the data for the viterbi decoder and
;		inverse mapper.
;
;
; Algorithm: none
;
;*********************************************************************
;
; Usage:  Just link it all in.
;
; Inputs:  none
;
; Outputs:  none
;
;*********************************************************************
;
; Comments:  The data is spaced out so that logical groupings of variables
;            fall on the same data pages.
;
;*********************************************************************
  .sect "intdata"

  .global       recvdata1,unshell_data
  .global       parm0,parm1,parm2,parm3,parm4
  .global       ytx,yty,xtx,xty
  .global       yx,yy,xx,xy
  .global       ux,uy,vx,vy
  .global       x1,y1,x2,y2
  .global       error1,error2, b_err
  .global       q,qmask,m
  .global       pr,pi,cr,ci
  .global       zold,znew,w
  .global       r0,qbits,ibits,mjk
  .global       bitstream,build_bitstream96
  .global       cmm,minstate
  .global       invtab,states
  .global       bpts, bend, bptr
  .global       n21, n22, n23, n24
  .global       n41, n42
  .global       w41, w42, w2, w8
  .global       g2,g4,z8
  .global	g2_addr,g4_addr,z8_addr,bit_addr
  .global       numshell
  .global       saveAR0,saveAR1,saveAR2,saveAR4,saveAR6
  .global       vt_cpm_prev, vt_cpm_curr, vt_ppp0, vt_ppp15
  .global       oldpptr,pptr,pend, vfcount,stateptr,vt_cpm1,vt_cpm2
  .global	g2_14_19,g4_14_19,z8_14_19,numshell


;------------ first data page -------------
recvdata1:
temps   .word   0,0,0,0,0
parm0   .word   0
parm1   .word   0
parm2   .word   0
parm3   .word   0
parm4   .word   0
saveAR0 .word   0
saveAR1 .word   0
saveAR2 .word   0
saveAR4 .word   0
saveAR6 .word   0
ytx     .word   0
yty     .word   0
xtx     .word   0,0,0,0
xty     .word   0,0,0,0
yx      .word   88,10
yy      .word   19,17
xx      .word   0,0,0
xy      .word   0,0,0
ux      .word   0
uy      .word   0
vx      .word   0
vy      .word   0

x1      .word   0,0,0,0
y1      .word   0,0,0,0
x2      .word   0,0,0,0
y2      .word   0,0,0,0

error1  .word   0,0,0,0
error2  .word   0,0,0,0
b_err   .word   0,0,0,0,0,0,0,0

;      9600  14.4  19.2
;q       -1     0     2
;qmask    0     1     7
q       .word   -1
qmask   .word   0
m       .word   0
pr      .word   0
pi      .word   0
cr      .word   0
ci      .word   0
zold    .word   0
znew    .word   0
w       .word   0
r0      .long   0
qbits   .word   0,0,0,0,0,0,0,0
ibits   .word   0,0,0,0
bitstream .word 0,0,0,0
cmm     .long   0
minstate .word  0
bptr    .word   bpts
pptr    .word   vt_ppp0
stateptr .word  states
oldpptr .word   vt_ppp15
vt_cpm_prev .word   vt_cpm1
vt_cpm_curr .word   vt_cpm2
vfcount .word   15
	.space  20*16

; ------- bpts takes 4 data pages ----------------------
bpts:   .space  16*32*16
bend:

; ------- invtab and states take 3 data pages ----------
invtab:
  .word   0,   0,   0,   0,   0,   0,   0,   0,   0, 238,   0,   0,   0,   0,   0,   0,   0,   0
  .word   0,   0,   0,   0,   0, 232, 210, 199, 190, 186, 194, 203, 222,   0,   0,   0,   0,   0
  .word   0,   0,   0,   0, 214, 183, 167, 152, 144, 142, 148, 158, 177, 201, 229,   0,   0,   0
  .word   0,   0,   0, 205, 175, 149, 128, 113, 106, 103, 108, 119, 135, 160, 189, 226,   0,   0
  .word   0,   0, 215, 176, 139, 115,  94,  80,  73,  69,  75,  84, 102, 126, 156, 193, 234,   0
  .word   0, 233, 184, 150, 116,  89,  67,  52,  45,  43,  50,  60,  77,  98, 131, 165, 206,   0
  .word   0, 211, 169, 130,  95,  68,  47,  33,  25,  22,  28,  39,   0,  79, 110, 146, 185, 236
  .word   0, 200, 153, 114,  82,  53,  34,  19,  11,   9,  13,  24,  41,  64,  96, 133, 173, 224
  .word   0, 192, 145, 107,  74,  46,  27,  12,   3,   1,   6,  17,  35,  58,  87, 123, 164, 216
  .word 239, 188, 143, 105,  70,  44,  23,  10,   2,   0,   4,  15,  31,  54,  83, 121, 162, 212
  .word   0, 196, 151, 109,  76,  51,  29,  14,   7,   5,   8,  20,  37,  62,  92, 125, 170, 218
  .word   0, 204, 159, 120,  86,  61,  40,  26,  18,  16,  21,  30,  55,  71, 100, 137, 181, 228
  .word   0, 223, 178, 136, 104,  78,  57,  42,  36,  32,  38,  49,  65,  90, 117, 154, 197,   0
  .word   0,   0, 202, 161, 129,  99,  81,  66,  59,  56,  63,  72,  91, 112, 140, 179, 220,   0
  .word   0,   0, 231, 191, 157, 132, 111,  97,  88,  85,  93, 101, 155, 141, 172, 207,   0,   0
  .word   0,   0,   0, 227, 195, 168, 147, 134, 124, 122, 127, 138,   0, 180, 208,   0,   0,   0
  .word   0,   0,   0,   0, 235, 209, 187, 174, 166, 163, 171, 182, 198, 221,   0,   0,   0,   0
  .word   0,   0,   0,   0,   0,   0, 237, 225, 217, 213, 219, 230,   0,   0

; removed     0,   0,   0,   0
states:
  .word   0,  18, 100, 118
  .word  16,   2, 116, 102
  .word  32,  50,  68,  86
  .word  48,  34,  84,  70
  .word  64,  82,  36,  54
  .word  80,  66,  52,  38
  .word  96, 114,   4,  22
  .word 112,  98,  20,   6
  .word  73,  91,  45,  63
  .word  89,  75,  61,  47
  .word 105, 123,  13,  31
  .word 121, 107,  29,  15
  .word   9,  27, 109, 127
  .word  25,  11, 125, 111
  .word  41,  59,  77,  95
  .word  57,  43,  93,  79

vt_cpm1: .space 2*16*16                 ; 16 longs
vt_cpm2: .space 2*16*16                 ; 16 longs

; vtable.inc contains the initialized viterbi table
  .include vtable.inc
pend:

g2:             .word 1, 2, 3, 4, 5, 6, 5, 4, 3, 2, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
g4:             .word 1, 4, 10, 20, 35, 56, 80, 104, 125, 140, 146, 140, 125, 104, 80, 56, 35, 20, 10, 4, 1, 0, 0
z8:             .long 0         ; z8[0]
		.long 1         ; z8[1]
		.long 9         ; z8[2]
		.long 45        ; z8[3]
		.long 165       ; z8[4]
		.long 495       ; z8[5]
		.long 1287      ; z8[6]
		.long 2995      ; z8[7]
		.long 6363      ; z8[8]
		.long 12510     ; z8[9]
		.long 22990     ; z8[10]
		.long 39798     ; z8[11]
		.long 65286     ; z8[12]
		.long 101974    ; z8[13]
		.long 152262    ; z8[14]
		.long 218070    ; z8[15]
		.long 300454    ; z8[16]
		.long 399267    ; z8[17]
		.long 512955    ; z8[18]
		.long 638543    ; z8[19]
		.long 771831    ; z8[20]
		.long 907785    ; z8[21]
		.long 1041073   ; z8[22]
		.long 1166661   ; z8[23]

unshell_data:
numshell .word 6
n21     .word   0
n22     .word   0
n23     .word   0
n24     .word   0
n41     .word   0
n42     .word   0
w41     .word   0
w42     .word   0
w2      .word   0
w8      .word   0
g2_addr	.word	g2
g4_addr	.word	g4
z8_addr	.word	z8
bit_addr .word	build_bitstream96
mjk     .word   0,0,0,0,0,0,0,0

  .space 9*16

; -----------------------START OF A DATA PAGE--------------------------

g2_14_19:	.word 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1
		.word 0, 0, 0, 0, 0, 0, 0, 0, 0,  0,  0,  0,  0,  0, 0, 0, 0, 0, 0, 0, 0, 0
g4_14_19:	.word 1, 4, 10, 20, 35, 56, 84, 120, 165, 220, 286, 364, 451, 544, 640, 736, 829, 916, 994, 1060, 1111, 1144
		.word 1156, 1144, 1111, 1060, 994, 916, 829, 736, 640, 544, 451, 364, 286, 220, 165, 120, 84, 56, 35, 20, 10, 4, 1, 0, 0, 0

  .space 35*16

; ------------------68 words of data in data page 5--------------------

; -----------------------START OF A DATA PAGE--------------------------


z8_14_19:	.long 0  		; z8[0]
		.long 1  		; z8[1]
		.long 9  		; z8[2]
		.long 45  		; z8[3]
		.long 165  		; z8[4]
		.long 495  		; z8[5]
		.long 1287  		; z8[6]
		.long 3003  		; z8[7]
		.long 6435  		; z8[8]
		.long 12870  		; z8[9]
		.long 24310  		; z8[10]
		.long 43758  		; z8[11]
		.long 75582  		; z8[12]
		.long 125962  		; z8[13]
		.long 203418  		; z8[14]
		.long 319410  		; z8[15]
		.long 488994  		; z8[16]
		.long 731511  		; z8[17]
		.long 1071279  		; z8[18]
		.long 1538251  		; z8[19]
		.long 2168595  		; z8[20]
		.long 3005145  		; z8[21]
		.long 4097665  		; z8[22]
		.long 5502861  		; z8[23]
		.long 7284069  		; z8[24]
		.long 9510568  		; z8[25]
		.long 12256488  	; z8[26]
		.long 15599304  	; z8[27]
		.long 19617928  	; z8[28]
		.long 24390432  	; z8[29]
		.long 29991456  	; z8[30]
		.long 36489376  	; z8[31]
		.long 43943328  	; z8[32]
		.long 52400205  	; z8[33]
		.long 61891765  	; z8[34]
		.long 72432009  	; z8[35]
		.long 84015009  	; z8[36]
		.long 96613331  	; z8[37]
		.long 110177163  	; z8[38]
		.long 124634223  	; z8[39]
		.long 139890487  	; z8[40]
		.long 155831742  	; z8[41]
		.long 172325934  	; z8[42]
		.long 189226246  	; z8[43]
		.long 206374806  	; z8[44]
		.long 223606890  	; z8[45]
		.long 240755450  	; z8[46]
		.long 257655762  	; z8[47]
		.long 274149954  	; z8[48]


  .space 30*16


  .end
