;*********************************************************************
;
; Filename: descram.asm
;
;
; Author: Hemanth Sampath, Carl Nuzman
; Date: 21 December, 1995
; Last revision: 21 december, 1995.
;
;*********************************************************************
;
; Description:   
;               ROUTINE 1: UNSCRAMBLE
;       This routine gets called by the routine fast_equalise in fast.asm
; This routine descrambles data from fr(i) and fi(i) and 
; and then puts the output in hr1(i) and hi1(i), to be used by  fast_equalise  
;               ROUTINE 2: UNSCRAMBLE2
;       This routine gets called by the routine fast_equalise in fast.asm
; This routine descrambles data from fr(i) and then puts the output 
; in gr(i), to be used by fast_equalise
; Then, it descrambles data from fi(i) and then puts the output in gr(i).
; to be used by fast_equalise.  

;*********************************************************************
;
; Usage:  Gets called by fast_equalise in file "fast.asm".
;       
;
; Inputs: Routine 1: Unscramble
;         fr(i) and fi(i), where i = 0.. 143.
;         Routine 2: Unscramble2
;         fr(i) and fi(i), where i = 0.. 143.
;
; Outputs: Routine 1: Unscramble 
;          hr1(i) and hi1(i)
;          Routine 2: Unscramble2
;          gr(i)         ; i = 0..143
; Variables used:  see individual sections below.
;
; Registers used:  see individual sections below.
;
;****************************************************************************
;               DECLARE GLOBAL VARIABLES
;****************************************************************************

	.global inpbuffer
	.global fast_equalise
	.global fr
	.global fi
	.global hr1
	.global hi1
	.global gr
	.global Bitable
	.global ft_inv
	.global ft_temp
	.global ft_br
	.global ft_bi
	.global ft_maxindex
	.global num
	.global den
	.global quot
	.global quot_frac
	.global quot2_frac
	.global quot
	.global ans_sign
	.global unscramble
	.global unscramble2
	.mmregs

;***************************************************************************
;               ROUTINE 1: UNSCRAMBLE
;***************************************************************************

unscramble:

	ldp #0                              ; Initialise pointers.
	splk #2,INDX
	lar AR0, #fr
	mar *, AR0
;-----------------------------------------------------------------------
; Unscramble fr(i) point by point and store output in hr1(i).

	bldd *+,#(hr1)                       
	bldd *0+,#(hr1+48)
	bldd *+,#(hr1+16)
	bldd *0+,#(hr1+64)
	bldd *0+,#(hr1+32)
	mar *+,AR0
	bldd *+,#(hr1+4)
	bldd *0+,#(hr1+52)
	bldd *+,#(hr1+20)
	bldd *0+,#(hr1+68)
	bldd *0+,#(hr1+36)
	mar *+,AR0
	bldd *+,#(hr1+8)
	bldd *0+,#(hr1+56)
	bldd *0+,#(hr1+24)
	mar *+,AR0
	bldd *0+,#(hr1+40)
	mar *+, AR0
	bldd *+,#(hr1+12)
	bldd *0+,#(hr1+60)
	bldd *0+,#(hr1+28)
	mar *+,AR0
	bldd *0+,#(hr1+44)
	mar *+,AR0
	bldd *+,#(hr1+1)
	bldd *0+,#(hr1+49)
	bldd *+,#(hr1+17)
	bldd *0+,#(hr1+65)
	bldd *0+,#(hr1+33)
	mar *+,AR0
	bldd *+,#(hr1+5)
	bldd *0+,#(hr1+53)
	bldd *+,#(hr1+21)
	bldd *0+,#(hr1+69)
	bldd *0+,#(hr1+37)
	mar *+,AR0
	bldd *+,#(hr1+9)
	bldd *0+,#(hr1+57)
	bldd *0+,#(hr1+25)
	mar *+,AR0
	bldd *0+,#(hr1+41)
	mar *+,AR0
	bldd *+,#(hr1+13)
	bldd *0+,#(hr1+61)



	bldd *0+,#(hr1+29)
	mar *+,AR0
	bldd *0+,#(hr1+45)
	mar *+, AR0
	bldd *+,#(hr1+2)
	bldd *0+,#(hr1+50)
	bldd *+,#(hr1+18)
	bldd *0+,#(hr1+66)
	bldd *0+,#(hr1+34)
	mar *+, AR0
	bldd *+,#(hr1+6)
	bldd *0+,#(hr1+54)
	bldd *+,#(hr1+22)
	bldd *0+,#(hr1+70)
	bldd *0+,#(hr1+38)
	mar *+, AR0
	bldd *+,#(hr1+10)
	bldd *0+,#(hr1+58)
	bldd *0+,#(hr1+26)
	mar *+, AR0
	bldd *0+,#(hr1+42)
	mar *+, AR0
	bldd *+,#(hr1+14)
	bldd *0+,#(hr1+62)
	bldd *0+,#(hr1+30)
	mar *+, AR0
	bldd *0+,#(hr1+46)
	mar *+, AR0
	bldd *+,#(hr1+3)
	bldd *0+,#(hr1+51)
	bldd *+,#(hr1+19)
	bldd *0+,#(hr1+67)
	bldd *0+,#(hr1+35)
	mar *+, AR0
	bldd *+,#(hr1+7)
	bldd *0+,#(hr1+55)
	bldd *+,#(hr1+23)
	bldd *0+,#(hr1+71)
	bldd *0+,#(hr1+39)
	mar *+, AR0

	bldd *+, #(hr1+11)
	bldd *0+, #(hr1+59)
	bldd *0+, #(hr1+27)
	mar *+, AR0
	bldd *0+, #(hr1+43)
	mar *+, AR0
	bldd *+, #(hr1+15)
	bldd *0+, #(hr1+63)
	bldd *0+, #(hr1+31)
	mar *+, AR0
	bldd *0+,#(hr1+47)
	mar *0+, AR0

;---------------------------------------------------------------------------
  ; Unscramble fi(i) point by point and store output in hi1(i). 

	lar AR0, #fi
	mar *, AR0


	bldd *+,#(hi1)
	bldd *0+,#(hi1+48)
	bldd *+,#(hi1+16)
	bldd *0+,#(hi1+64)
	bldd *0+,#(hi1+32)
	mar *+,AR0
	bldd *+,#(hi1+4)
	bldd *0+,#(hi1+52)
	bldd *+,#(hi1+20)
	bldd *0+,#(hi1+68)
	bldd *0+,#(hi1+36)
	mar *+,AR0
	bldd *+,#(hi1+8)
	bldd *0+,#(hi1+56)
	bldd *0+,#(hi1+24)
	mar *+,AR0
	bldd *0+,#(hi1+40)
	mar *+, AR0
	bldd *+,#(hi1+12)
	bldd *0+,#(hi1+60)
	bldd *0+,#(hi1+28)
	mar *+,AR0
	bldd *0+,#(hi1+44)
	mar *+,AR0
	bldd *+,#(hi1+1)
	bldd *0+,#(hi1+49)
	bldd *+,#(hi1+17)
	bldd *0+,#(hi1+65)
	bldd *0+,#(hi1+33)
	mar *+,AR0
	bldd *+,#(hi1+5)
	bldd *0+,#(hi1+53)
	bldd *+,#(hi1+21)
	bldd *0+,#(hi1+69)
	bldd *0+,#(hi1+37)
	mar *+,AR0
	bldd *+,#(hi1+9)
	bldd *0+,#(hi1+57)
	bldd *0+,#(hi1+25)
	mar *+,AR0
	bldd *0+,#(hi1+41)
	mar *+,AR0
	bldd *+,#(hi1+13)
	bldd *0+,#(hi1+61)



	bldd *0+,#(hi1+29)
	mar *+,AR0
	bldd *0+,#(hi1+45)
	mar *+, AR0
	bldd *+,#(hi1+2)
	bldd *0+,#(hi1+50)
	bldd *+,#(hi1+18)
	bldd *0+,#(hi1+66)
	bldd *0+,#(hi1+34)
	mar *+, AR0
	bldd *+,#(hi1+6)
	bldd *0+,#(hi1+54)
	bldd *+,#(hi1+22)
	bldd *0+,#(hi1+70)
	bldd *0+,#(hi1+38)
	mar *+, AR0
	bldd *+,#(hi1+10)
	bldd *0+,#(hi1+58)
	bldd *0+,#(hi1+26)
	mar *+, AR0
	bldd *0+,#(hi1+42)
	mar *+, AR0
	bldd *+,#(hi1+14)
	bldd *0+,#(hi1+62)
	bldd *0+,#(hi1+30)
	mar *+, AR0
	bldd *0+,#(hi1+46)
	mar *+, AR0
	bldd *+,#(hi1+3)
	bldd *0+,#(hi1+51)
	bldd *+,#(hi1+19)
	bldd *0+,#(hi1+67)
	bldd *0+,#(hi1+35)
	mar *+, AR0
	bldd *+,#(hi1+7)
	bldd *0+,#(hi1+55)
	bldd *+,#(hi1+23)
	bldd *0+,#(hi1+71)
	bldd *0+,#(hi1+39)
	mar *+, AR0

	bldd *+, #(hi1+11)
	bldd *0+, #(hi1+59)
	bldd *0+, #(hi1+27)
	mar *+, AR0
	bldd *0+, #(hi1+43)
	mar *+, AR0
	bldd *+, #(hi1+15)
	bldd *0+, #(hi1+63)
	bldd *0+, #(hi1+31)
	mar *+, AR0
	bldd *0+,#(hi1+47)
	mar *0+, AR0


	ret

;***************************************************************************
;               ROUTINE 2: UNSCRAMBLE2
;***************************************************************************


unscramble2:

; Descramble fr(i) or fi(i) point by point and store it gr(i)         
; The input can be either fr(i) or fi(i) and is decided by fast_equalise         
; im file fast.asm.
	 
	 bldd *+,#(gr+143)
	 bldd *+,#(gr+95)
	 bldd *+,#(gr+47)
	 bldd *+,#(gr+127)
	 bldd *+,#(gr+79)
	 bldd *+,#(gr+31)
	 bldd *+,#(gr+111)
	 bldd *+,#(gr+63)
	 bldd *+,#(gr+15)
	 bldd *+,#(gr+139)
	 bldd *+,#(gr+91)
	 bldd *+,#(gr+43)
	 bldd *+,#(gr+123)
	 bldd *+,#(gr+75)
	 bldd *+,#(gr+27)
	 bldd *+,#(gr+107)
	 bldd *+,#(gr+59)
	 bldd *+,#(gr+11)
	 bldd *+,#(gr+135)
	 bldd *+,#(gr+87)
	 bldd *+,#(gr+39)
	 bldd *+,#(gr+119)
	 bldd *+,#(gr+71)
	 bldd *+,#(gr+23)
	 bldd *+,#(gr+103)
	 bldd *+,#(gr+55)
	 bldd *+,#(gr+7)
	 bldd *+,#(gr+131)
	 bldd *+,#(gr+83)
	 bldd *+,#(gr+35)
	 bldd *+,#(gr+115)
	 bldd *+,#(gr+67)
	 bldd *+,#(gr+19)
	 bldd *+,#(gr+99)
	 bldd *+,#(gr+51)
	 bldd *+,#(gr+3)
	 bldd *+,#(gr+142)
	 bldd *+,#(gr+94)
	 bldd *+,#(gr+46)
	 bldd *+,#(gr+126)
	 bldd *+,#(gr+78)
	 bldd *+,#(gr+30)
	 bldd *+,#(gr+110)
	 bldd *+,#(gr+62)
	 bldd *+,#(gr+14)
	 bldd *+,#(gr+138)
	 bldd *+,#(gr+90)
	 bldd *+,#(gr+42)
	 bldd *+,#(gr+122)
	 bldd *+,#(gr+74)
	 bldd *+,#(gr+26)
	 bldd *+,#(gr+106)
	 bldd *+,#(gr+58)
	 bldd *+,#(gr+10)
	 bldd *+,#(gr+134)
	 bldd *+,#(gr+86)
	 bldd *+,#(gr+38)
	 bldd *+,#(gr+118)
	 bldd *+,#(gr+70)
	 bldd *+,#(gr+22)
	 bldd *+,#(gr+102)
	 bldd *+,#(gr+54)
	 bldd *+,#(gr+6)
	 bldd *+,#(gr+130)
	 bldd *+,#(gr+82)
	 bldd *+,#(gr+34)
	 bldd *+,#(gr+114)
	 bldd *+,#(gr+66)
	 bldd *+,#(gr+18)
	 bldd *+,#(gr+98)
	 bldd *+,#(gr+50)
	 bldd *+,#(gr+2)
	 bldd *+,#(gr+141)
	 bldd *+,#(gr+93)
	 bldd *+,#(gr+45)
	 bldd *+,#(gr+125)
	 bldd *+,#(gr+77)
	 bldd *+,#(gr+29)
	 bldd *+,#(gr+109)
	 bldd *+,#(gr+61)
	 bldd *+,#(gr+13)
	 bldd *+,#(gr+137)
	 bldd *+,#(gr+89)
	 bldd *+,#(gr+41)
	 bldd *+,#(gr+121)
	 bldd *+,#(gr+73)
	 bldd *+,#(gr+25)
	 bldd *+,#(gr+105)
	 bldd *+,#(gr+57)
	 bldd *+,#(gr+9)
	 bldd *+,#(gr+133)
	 bldd *+,#(gr+85)
	 bldd *+,#(gr+37)
	 bldd *+,#(gr+117)
	 bldd *+,#(gr+69)
	 bldd *+,#(gr+21)
	 bldd *+,#(gr+101)
	 bldd *+,#(gr+53)
	 bldd *+,#(gr+5)
	 bldd *+,#(gr+129)
	 bldd *+,#(gr+81)
	 bldd *+,#(gr+33)
	 bldd *+,#(gr+113)
	 bldd *+,#(gr+65)
	 bldd *+,#(gr+17)
	 bldd *+,#(gr+97)
	 bldd *+,#(gr+49)
	 bldd *+,#(gr+1)
	 bldd *+,#(gr+140)
	 bldd *+,#(gr+92)
	 bldd *+,#(gr+44)
	 bldd *+,#(gr+124)
	 bldd *+,#(gr+76)
	 bldd *+,#(gr+28)
	 bldd *+,#(gr+108)
	 bldd *+,#(gr+60)
	 bldd *+,#(gr+12)
	 bldd *+,#(gr+136)
	 bldd *+,#(gr+88)
	 bldd *+,#(gr+40)
	 bldd *+,#(gr+120)
	 bldd *+,#(gr+72)
	 bldd *+,#(gr+24)
	 bldd *+,#(gr+104)
	 bldd *+,#(gr+56)
	 bldd *+,#(gr+8)
	 bldd *+,#(gr+132)
	 bldd *+,#(gr+84)
	 bldd *+,#(gr+36)
	 bldd *+,#(gr+116)
	 bldd *+,#(gr+68)
	 bldd *+,#(gr+20)
	 bldd *+,#(gr+100)
	 bldd *+,#(gr+52)
	 bldd *+,#(gr+4)
	 bldd *+,#(gr+128)
	 bldd *+,#(gr+80)
	 bldd *+,#(gr+32)
	 bldd *+,#(gr+112)
	 bldd *+,#(gr+64)
	 bldd *+,#(gr+16)
	 bldd *+,#(gr+96)
	 bldd *+,#(gr+48)
	 bldd *+,#(gr+0)



	ret

