;*********************************************************************
;
; Filename:  PRE_FILT.ASM  (receiver)
;
; Author:  Chris Buehler, Jonas Keating
; Date:  11/20/95
; Last revision:  12/23/95
;
;*********************************************************************
;
; Description:  Contains routines:
;		1) precoder_filter_real
;		2) precoder_filter_imag
;		3) round_precoder_output
;		4) compute_un
;		5) compute_xn
;
; Algorithm:  Multiplies the precoder filter coefficients by the past
;	      three values of output.
;
;*********************************************************************
;
; Usage:  call precoder_filter_real,*,AR0
;		     or
;	  call precoder_filter_imag,*,AR0
;		     or
;	  call round_precoder_output
;		     or
;	  call compute_un
;		     or
;	  call compute_xn
;
; Inputs:  xy, xx for filter functions
;	   yx, yy for compute_un and compute_xn
;
; Outputs:  ACC for filter functions
;	    xy,xx for compute_xn
;	    ux,uy for compute_un
;
;*********************************************************************
;
; Comments:  These routines return their results in the accumulator.
;	     The first two routines require that AR0 are set as the
;	     active auxilliary register.
;            Together they form the inverse precoder.
;
;*********************************************************************

  .mmregs
  .text

  .global precoder_filter_real
  .global precoder_filter_imag
  .global round_precoder_output,compute_un,compute_xn
  .global quantize96
  .global xy,xx,yx,yy,recvdata1,saveAR0
  .global ci,cr,pi,pr,ux,uy
  .global hreal,himag

quantize96:
;//  ACCB = ACC;
;//  ACC = (labs(ACC) + 0x07F)>>7;
;  // we must mask out the 1st bit because we are rounding to the 2nd bit
;  //  all numbers should be even coming out of quantize96
;//  ACC &= 0xFFFFFFFEL;
;//  if(ACCB < 0)
;//	ACC = -ACC;

  bcnd quan_neg,LT
  add	#07Fh
  bsar	7
  and	#0FFFEh
  ret
quan_neg:
  abs
  add	#07Fh
  bsar	7
  and	#0FFFEh
  neg
  ret

precoder_filter_real:
;//  assumes AR0 is current ARP

;//  int p;
;//  ACC = 0;
;//  for(p=1; p < 4; p++)
;//  {
;//	ACC += xx[XOFF + n - p]*h[p-1].real -
;//		xy[XOFF + n - p]*h[p-1].imag;
;//  }
  ldpk	recvdata1
  sar	AR0,saveAR0
  lar	AR0,#xy 	;//This sets AR0 to the first element in xy (not yet shifted down)
  rptz	#2              ;//This seems to add 1 to AR0 so that the first element of xy is skipped
    mac   himag,*+
  apac
  sacb

  lar	AR0,#xx
  rptz	#2
    mac	  hreal,*+
  apac
  sbb
  lar	AR0,saveAR0
  ret

precoder_filter_imag:
;//  assumes AR0 is current ARP

;//  int p;
;//  ACC = 0;
;//  for(p=1; p < 4; p++)
;//  {
;//	ACC += xy[XOFF + n - p]*h[p-1].real +
;//		xx[XOFF + n - p]*h[p-1].imag;
;//  }
  ldpk	recvdata1
  sar	AR0,saveAR0
  lar	AR0,#xy
  rptz	#2
    macd   hreal,*+
  apac
  sacb

  lar	AR0,#xx
  rptz	#2
    macd   himag,*+
  apac
  addb
  lar	AR0,saveAR0
  ret

round_precoder_output:
;//  ACCB = ACC;
;//  ACC = (labs(ACC) + 0x01FFFL)>>14;

;//  if(ACCB < 0)
;//	ACC = -ACC;
  bcnd	rpo_neg,LT
  add	#1FFFh
  bsar	14
  ret
rpo_neg:
  abs
  add	#1FFFh
  bsar	14
  neg
  ret

compute_un:
  ldpk	recvdata1
;//  ux = (yx[0]>>7) - cr;
  lacc	yx
  bsar	7
  sub	cr
  sacl	ux

;//  uy = (yy[0]>>7) - ci;
  lacc	yy
  bsar	7
  sub	ci
  sacl	uy
  ret

compute_xn:
  ldpk	recvdata1
;//  xx[0] = yx[0] - pr;
  lacc	yx
  sub	pr
  sacl	xx

;//  xy[0] = yy[0] - pi;
  lacc	yy
  sub	pi
  sacl	xy
  ret


; precoder filter coefficients
  .sect "intdata"

;hreal:	.word	-2458,123,-2
hreal:  .word   0,0,0
himag: 	.word	0,0,0

  .end