/************************************************************************/
/*                 C50.CMD                                              */
/*    Command File for Linking C50 EVM Programs                         */
/*                                                                      */
/* Usage:                                                               */
/* dspcl <c files> -z C50.CMD <.obj files> -o <outfile> [-m <mapfile>]  */
/************************************************************************/

/*-c*/                       /* Use ROM autoinitialization model for C      */
/*-i c:\c50tools */          /* Path for library archives                   */
/*-l rts50.lib*/             /* runtime and math library archive            */
-x                       /* force rereading of libraries                */
/************************************************************************/

/*c50vect.obj  */            /* Include interrupt vectors                   */
/*c50ints.obj  */            /* Include interrupt handlers                  */

/************************************************************************/
/*    Specify memory map for C50 EVM                                    */
/************************************************************************/

MEMORY
/************************************************************************/
/*  Assumes internal program and data RAM enabled,  microprocessor mode */
/*  Set RAM = 1, OVLY = 1, MP/MC- = 1, CNF = 0                          */
/*     PMST = 0x0038,  ST1 = ST1 & 0xFEFF                               */
/*                                                                      */
/*  Modify debugger initialization file EVMINIT.CMD to include the line */
/*  ma 0x0100,1,0x200,ram  ;On-Chip RAM B0 in Data Memory               */
/************************************************************************/
{
 PAGE 0:           /* Program Memory  */

   VECS        : origin =    0h, length =   40h    /* Interrupt Vectors */

   Prog_RAM1   : origin =   40h, length =  7C0h  /* 40h to 7FFh */
					  /*  0h to 3Fh in external RAM */
   Int_RAMP    : origin =  800h, length = 2400h  /* 800h to 2BFFh */

   Prog_RAM2   : origin = 2C00h, length = 5400h    /* 40h to 7FFFh      */
	   /* This includes external RAM from 40h to 7FFh, internal     */
	   /* RAM  from 800h to 2BFFh, external RAM from 2C00h to 7FFFh */


 PAGE 1:           /* Data Memory     */

   RAM_B2      : origin =  60h , length =   20h    /* Internal RAM B2   */
						   /* 60h to 7Fh        */
   RAM_B0B1    : origin = 100h , length =  400h    /* Data RAM B0 & B1  */
						   /* 100h to 4FFh      */
   Int_RAMD    : origin = 800h , length = 2400h    /* Internal Data RAM */
						   /* 800h to 2BFFh     */
   Ext_RAM     : origin =8000h , length = 8000h    /* External Data RAM */
						   /* 8000h to FFFFh    */
}

SECTIONS
{
   vectors  :     >  VECS        PAGE = 0   /* interrupt branch vectors */
   .text    :     >  Prog_RAM1   PAGE = 0   /* code and float constants */
   intprog  :     >  Int_RAMP    PAGE = 0
   intdata  :     >  Int_RAMD    PAGE = 1
   extdata  :	  >  Ext_RAM     PAGE = 1
   .data    :     >  RAM_B0B1    PAGE = 1   /* Data initialized by the  */
		     /* assembly programs.  Not used by the C compiler. */
}
