;**********************************************************************
;
;  Filename: UNSHELL.ASM
;
;  Author: Chris Buehler
;  Date: 11/23/95
;  Last revision: 12/23/95
;
;**********************************************************************
;
;  Description:  This program undoes the shell mapping done in the
;    transmitter.
;
;  Algorithm:
;
;**********************************************************************
;
;  Usage:
;
;  Inputs: mjk
;
;  Outputs:
;
;  Registers used: ACC, ACCB, AR0, AR1, TREG0
;
;**********************************************************************
;
;  Comments:
;    12/23 -- Added header and some comments.
;	      HM
;
;**********************************************************************

  .mmregs
  .text

  .include macros.inc   ; defines temp_ variables

  .global	un_shell_map
  .global	unshell_data
  .global	n21, n22, n23, n24
  .global	n41, n42
  .global	n8
  .global	w41, w42, w2, w8
; two versions, one with tables in dual RAM, one without
  .global	g2,g4,z8
  .global	mjk,numshell
  .global	saveAR0,saveAR1
  .global	temp0

un_shell_map:

;//  if(m[6] + m[7] < M)
;//    n21 = m[6];
;//  else
;//    n21 = M-1-m[7];
; (standard way)
  spm	0
  ldpk	unshell_data
  sar	AR0,saveAR0
  sar	AR1,saveAR1
  lacc	(mjk+6)
  add	(mjk+7)
  sub   numshell

; alternative way? (delayed branch)
; ----------------
 bcndd	done_n21,LT
 lacc	(mjk+6)			; these 2
 sacl	n21			; always executed
 lacc	numshell
 sub	#1
 sub	(mjk+7)
 sacl	n21
done_n21:

;//  if(m[4] + m[5] < M)
;//    n22 = m[4];
;//  else
;//    n22 = M-1-m[5];
  lacc	(mjk+4)
  add	(mjk+5)
  sub   numshell
  bcndd	done_n22,LT
  lacc	(mjk+4)			; these 2
  sacl	n22			; always executed
  lacc	numshell
  sub	#1
  sub	(mjk+5)
  sacl	n22
done_n22:

;//  if(m[2] + m[3] < M)
;//    n23 = m[2];
;//  else
;//    n23 = M-1-m[3];
  lacc	(mjk+2)
  add	(mjk+3)
  sub   numshell
  bcndd	done_n23,LT
  lacc	(mjk+2)			; these 2
  sacl	n23			; always executed
  lacc	numshell
  sub	#1
  sub	(mjk+3)
  sacl	n23
done_n23:

;//  if(m[0] + m[1] < M)
;//    n24 = m[0];
;//  else
;//    n24 = M-1-m[1];
  lacc	(mjk+0)
  add	(mjk+1)
  sub   numshell
  bcndd	done_n24,LT
  lacc	(mjk+0)			; these 2
  sacl	n24			; always executed
  lacc	numshell
  sub	#1
  sub	(mjk+1)
  sacl	n24
done_n24:

;//  n41 = 0;
;//  w2 = m[4]+m[5];
;//  w41 = w2+m[6]+m[7];
;//  for(k = 0; k < w2; k++)
;//    n41 += g2[k]*g2[w41-k];
;//  n41+=n21*g2[w2];
;//  n41+=n22;
; (with g2 stored in dual-mode RAM)
  lacc	(mjk+4)			; calculate w2-1
  add	(mjk+5)			;   to use as RPTZ counter
  sub	#1
  sacl	w2			; w2 = mjk[4]+mjk[5]-1
  add	#(g2+1)
  samm	AR1			; AR1 contains g2+w2
  sub	#g2
  add	(mjk+6)
  add	(mjk+7)
  sacl	w41			; w41 = w2+mjk[6]+mjk[7]
  add	#g2
  samm	AR0
  lacc	w2
  bcndd	n41_noloop,LT
    zap		    		; AR0 now contains g2+w41
    mar	*,AR0
  rpt   w2
    mac	g2,*-
n41_noloop:
  mar	*,AR1			; make AR1 current
  lta	n21			; accumulate last product afer loop
  mpy	*			; preg = n21*g2[w2], ACC = n41 after loop
  apac				; ACC = ACC + n21*g2[w2]
  add	n22			; ACC = n41
  sacl	n41

;//  n41 = 0;
;//  w2 = m[4]+m[5];
;//  w41 = w2+m[6]+m[7];
;//  for(k = 0; k < w2; k++)
;//    n41 += g2[k]*g2[w41-k];
;//  n41+=n21*g2[w2];
;//  n41+=n22;
; (with g2 stored in standard data memory)
; use RPTB I guess
;
;  lacc	(mjk+4)			; calculate w2-1
;  add	(mjk+5)			;   to use as RPTB counter
;  sub	#1
;  samm	BRCR			; save loopcount in BRCR
;  add	#1
;  add	(mjk+6)
;  add	(mjk+7)
;  sacl	w41			; w41 = w2+mjk[6]+mjk[7]
;
;  add	#g2
;  samm	AR0                     ; AR0 = g2+w41
;  mar	*,AR0			; AR0 is current
;  lar	AR1,#g2		    	; AR1 = g2
;
;  zap
;  rptb  (n41_loop-1)
;  lt	*-,AR1			; load treg with *AR0, make AR1 current
;  mpyu	*+,AR0			; multiply treg*AR1, make AR0 current
;  apac				; need 3 instructions, might as well do it
;				; this way
;				; after loop: AR1 = g2 + w2, AR0= g2+w41-w2
;n41_loop:
;  mar	*,AR1			; make AR1 current
;  lt	n21			; treg = n21
;  mpyu				; preg = n21*g2[w2], ACC = n41 after loop
;  apac				; ACC = ACC + n21*g2[w2]
;  add	n22			; ACC = n41
;  sacl	n41

;//  n42 = 0;
;//  w2 = m[0]+m[1];
;//  w42 = w2+m[2]+m[3];
;//  for(k = 0; k < w2; k++)
;//    n42 += g2[k]*g2[w42-k];
;//  n42+=n23*g2[w2];
;//  n42+=n24;
; (with g2 stored in dual-mode RAM)
  lacc	(mjk+0)			; calculate w2-1
  add	(mjk+1)			;   to use as RPTZ counter
  sub	#1
  sacl	w2			; w2 = mjk[0]+mjk[1]-1
  add	#(g2+1)
  samm	AR1			; AR1 contains g2+w2
  sub	#g2
  add	(mjk+2)
  add	(mjk+3)
  sacl	w42			; w42 = w2+mjk[2]+mjk[3]
  add	#g2
  samm	AR0
  lacc	w2
  bcndd	n42_noloop,LT
    mar	*,AR0			; AR0 is current
    zap		    		; AR0 now contains g2+w41
  rpt   w2
    mac	g2,*-
n42_noloop:
  mar	*,AR1			; make AR1 current
  lta	n23			; accumulate last product afer loop
  mpy	*			; preg = n23*g2[w2], ACC = n41 after loop
  apac				; ACC = ACC + n23*g2[w2]
  add	n24			; ACC = n42
  sacl	n42

;//  n8 = 0;
;//  w8 = w41+w42;
;//  for(k=0; k < w42; k++)
;//    n8 += g4[k]*g4[w8-k];
;//  n8+=n41*g4[w42];
;//  n8+=n42;
; (with g2 stored in dual-mode RAM)
  lacc	w42			; calculate w2-1
  sub	#1
  sacl	w42			; w42 = w42-1
  add	#(g4+1)
  samm	AR1			; AR1 contains g4+w42
  add	w41
  samm	AR0			; AR0 contains g4+w42+w41
  lacc	w42
  bcndd n8_noloop,LT
    mar	*,AR0			; AR0 is current
    zap
  rpt   w42
    mac	g4,*-
n8_noloop:
  mar	*,AR1			; make AR1 current
  lta	n41			; accumulate last product afer loop
  mpy	*			; preg = n41*g4[w42], ACC = n8 after loop
  apac				; ACC = ACC + n41*g4[w42]
  add	n42			; ACC = n8
  sacb				; save 32-bit n8 in ACC buffer

;//  return z8[w8]+n8;
  lacc	w41
  add	w42
  add	#1
  sfl       			; ACC = 2*(w41+w42) [long addressing]
  add	#1
  add	#z8                     ;   recall w8 = w42+w41;
  sacl	temp0
  lar	AR1,temp0		; AR1 = z8 + 2*(w41+w42)
  lacc	*-,16			; ACC = z8[w8]
  or	*
  addb                          ; ACC = n8+z8[w8]

; restore saved stuff
  lar	AR0,saveAR0
  lar	AR1,saveAR1
  ret
  .end

