;**************************************************************************
; File name:	X24x.h
; Project:		F241/243 silicon functional test
; Originator:	DSP Digital Control Systems (DCS) Group (Houston)
;
; Description:	F240-3/C240-3 register definitions.
;__________________________________________________________________________
; Date of Mod	|			Description
;--------------------------------------------------------------------------
; Jan. 15, 1998	| Created from header file used by design
;
;
;--------------------------------------------------------------------------
; Data memory mapped registers
;--------------------------------------------------------------------------

; C2xx core registers
IMR		.set 0004h		; Interrupt Mask Register
GREG		.set 0005h		; Global memory allocation Register 
IFR		.set 0006h		; Interrupt Flag Register

; System configuration and interrupt registers
SYSCR		.set 7018h		; System Module Control Register. X240 only.
SYSSR		.set 701Ah		; System Module Status Register. X240 only.
SYSIVR	.set 701Eh		; System Interrupt Vector Register. X240 only.

SCSR		.set 7018h		; System Control & System Status Reg. X241/2/3 only.
DIN		.set 701Ch		; Device Identification Register.
PIVR		.set 701Eh		; Peripheral Interrupt Vector Reg. X241/2/3 only.
PIRQR0	.set 7010h		; Peripheral Interrupt Request Reg 0. X241/2/3 only.
PIRQR1	.set 7011h		; Peripheral Interrupt Request Reg 1. X241/2/3 only.

; PLL configuration registers
CKCR0		.set 702ah		; PLL Clock Control Register 0. X240 only.
CKCR1		.set 702ch		; PLL Clock Control Register 1. X240 only.

; External interrupt configuration registers
XINT1CR	.set 7070h		; Int1 (type A) Control reg for X240 only.
					; External interrupt 1 config reg for X241/2/3 only.
NMICR		.set 7072h		; Non maskable Int (type A) Control reg. X240 only.
XINT2CR240	.set 7078h		; Int2 (type C) Control reg. X240 only.
XINT2CR241	.set 7071h		; External interrupt 2 config. X241/2/3 only.
XINT3CR	.set 707Ah		; Int3 (type C) Control reg. X240 only.

; Digital I/O registers
OCRA		.set 7090h		; Output Control Reg A
OCRB		.set 7092h		; Output Control Reg B
ISRA 		.set	7094h	;Input Status Reg A. X240 only
ISRB 		.set	7096h	;Input Status Reg B. X240 only
PADATDIR	.set 7098h		; I/O port A Data & Direction reg.
PBDATDIR	.set 709Ah		; I/O port B Data & Direction reg.
PCDATDIR	.set 709Ch		; I/O port C Data & Direction reg.
PDDATDIR	.set 709Eh		; I/O port D Data & Direction reg.

; Watchdog (WD) registers
WDCNTR	.set 7023h		; WD Counter reg
WDKEY		.set 7025h		; WD Key reg
WDCR		.set 7029h		; WD Control reg

; Real Time Interrupt registers
RTICNTR	.set 7021h		; RTI counter reg. X240 only.
RTICR		.set 7027h		; RTI control reg. X240 only.

; ADC registers
ADCTRL1	.set 7032h		; ADC Control Reg1
ADCTRL2	.set 7034h		; ADC Control Reg2
ADCFIFO1	.set 7036h		; ADC DATA REG FIFO for ADC1
ADCFIFO2	.set 7038h		; ADC DATA REG FIFO for ADC2

; SPI registers
SPICCR	.set 7040h		; SPI Config Control Reg
SPICTL	.set 7041h		; SPI Operation Control Reg
SPISTS	.set 7042h		; SPI Status Reg
SPIBRR	.set 7044h		; SPI Baud rate control reg
SPIRXEMU	.set 7046h		; SPI Emulation buffer reg
SPIRXBUF	.set 7047h		; SPI Serial receive buffer reg
SPITXBUF	.set 7048h		; SPI Serial transmit buffer reg
SPIDAT	.set 7049h		; SPI Serial data reg
SPIPC1	.set 704Dh		; SPI Port Control Register 1. X240 only.
SPIPC2	.set 704Eh		; SPI Port Control Register 2. X240 only.
SPIPRI	.set 704Fh		; SPI Priority control reg

; SCI registers
SCICCR	.set 7050h		; SCI Communication control reg
SCICTL1	.set 7051h		; SCI Control reg1
SCIHBAUD	.set 7052h		; SCI Baud Rate MSbyte reg
SCILBAUD	.set 7053h		; SCI Baud Rate LSbyte reg
SCICTL2	.set 7054h		; SCI Control reg2
SCIRXST	.set 7055h		; SCI Receiver Status reg
SCIRXEMU	.set 7056h		; SCI Emulation Data Buffer reg
SCIRXBUF	.set 7057h		; SCI Receiver Data buffer reg
SCITXBUF	.set 7059h		; SCI Transmit Data buffer reg
SCIPC2	.set 705Eh		; SCI Port Control reg2 (X240 only)
SCIPRI	.set 705Fh		; SCI Priority control reg

; Event Manager (EV) registers 
GPTCON	.set 7400h		; GP Timer control register. 
T1CNT		.set 7401h		; GP Timer 1 counter register. 
T1CMPR	.set 7402h		; GP Timer 1 compare register. 
T1PR		.set 7403h		; GP Timer 1 period register. 
T1CON		.set 7404h		; GP Timer 1 control register. 
T2CNT		.set 7405h		; GP Timer 2 counter register. 
T2CMPR	.set 7406h		; GP Timer 2 compare register. 
T2PR		.set 7407h		; GP Timer 2 period register. 
T2CON		.set 7408h		; GP Timer 2 control register. 
T3CNT		.set 7409h		; GP Timer 3 counter register. X240 only.
T3CMPR	.set 740Ah		; GP Timer 3 compare register.  X240 only.
T3PR		.set 740Bh		; GP Timer 3 period register.  X240 only.
T3CON		.set 740Ch		; GP Timer 3 control register. X240 only.

COMCON	.set 7411h		; Compare control register.
ACTR		.set 7413h		; Full compare action control register.
SACTR		.set 7414h		; Simple compare action control register. 
DBTCON	.set 7415h		; Dead-band timer control register. 

CMPR1		.set 7417h		; Full compare unit compare register1. 
CMPR2		.set 7418h		; Full compare unit compare register2.
CMPR3		.set 7419h		; Full compare unit compare register3.

SCMPR1	.set 741Ah		; Single compare unit compare register1. X240 only.
SCMPR2	.set 741Bh		; Single compare unit compare register2. X240 only.
SCMPR3	.set 741Ch		; Single compare unit compare register3. X240 only.

CAPCON	.set 7420h		; Capture control register. 
CAPFIFO 	.set 7422h		; Capture FIFO status register. 
			
CAP1FIFO	.set 7423h		; Capture Channel 1 FIFO Top
CAP2FIFO	.set 7424h		; Capture Channel 2 FIFO Top
CAP3FIFO	.set 7425h		; Capture Channel 3 FIFO Top
CAP4FIFO	.set 7426h		; Capture Channel 4 FIFO Top. X240 only.

EVIMRA	.set 742Ch		; Group A Interrupt Mask Register
EVIMRB	.set 742Dh		; Group B Interrupt Mask Register
EVIMRC	.set 742Eh		; Group C Interrupt Mask Register

EVIFRA	.set 742Fh		; Group A Interrupt Flag Register 
EVIFRB	.set 7430h		; Group B Interrupt Flag Register
EVIFRC	.set 7431h		; Group C Interrupt Flag Register

EVIVRA	.set 7432h		; Group A Int. Vector Register. X240 only.
EVIVRB	.set 7433h		; Group B Int. Vector Register. X240 only.
EVIVRC	.set 7434h		; Group C Int. Vector Register. X240 only.

; CAN(SCC) registers. X241/2/3 only.
CANMDER	.set 7100h		; CAN Mailbox Direction/Enable reg
CANTCR	.set 7101h		; CAN Transmission Control Reg
CANRCR	.set 7102h		; CAN Recieve COntrol Reg
CANMCR	.set 7103h		; CAN Master Control Reg
CANBCR2	.set 7104h		; CAN Bit COnfig Reg 2
CANBCR1	.set 7105h		; CAN Bit Config Reg 1
CANESR	.set 7106h		; CAN Error Status Reg
CANGSR	.set 7107h		; CAN Global Status Reg
CANCEC	.set 7108h		; CAN Trans and Rcv Err counters
CANIFR	.set 7109h		; CAN Interrupt Flag Registers 
CANIMR	.set 710ah		; CAN Interrupt Mask Registers
CANLAM0H	.set 710bh		; CAN Local Acceptance Mask MBx0/1
CANLAM0L	.set 710ch		; CAN Local Acceptance Mask MBx0/1
CANLAM1H	.set 710dh		; CAN Local Acceptance Mask MBx2/3
CANLAM1L	.set 710eh		; CAN Local Acceptance Mask MBx2/3

CANMSGID0L	.set 7200h		; CAN Message ID for mailbox 0 (lower 16 bits)	
CANMSGID0H	.set 7201h		; CAN Message ID for mailbox 0 (upper 16 bits)	
CANMSGCTRL0	.set 7202h		; CAN RTR and DLC	
CANMBX0A	.set 7204h		; CAN 2 of 8 bytes of Mailbox 0	
CANMBX0B	.set 7205h		; CAN 2 of 8 bytes of Mailbox 0	
CANMBX0C	.set 7206h		; CAN 2 of 8 bytes of Mailbox 0	
CANMBX0D	.set 7207h		; CAN 2 of 8 bytes of Mailbox 0	
CANMSGID1L	.set 7208h		; CAN Message ID for mailbox 1 (lower 16 bits)	
CANMSGID1H	.set 7209h		; CAN Message ID for mailbox 1 (upper 16 bits)	
CANMSGCTRL1	.set 720Ah		; CAN RTR and DLC	
CANMBX1A	.set 720Ch		; CAN 2 of 8 bytes of Mailbox 1	
CANMBX1B	.set 720Dh		; CAN 2 of 8 bytes of Mailbox 1	
CANMBX1C	.set 720Eh		; CAN 2 of 8 bytes of Mailbox 1	
CANMBX1D	.set 720Fh		; CAN 2 of 8 bytes of Mailbox 1	
CANMSGID2L	.set 7210h		; CAN Message ID for mailbox 2 (lower 16 bits)	
CANMSGID2H	.set 7211h		; CAN Message ID for mailbox 2 (upper 16 bits)	
CANMSGCTRL2	.set 7212h		; CAN RTR and DLC	
CANMBX2A	.set 7214h		; CAN 2 of 8 bytes of Mailbox 2	
CANMBX2B	.set 7215h		; CAN 2 of 8 bytes of Mailbox 2	
CANMBX2C	.set 7216h		; CAN 2 of 8 bytes of Mailbox 2	
CANMBX2D	.set 7217h		; CAN 2 of 8 bytes of Mailbox 2	
CANMSGID3L	.set 7218h		; CAN Message ID for mailbox 3 (lower 16 bits)	
CANMSGID3H	.set 7219h		; CAN Message ID for mailbox 3 (upper 16 bits)	
CANMSGCTRL3	.set 721Ah		; CAN RTR and DLC	
CANMBX3A	.set 721Ch		; CAN 2 of 8 bytes of Mailbox 3	
CANMBX3B	.set 721Dh		; CAN 2 of 8 bytes of Mailbox 3	
CANMBX3C	.set 721Eh		; CAN 2 of 8 bytes of Mailbox 3	
CANMBX3D	.set 721Fh		; CAN 2 of 8 bytes of Mailbox 3	
CANMSGID4L	.set 7220h		; CAN Message ID for mailbox 4 (lower 16 bits)	
CANMSGID4H	.set 7221h		; CAN Message ID for mailbox 4 (upper 16 bits)	
CANMSGCTRL4	.set 7222h		; CAN RTR and DLC	
CANMBX4A	.set 7224h		; CAN 2 of 8 bytes of Mailbox 4	
CANMBX4B	.set 7225h		; CAN 2 of 8 bytes of Mailbox 4	
CANMBX4C	.set 7226h		; CAN 2 of 8 bytes of Mailbox 4	
CANMBX4D	.set 7227h		; CAN 2 of 8 bytes of Mailbox 4	
CANMSGID5L	.set 7228h		; CAN Message ID for mailbox 5 (lower 16 bits)	
CANMSGID5H	.set 7229h		; CAN Message ID for mailbox 5 (upper 16 bits)	
CANMSGCTRL5	.set 722Ah		; CAN RTR and DLC	
CANMBX5A	.set 722Ch		; CAN 2 of 8 bytes of Mailbox 5	
CANMBX5B	.set 722Dh		; CAN 2 of 8 bytes of Mailbox 5	
CANMBX5C	.set 722Eh		; CAN 2 of 8 bytes of Mailbox 5	

;--------------------------------------------------------------------------
; I/O space mapped registers
;--------------------------------------------------------------------------
WSGR		.set	0FFFFh	; Wait-State Generator Control Reg

;--------------------------------------------------------------------------
; Bit codes for Test bit instruction (BIT) (15 Loads bit 0 into TC)
;--------------------------------------------------------------------------
BIT15		.set 0000h		; Bit Code for 15
BIT14		.set 0001h		; Bit Code for 14
BIT13		.set 0002h		; Bit Code for 13
BIT12		.set 0003h		; Bit Code for 12
BIT11		.set 0004h		; Bit Code for 11
BIT10		.set 0005h		; Bit Code for 10
BIT9		.set 0006h		; Bit Code for 9
BIT8		.set 0007h		; Bit Code for 8
BIT7		.set 0008h		; Bit Code for 7
BIT6		.set 0009h		; Bit Code for 6
BIT5		.set 000Ah		; Bit Code for 5
BIT4		.set 000Bh		; Bit Code for 4
BIT3		.set 000Ch		; Bit Code for 3
BIT2		.set 000Dh		; Bit Code for 2
BIT1		.set 000Eh		; Bit Code for 1
BIT0		.set 000Fh		; Bit Code for 0

;--------------------------------------------------------------------------
;Test mode on and off constants;--------------------------------------------------------------------------

ABRPT		.set    01fh		; Analysis BreakPoint Register
PSA_ON	.set    03A1h		; Turn PSA and FEEDB on
PSA_FB_OFF .set    0121h           ; Turn PSA and FEEDB off
