;*****************************************************************************
; File Name:    sci .asm  
; Project:      F241 Silicon Functional Tests
; Originator:   Texas Instruments
;               Modified 2/5/1998  
; Target Sys:   F241/3 Test Bed prototype (1st Rev PWB)
;
; Description:  PC Echo Test.
;                The SCI is set up to bounce back any character from the 
;                Serial link.
;                When connected to the PC, with a terminal application
;                running on the PC the PC sees the characters bounced back.
;
;        
; Last Update:  2/26/1998
;-----------------------------------------------------------------------------
; Debug directives
;-----------------------------------------------------------------------------
		.def	GPR0		;General purpose registers.
		.def	GPR1
		.def	GPR2
		.def	GPR3
                .def    GPR4
;-----------------------------------------------------------------------------
; Constant Definitions
;-----------------------------------------------------------------------------

WAIT_STATE      .set    000000000b

        
                .include        x24x.h
;-----------------------------------------------------------------------------
; Variable Declarations for on chip RAM Blocks
;-----------------------------------------------------------------------------
		.bss	GPR0,1		;General purpose registers.
		.bss	GPR1,1
		.bss	GPR2,1
		.bss	GPR3,1
                .bss    GPR4,1
		.bss	REG5,1
		.bss	REGA,1

;-----------------------------------------------------------------------------
; M A C R O - Definitions
;-----------------------------------------------------------------------------
SBIT0		.macro	DMA, MASK	;Clear bit Macro
		LACC	DMA
		AND	#(0FFFFh-MASK)
		SACL	DMA
		.endm

SBIT1		.macro	DMA, MASK	;Set bit Macro
		LACC	DMA
		OR	#MASK
		SACL	DMA
		.endm

KICK_DOG	.macro			;Watchdog reset macro
		LDP	#00E0h
                SPLK    #05555h, WDKEY
                SPLK    #0AAAAh, WDKEY
		LDP	#0h
               .endm

;-----------------------------------------------------------------------------
; Vector address declarations
;-----------------------------------------------------------------------------
	  .sect  ".vectors"


;
; The Reset Vector is directed into the Entry Point of the Serial Boot Loader
; of the F241 or 243 (user version). 
;
;
RSVECT          B    1F00H      ; PM 0  Reset Vector    1

INT1	  	B    PHANTOM	; PM 2	Int level 1		4
INT2	  	B    PHANTOM	; PM 4	Int level 2		5
INT3	  	B    PHANTOM	; PM 6	Int level 3		6
INT4	  	B    PHANTOM	; PM 8	Int level 4		7
INT5	  	B    PHANTOM	; PM A	Int level 5		8
INT6	  	B    PHANTOM	; PM C	Int level 6		9
RESERVED  	B    PHANTOM	; PM E	(Analysis Int)	10
SW_INT8   	B    PHANTOM	; PM 10  	User S/W int	-
SW_INT9   	B    PHANTOM	; PM 12  	User S/W int	-
SW_INT10  	B    PHANTOM	; PM 14  	User S/W int	-
SW_INT11  	B    PHANTOM	; PM 16  	User S/W int	-
SW_INT12  	B    PHANTOM	; PM 18  	User S/W int	-
SW_INT13  	B    PHANTOM	; PM 1A  	User S/W int	-
SW_INT14  	B    PHANTOM	; PM 1C  	User S/W int	-
SW_INT15  	B    PHANTOM	; PM 1E  	User S/W int	-
SW_INT16  	B    PHANTOM	; PM 20  	User S/W int	-
TRAP	  	B    PHANTOM	; PM 22  	Trap vector		-
NMI	  	B    PHANTOM	; PM 24  	Non maskable Int	3
EMU_TRAP  	B    PHANTOM	; PM 26  	Emulator Trap	2
SW_INT20  	B    PHANTOM	; PM 28  	User S/W int	-
SW_INT21  	B    PHANTOM	; PM 2A  	User S/W int	-
SW_INT22  	B    PHANTOM	; PM 2C  	User S/W int	-
SW_INT23  	B    PHANTOM	; PM 2E  	User S/W int	-

;==============================================================================
; M A I N   C O D E  - starts here
;==============================================================================
		.text
START:		
		LDP 	#0


		SETC	INTM    		;Disable interrupts
                CLRC    SXM                     ;Clear Sign Extension Mode
                CLRC    OVM                     ;Reset Overflow Mode
                CLRC    CNF                     ;Config Block B0 to Data mem.

		LDP	#00E0h
                SPLK    #006Fh,WDCR             ;Disable WD if VCCP=5V

		KICK_DOG				

		LDP	#00E0h
                SPLK    #0000h,SCSR             ;CLKOUT=CPUCLK
                         
;==============================================================================
;SCI TRANSMISSION TEST - starts here
;==============================================================================

SCI:
		LDP	#OCRA>>7
		SPLK	#0FFFFh,OCRA

		LAR     AR1, #SCIRXBUF          ;Load AR1 with SCI_RX_BUF address
                LAR     AR0, #SCITXBUF          ;Load AR0 with SCI_TX_BUF address

                LDP     #00h

                SPLK    #0055h, GPR0            ;Start with Char=55h
                SPLK    #0000,  GPR1            ;Clear Error counter
                SPLK    #0014h, GPR2            ;Set to xmit/rcv 20 chars

		LDP	#SCICCR>>7
                SPLK    #0007h, SCICCR          ;1 stop bit,odd parity,8 char bits,
                                                ;async mode, idle-line protocol
                SPLK    #0013h, SCICTL1         ;Enable TX, RX, internal SCICLK,
                                                ;Disable RX ERR, SLEEP, TXWAKE

                SPLK    #0000h, SCICTL2         ;Disable RX & TX INTs

                SPLK    #0008h, SCIHBAUD
                SPLK    #0022h, SCILBAUD        ;Baud Rate

         
		LDP	#SCICCR>>7
                SPLK    #0023h, SCICTL1         ;Relinquish SCI from Reset.

RCV:            LDP     #SCIRXST>>7

RCV_RDY:        BIT     SCIRXST,BIT6             ;Test TXRDY bit
                BCND    RCV_RDY,NTC            ;If TXRDY=0,then repeat loop

READ_CHR:       LDP     #SCIRXBUF>>7
                LAC     SCIRXBUF

XMIT_CHAR:      LARP    AR0
                SACL    *,AR0                   ;Write xmit char to TX buffer

;                LDP     #SCICTL2>>7
;XMIT_RDY:       BIT     SCICTL2,BIT7            ;Test TXRDY bit
;                BCND    XMIT_RDY,NTC            ;If TXRDY=0,then repeat loop


                KICK_DOG
                B       RCV                     ;else wait for nexr character


;==============================================================================
; I S R  -  PHANTOM
;
; Description:	Dummy ISR, used to trap spurious interrupts.
;
; Modifies:	Nothing
;
; Last Update:	16 June 95
;==============================================================================
PHANTOM         B PHANTOM

