	.title "Reverb Program"		; title 
	.include	"..\\include\\pathway.inc"

*Constants
rxbuf	.set	0d00h			; Recieve buffer starting address
buffend	.set	017ffh              	; Recieve buffer end address
size	.set	buffend-rxbuf		; Recieve buffer size
delay	.set    03aah			; Length of reverb delay
size2	.set	015feh

	.ds 310h                    	; starting address for this section is
		                        ; 300h in Data Space
*uninitialized variables
outval	.word	0			; Storage space for output value
buffpt	.word	0			; Storage space for current buffer ptr
cinfo	.word	0
base	.word	0
indat	.word	0
hilo	.word	0
ARG1	.word	0
ARG2	.word	0
SUM	.word	0
MANT	.word	0
EXP	.word	0
BIAS	.word	0



        .ps 8000h      			; starting address for this 
	                       		; section is 8000h in Program Space
	b	0000h           	;00; restart the monitor
	b	0000h            	;02; restart the monitor
	b	0000h             	;04; restart the monitor
	b   	0000h          		;06; restart the monitor
	b	rxrev            	;08; restart the monitor
	b	codtx	         	;0a; restart the monitor
	b	0000h         		;0c; restart the monitor
	.space 2*16           		;0e; Reserved Space
	b	0000h            	;10; restart the monitor
	b	0000h         		;12; restart the monitor
	b	0000h           	;14; restart the monitor
	b	0000h            	;16; restart the monitor
	b	0000h            	;18; restart the monitor
	b	0000h    	     	;1a; restart the monitor
	b	0000h           	;1c; restart the monitor
	b	0000h           	;1e; restart the monitor
	b	0000h            	;20; restart the monitor
	b	0000h           	;22; restart the monitor
	b	0000h           	;24; restart the monitor
	.space 2*16             	;26; Reserved Space
	b	0000h           	;28; restart the monitor
	b	0000h           	;2a; restart the monitor
	b	0000h           	;2c; restart the monitor
	b	0000h           	;2e; restart the monitor
	b	0000h           	;30; restart the monitor
	b	0000h           	;32; restart the monitor
	b	0000h           	;34; restart the monitor
	b	0000h           	;36; restart the monitor
	b	0000h           	;38; restart the monitor
	b	0000h           	;3a; restart the monitor
	b	0000h           	;3c; restart the monitor
	b	0000h  		       	;3e; restart the monitor

	.ps 8050h			; starting address for this section
					; is 8050h in Program Space
	.entry				; define the entry point of the program

start:	ldp	#cinfo			; Set DP=0 to access memory mapped regs
	setc 	intm			; Disable interrupts
	setc	sxm			; Disable sign extension
	clrc	ovm
	clrc	cnf
	splk	#0000h,cinfo          	; Set zero wait states
	out	cinfo,WSGR
	splk	#0c002h, cinfo		; Reset Sync Serial port, set in burst
	out	cinfo, SSPCR         	; mode with one word FIFO Bring transmit
	splk	#0c032h, cinfo		; and recieve out of reset
	out	cinfo, SSPCR          


	; reset the AIC so any old settings get wiped out
	in      cinfo, IOSR         	; read IOSR
	lacl    cinfo              	; acc = cinfo
	and     #0fff7h             	; make IO3 = 0
	sacl    cinfo               	; store acc to cinfo
	out     cinfo, IOSR         	; write to IOSR, put AIC in reset

	in      cinfo, IOSR        	; read IOSR
	lacl    cinfo             	; acc = cinfo
	or      #00f8h			; make IO3 = 1
	sacl    cinfo			; store acc to cinfo
	out     cinfo, IOSR		; write to IOSR, take AIC out of reset


main:	
	ldp	#0	
	splk	#EN_RINT | EN_TXRXINT, IMR	; enable the XINT & RINT interrupts
						; also enable the TXRXINT (Async Serial Port)
						; interrupt (required by the monitor)
	splk	#0ffffh, IFR		; Reset IFR flags
	ldp	#outval			; Set data page

	splk	#0003h, outval
	out	outval, SDTR		; request secondary communications
	splk	#0502h, outval
	out	outval, SDTR		; configure register 5 for aux input

	splk	#0003h, outval
	out	outval, SDTR		; request secondary communications
	splk	#0124h, outval
	out	outval, SDTR		; register A = 18, sampling rate ~= 16k

	splk	#0003h, outval
	out	outval, SDTR		; request secondary communications
	splk	#0212h, outval
	out	outval, SDTR		; register B = 18, sampling rate ~= 16k

	lacl	#127
	lar	ar2, #rxbuf
	lar	ar4, #size
	mar	*, ar2

init_buf:
	sacl	*+, 0, ar4
	banz	init_buf, *-, ar2	

	mar	*, ar1			; ARP-> buffer ptr
	lar	ar1, #rxbuf		; buffer ptr -> top of buffer
	lar	ar3, #size2		; ar2=size of buffer
	splk	#0000h, SUM
	clrc	intm			; Enable interrupts


loop:	idle				; Idle while not recieving data
	b	loop


codtx:					; XINT interrupt service routine
	splk	#CLR_XINT, IFR		; Clear pending interrupt 
	clrc	intm                	; Enable unmasked interrupts
	ret

rxrev:					; RINT interrupt service routine
	ldp	#outval
	in	ARG1, SDTR          	; Read in current sample
	lacl	ARG1
	sacl	outval
	call	mucomp
	mar	*, ar1
	sar	ar1, buffpt		; buffptr=current buffer location
	lacl	SUM
	bcnd	low, eq

hi:
	lacl	ARG1
	rpt	#7
	sfl
	or	*
	sacl	*+, 0, ar7
	b	go

low:
	lacl	ARG1
	sacl	*, 0, ar7

go:
	lacc	buffpt			; Load accum with current buffer location
	sub	#delay			; Subtract the delay
	sacl	buffpt			; buffpt-> delayed entry
	sub	#rxbuf			; Subtract top of buffer to see if
	bcnd	OK1, geq		; buffpt lies beyond its limits
	add	#buffend		; if it does add the end address to it
	sacl	buffpt			; in order to circle back through the end

OK1:	
        lar	ar7, buffpt		; Load ar7 with delayed buffer pointer
	lacl	SUM
	bcnd	lo1, eq

hi1:
	lacl	*
	rpt	#7
	sfr
	and	#00ffh
	sacl	ARG1
	b	go1

lo1:
	lacl	*
	and	#00ffh
	sacl	ARG1

go1:
	call	muexp
	lacc	outval, 16	;15	; Load accum w/outval decimated to prevent overflow
        add	ARG1, 13		; Add decimated delay value to current value
	sach	outval			; Store sum in output value
	lacc	buffpt              	; Same comments for next four blocks of code
	sub	#delay
	sacl	buffpt
	sub	#rxbuf
	bcnd	OK2, geq
	add	#buffend   
	sacl	buffpt

OK2:
	lar	ar7, buffpt
	lacl	SUM
	bcnd	lo2, eq
hi2:	
	lacl	*
	rpt	#7
	sfr
	and	#00ffh
	sacl	ARG1
	b	go2
lo2:
	lacl	*
	and	#00ffh
	sacl	ARG1
go2:
	call	muexp
	lacc	outval, 16
        add	ARG1, 11
        sach	outval
 		
   	lacc	buffpt
	sub	#delay
	sacl	buffpt
	sub	#rxbuf
	bcnd	OK3, geq
	add	#buffend   
	sacl	buffpt

OK3:
        lar	ar7, buffpt
	lacl	SUM
	bcnd	lo3, eq
hi3:
	lacl	*
	rpt	#7
	sfr
	and	#00ffh
	sacl	ARG1
	b	go3

lo3:
	lacl	*
	and	#00ffh
	sacl	ARG1

go3:
	call	muexp
	lacc	outval, 16
        lar	ar7, buffpt
        add	ARG1, 9
        sach	outval
 		           
 	lacc	buffpt
	sub	#delay
	sacl	buffpt
	sub	#rxbuf
	bcnd	OK4, geq
	add	#buffend   
	sacl	buffpt
OK4:
        lar	ar7, buffpt
	lacl	SUM
	bcnd	lo4, eq
hi4:	
	splk	#0000h, SUM
	lacl	*, ar3
	rpt	#7
	sfr
	and	#00ffh
	sacl	ARG1
	b	go4
lo4:
	splk	#0001h, SUM
	lacl	*, ar3
	and	#00ffh
	sacl	ARG1
go4:
	call	muexp
	lacc	outval, 16
        add	ARG1, 7
        sach	outval

	lacc	outval			; Load accumulator with output value
	and	#0fffch			; 2 LSB's=0 to avoid ac02 secondary cmmd mode 
	sacl	outval
	out	outval, SDTR		; Write out through sync serial port to ac02

	banz	skip, *-, ar1        	; If at the end of the buffer
	lar	ar1, #rxbuf       	; circle back to the beginning
	lar	ar3, #size2       	; to store samples.  		
skip:	ldp	#0
	splk	#CLR_RINT, IFR		; Clear pending interrupt request 			
	ldp	#outval
	clrc	intm			; Enable maskable interrupts  
	ret				; Return


******************************************************************************
* Mu-law compression
* input: 16-bit linear sample in ARG1
* output: 8-bit mu-law coded sample in ARG1
******************************************************************************

mucomp:
	LDP	#ARG1
	LACL	#33		; One-time initialization
	SACL	BIAS
	LACC	ARG1, 14	; Load data into high accumulator
				; Right shift by two because mu-law only deals with
				; 14-bit data, and we have 16-bit data as input.
  
; Begin mu-law compress (ACC HI contains 14-bit sign-magnitude)
; EXP corresponds to S bits, MANT corresponds to Q bits
; Final number is in form (ACC HI)=(P S2 S1 S0 Q3 Q2 Q1 Q0)

	MAR	*, AR5
	BCND	NEGAT, LT
	ADD	BIAS, 16	; Add bias  
	LAR	AR5, #-9	; Initialize exponent to -9 because this
				; will yield correct results when later
				; taking ABS to get mu-law exponent.
	RPT	#8		; 7 is the maximum sized exponent that
				; can be held in S bits.  Execute 7+2=9
				; times because first two leftmost bits
				; are zero since it's a 14-bit input.
	NORM	*+		; Find exponent
	AND	#0F000h, 14	; Mask four bits following leftmost 1.
				; These will become Q (representing the mantissa).
	SACH	MANT		; Mantissa is in bits 2-5 of high accumulator.
	SAR	AR5, EXP	; Exponent (S bits) is currently negated.
	LACC	EXP, 16
	ABS			; Correct exponent by negating.
	ADD	MANT, 2		; Merge exponent with mantissa, 
				; shifting left by two bits to get it in bits 4-6.
	XOR     #0FF00h, 4	; Invert all bits (keeping sign positive).
	B	FINISH


NEGAT:
	ABS			; Make positive
	ADD     BIAS, 16	; Add bias
	LAR     AR5, #-9	; Initialize exponent to -9 because this
				; will yield correct results when later
				; taking ABS to get mu-law exponent.
	RPT	#8		; 7 is the maximum sized exponent that
				; can be held in S bits.  Execute 7+2=9
				; times because first two leftmost bits
				; are zero since it's a 14-bit input.                              
	NORM	*+		; Find exponent
	AND	#0F000h, 14	; Mask four bits following leftmost 1.
                                ; These will become Q (representing the mantissa).
        SACH    MANT            ; Mantissa is in bits 2-5 of high accumulator.
	SAR     AR5, EXP	; Exponent (S bits) is currently negated.
	LACC    EXP, 16
	ABS			; Correct exponent by negating.
	ADD     MANT, 2		; Merge exponent with mantissa, 
				; shifting left by two bits to get it in bits 4-6.
	XOR	#07F00h, 4	; Invert all 7 low bits and make polarity 
				; bit=0 (negative)


FINISH:				; Done mu-law compress (result in low byte of high accumulator)
	SACH	ARG1, 4		; Write over orignal C value
	RET


******************************************************************************
* Mu-law expander with decoding table
* input 8-bit mu-law encoded value in accumulator
******************************************************************************

muexp:
	LACL	ARG1       	; ACC = data
	ADD	#CODADD		; Add accumulator to table base address
	TBLR	ARG1		; Read table entry and store back in data
	RET			; End mu-law decode


* CODEC-TO-LINEAR CONVERSION TABLE

CODADD:
	.word	-32124
	.word	-31100
	.word	-30076
	.word	-29052
	.word	-28028
	.word	-27004
	.word	-25980
	.word	-24956
	.word	-23932
	.word	-22908
	.word	-21884
	.word	-20860
	.word	-19836
	.word	-18812
	.word	-17788
	.word	-16764
	.word	-15996
	.word	-15484
	.word	-14972
	.word	-14460
	.word	-13948
	.word	-13436
	.word	-12924
	.word	-12412
	.word	-11900
	.word	-11388
	.word	-10876
	.word	-10364
	.word	-9852
	.word	-9340
	.word	-8828
	.word	-8316
	.word	-7932
	.word	-7676
	.word	-7420
	.word	-7164
	.word	-6908
	.word	-6652
	.word	-6396
	.word	-6140
	.word	-5884
	.word	-5628
	.word	-5372
	.word	-5116
	.word	-4860
	.word	-4604
	.word	-4348
	.word	-4092
	.word	-3900
	.word	-3772
	.word	-3644
	.word	-3516
	.word	-3388
	.word	-3260
	.word	-3132
	.word	-3004
	.word	-2876
	.word	-2748
	.word	-2620
	.word	-2492
	.word	-2364
	.word	-2236
	.word	-2108
	.word	-1980
	.word	-1884
	.word	-1820
	.word	-1756
	.word	-1692
	.word	-1628
	.word	-1564
	.word	-1500
	.word	-1436
	.word	-1372
	.word	-1308
	.word	-1244
	.word	-1180
	.word	-1116
	.word	-1052
	.word	-988
	.word	-924
	.word	-876
	.word	-844
	.word	-812
	.word	-780
	.word	-748
	.word	-716
	.word	-684
	.word	-652
	.word	-620
	.word	-588
	.word	-556
	.word	-524
	.word	-492
	.word	-460
	.word	-428
	.word	-396
	.word	-372
	.word	-356
	.word	-340
	.word	-324
	.word	-308
	.word	-292
	.word	-276
	.word	-260
	.word	-244
	.word	-228
	.word	-212
	.word	-196
	.word	-180
	.word	-164
	.word	-148
	.word	-132
	.word	-120
	.word	-112
	.word	-104
	.word	-96
	.word	-88
	.word	-80
	.word	-72
	.word	-64
	.word	-56
	.word	-48
	.word	-40
	.word	-32
	.word	-24
	.word	-16
	.word	-8
	.word	0
	.word	32124
	.word	31100
	.word	30076
	.word	29052
	.word	28028
	.word	27004
	.word	25980
	.word	24956
	.word	23932
	.word	22908
	.word	21884
	.word	20860
	.word	19836
	.word	18812
	.word	17788
	.word	16764
	.word	15996
	.word	15484
	.word	14972
	.word	14460
	.word	13948
	.word	13436
	.word	12924
	.word	12412
	.word	11900
	.word	11388
	.word	10876
	.word	10364
	.word	9852
	.word	9340
	.word	8828
	.word	8316
	.word	7932
	.word	7676
	.word	7420
	.word	7164
	.word	6908
	.word	6652
	.word	6396
	.word	6140
	.word	5884
	.word	5628
	.word	5372
	.word	5116
	.word	4860
	.word	4604
	.word	4348
	.word	4092
	.word	3900
	.word	3772
	.word	3644
	.word	3516
	.word	3388
	.word	3260
	.word	3132
	.word	3004
	.word	2876
	.word	2748
	.word	2620
	.word	2492
	.word	2364
	.word	2236
	.word	2108
	.word	1980
	.word	1884
	.word	1820
	.word	1756
	.word	1692
	.word	1628
	.word	1564
	.word	1500
	.word	1436
	.word	1372
	.word	1308
	.word	1244
	.word	1180
	.word	1116
	.word	1052
	.word	988
	.word	924
	.word	876
	.word	844
	.word	812
	.word	780
	.word	748
	.word	716
	.word	684
	.word	652
	.word	620
	.word	588
	.word	556
	.word	524
	.word	492
	.word	460
	.word	428
	.word	396
	.word	372
	.word	356
	.word	340
	.word	324
	.word	308
	.word	292
	.word	276
	.word	260
	.word	244
	.word	228
	.word	212
	.word	196
	.word	180
	.word	164
	.word	148
	.word	132
	.word	120
	.word	112
	.word	104
	.word	96
	.word	88
	.word	80
	.word	72
	.word	64	
	.word	56
	.word	48
	.word	40
	.word	32
	.word	24
	.word	16
	.word	8
	.word	0
	.end
