********************************************************************************
** PERFORMS THE FOLLOWING:                                                    **
*				                                              **
*				                                              **
*      PROGRAM EACH WORD IN ARRAY (NOROWRED)                                  **
*                    |                                                        **
*                    |							      **
*      PROGRAM EACH WORD (32 TOTAL) IN REDUNDANCY ROWS                        **
*                    |                                                        **
*                    |                                                        **
*                   END                                                       **
*                                                                             **
*   NOTES: -PERFORMS PROGRAM VERIFY AFTER EACH                                ** 
*            PROGRAM PULSE IS APPLIED                                         **
*                                                                             **
*                                                                             **
******************************************************************************** 

	.include	..\include\var.h	;Variable References.


	
	.SECT	"UTILS"
********************************************************************************
*  FILENAME:   PRCLR.asm                                                       *
*  FILETYPE:   TMS320C2Xlp Assembly Language (Texas Instruments)               *
*                                                                              *
*  Date: 10/99                                                                 *
********************************************************************************
	.title "F10 'LF240x FLASH MEMORY PRECONDITION ROUTINE"
********************************************************************************
* PUBLIC DECLERATIONS                                                          *
********************************************************************************
*********LABELS********
	.DEF READWORD,CLRCMD,PROG
	.DEF CLR,ERROR1,CLEAR,PPW,NEXTWORD,COMPARE,PGCNT
*********DELAYS********
*
********************************************************************************
*  FLASH PRECONDITION ERASE ROUTINE (ARRAY - Program Space)                    *
********************************************************************************
*
	.TEXT
********************************************************************************
** THE FOLLOWING VARIABLES CAN BE CHANGED IF THERE IS A SPEC CHANGE.          **
** THE FL_SEGST,FL_SEGEND,ARRAY AND SECTOR VARIABLES DETERMINE WHICH          **
** ARRAY AND SECTOR IS BEING WORKED ON.                                       **
**						                              **
********************************************************************************
********************************************************************************
; Define macros to set the Flash Mode.
; ACCESS_REGS gives access to the Flash Registers in the Pgm Mem Space
; and ACCESS_ARRAY  gives access to the Flash ARRAY in Pgm Mem Space.
;
********************************************************************************
ACCESS_REGS	.macro	
		OUT	07fh,0ff0fh		
		.endm

ACCESS_ARRAY	.macro	
		IN	07fh,0ff0fh
		.endm

********************************************************************************
; Define Short DELAY loop macro. 
;  This will be used to generate a short delay upto 256 cycles.
********************************************************************************
SDELAY  .macro  COUNT
        RPT     COUNT
        NOP
	.endm
********************************************************************************
** THE FOLLOWING PROGRAM WILL PRECONDITION A SECTOR                           **
**  - CALLED BY CLRx.ASM, WHICH DETERMINES WHICH ARRAY AND SECTOR             **
**    WILL BE PROGRAMMED                                                      **
********************************************************************************

CLEAR	LDP	#0		;DP => 0

********************************************************************************
** SUBROUTINE: ENABL							      **
**	- PLACE FLASH IN REGISTER MODE                                        **
**	- ENABLES SECTOR 						      **
**	- WRITES A ONE TO THE APPROPRIATE "ENABLE" REG			      **
**									      **
********************************************************************************
ENABL	ACCESS_REGS

	LACC	#SECT		;ENABLE SECTOR
	BLDD	#SECTOR,PAD
	TBLW	PAD	

	LACC	#ENAB		;ENABLE CORE  
	SPLK	#0001h,PAD	
	TBLW	PAD

********************************************************************************
** MAINBODY:								      **
**	- DATA -> 0000 FOR USE IN COMPARE				      **
**	- INITIALIZES AR4 (OPTIONAL PULSE COUNT)			      **
**	- CALLS CLR WITH ROW REDUNDANCY DISABLED			      **
**		- PREVENTS BITS THAT ARE MAPPED OUT BY RED FROM GOING         **
**		  INTO DEPLETION DURING ERASE				      ** 
**	- CALLS CLR WITH PRECONDITIONING				      **
**		- PREVENTS BITS IN UNUSED REDROW FROM GOING INTO              **
**		  DEPLETION DUREING ERASE				      **
********************************************************************************
	SPLK	#0000h,DATA	;LOAD 0000 FOR COMPARE
	LAR	AR4,#0h		;INITIALIZE PULSE COUNT (OPTIONAL)

	SPLK	#0080h,FL_CMD	;NOROWRED  	
	CALL	CLR		;CLEAR MAIN ARRAY (NOROWRED)

	SPLK	#0100h,FL_CMD	;SETUP ENABLE REDUNDANCY,ENABLE PRECOND
	CALL	CLR		;CLEAR REDUNDANCY ROWS

	CALL 	END1

	RET


********************************************************************************
** SUBROUTINE: CLR							      **
**	- READS FLASH ONE WORD AT A TIME IN PROGVER MODE		      **
**		- BRANCHES TO NEXTWORD IF FLASH WORD IS PROGRAMMED	      **
**		- ENTERS BITMASK IF WORD NEEDS TO BE PROGRAMMED               **
**									      **
********************************************************************************
CLR
	SPLK	#MX_PCNT,PLS_CNT ;INITIALIZE PROGRAM_COUNT 
	BLDD	#FL_SECST,ADDR	 ;ADDR -> START OF SECTOR

PGVERON	LACC	#WADDR		;LOAD ADDRESS TO BE PROG
	CALL	SETWADDR
*				
	LACC	FL_CMD			
	XOR	#0004h		;PROGVER CMND
	SACL	PAD
*
	LACC	#CTRL		;INIT PROGVER MODE 
	TBLW	PAD
	SDELAY	#T_pvsu		;Wait for T_pvsu(P)
*
	LACC	#PMPC		;PROGVER EXECUTE
	SPLK	#0005h,PAD	
	TBLW	PAD

	SDELAY	#T_pva_e	;Wait T_pva(E) 

	CALL 	READWORD
	
PGVEROFF
	SPLK	#0000h,PAD1	;CLEAR PMPC
	CALL	CLRCMD

COMPARE
	LACC	READ		;ACC=>VALUE READ DURING VERIFY
	OR	#0000h		;OR WITH 0000
	BCND	NEXTWORD,EQ	;IF = 0 THEN PROGRAMMING DONE	
	

********************************************************************************
** SUBROUTINE: BITMASK	  	             		                      **
**								              **
**   THIS SECTION ENSURES A MAX OF 8 BITS ARE PROGRAMMED AT A TIME.           **
**      - READ CONTAINS VALUE READ FROM THE FLASH (IN PROGVER MODE)           **
**      - CALLS PROG ONCE MASK IS BUILT			                      **
********************************************************************************

	LACC	READ		;acc => value read
	XOR	#0ffffh		;acc => lower bits to be prog
	SACL	DATA,0		;store acc in DATA
	CALL	PROG		;branch to prog 

********************************************************************************
** SUBROUTINE: PGCNT                                                          **
**	- ENTERED FROM HIBYTE			                              **
**      - CHECKS THAT THE MAX PROGRAM PULSE COUNT HAS                         **
**         NOT BEEN EXCEEDED                                                  **
**      - DECREMENTS PROGRAM COUNT                                            **
**	- INCREMENTS PULSE PER WORD COUNT AR4 	                              **
**	     (CODE OPTIONAL)	                                              **
**                                                                            **
********************************************************************************
PGCNT	MAR	*,AR4		;PULSE/WORD COUNT
	MAR	*+,AR4

	LACC	PLS_CNT		;ACC=># OF PULSE 
	SUB	#1		;DECREMENT PROGRAM COUNT
	SACL	PLS_CNT		;PLS_CNT=># OF PULSES REMAINING
	BCND	ERROR,EQ	;IF ACC=0 THEN ERROR	
	B	PGVERON		;verify word programmed

********************************************************************************
** SUBROUTINE: PROG                                                           **
** 	  - CALLED BY LOBYTE OR HIBYTE                                        **
**	  - APPLIES PROGRAM PULSE TO (REQUIRED) BITS                          **
**	  - "DATA" CONTAINS BITS TO BE PROG                                   **
**	  - WILL PROGRAM BITS IN MAIN ARRAY OR REDUNDANT ROWS                 **
**		DEPENDING ON THE STATUS OF "FL_CMD"                           **
**			- FL_CMD = 0080h (NOROWRED)                           **
**			- FL_CMD = 0100h THEN PROGRAMS ROWREDs                **
********************************************************************************
PROG	LACC	#WDATA		;Load data to be prog
	TBLW	DATA		
*
	LACC	FL_CMD
	XOR	#0003h		;PROG CMND
	SACL	PAD
*
	LACC	#CTRL		;Init prog mode 
	TBLW	PAD
	SDELAY	#T_psu_p	;Wait T_psu(P)
*
	LACC	#PMPC		;Turn on prog voltages
	SPLK	#0005h,PAD	
	TBLW	PAD
*
PPW	SDELAY	#T_prog_e1	;PROG PULSE WIDTH PART 1
	SDELAY	#T_prog_e2	;PROG PULSE WIDTH PART 2

				;T_prog(E)=10,000 nsec

*
	SPLK	#0000h,PAD	;TURN OFF PROG VOLTAGES
	TBLW	PAD
*
	SDELAY	#Tph_P		;Wait T_ph(P) 	(HOLD TIME).
*
	SPLK	#0001h,PAD1	;CLEAR PMPC AND CNTL
	CALL	CLRCMD
	RET

********************************************************************************
** SUBROUTINE: NEXTWORD                                                       **
**       -CHECKS IF ADDR IS AT LAST ADDR IN SECTOR                            **
**       -INCREMENTS ADDRESS                                                  **
**       -REINITIALIZES PROGRAM PULSE COUNT, FOR                              **
**          PROGRAMMING OF NEXT WORD                                          **
********************************************************************************
NEXTWORD		
	LACC	ADDR		;ACC=>ADDR OF CURRENT WORD
	SUB	FL_SECEND	;IF CURRENT WORD END OF SEC, DONE
	BCND	NW,NEQ		;WITH SECTOR

	RET			;ELSE NEXT WORD
	
NW	ADD	FL_SECEND	;CURRENT WORD
	ADD	#1		;INCREMENT ADDR
	SACL	ADDR		;STORE ADDR OF NEXT WORD

	SPLK	#MX_PCNT,PLS_CNT ;Initialize PROGRAM PULSE COUNT 
	B	PGVERON		;begin prog of next word

ERROR	CALL	END1


ERROR1	B	err1		;failed due to exceeding max prgm pulses
*

********************************************************************************
** SUBROUTINE: READWORD                                                       **
**      - READS WORD AT LOCATION "ADDR"                                       **
**	- STORES WORD AT "READ"                                               **
**	- RETURNS TO CALLING ROUTINE IN REGISTER MODE                         **
**                                                                            **
********************************************************************************
READWORD
	ACCESS_ARRAY

	LACC	ADDR		;Read word flash 
	TBLR	READ		;store word in READ (data space)

	ACCESS_REGS

	RET

********************************************************************************		
** SUBROUTINE: END1			                                      **					 
**	- CLEARS CONTROL REGISTERS (PMPC,CNTL,WADDR,WDATA                     **
**		,ENABLE AND SECTOR)				              **
**	- PUTS FLASH IN ARRAY MODE				              **
**	- RETURNS TO CALLING SEQUENCE (USUALLY CLRx.ASM)	              **
**		- CLRx.ASM IF CLEAR WAS SUCCESSFUL		              **
**		- ERROR IF FAILED				              **
********************************************************************************
END1	SPLK	#0006h,PAD1	;CLEAR ALL SIX 
	CALL	CLRCMD
	ACCESS_ARRAY
	RET

********************************************************************************
** SUBROUTINE: CLRCMD                                                         **
**      - PLACES FLASH IN NORMAL READ MODE BY:                                **
**	- WRITING 0000 TO THE FIRST TWO LOCATIONS OF                          **
**	    THE FLASH CONTROL REGISTER (0X00040)                              **                                        
**	    (PMPC,CNTL=>0000)                                                 **
**	- RETURNS TO CALLING ROUTINE IN REGISTER MODE                         **
********************************************************************************
CLRCMD	ACCESS_REGS
	SPLK 	#0,PAD
	LACC 	FL_SECST
 	RPT 	PAD1
 	TBLW 	PAD
 	RET

	.loop	11
	nop
	.endloop


	.def	SETWADDR
SETWADDR	
	TBLW	ADDR		
	RET
	





	
