*************************************************************
** PERFORMS THE FOLLOWING:                                 **
*				                           **
* 		                                           **
*      --------ERASE VERIFY  -- (pass) -----               **
*      |	      |                     |              **
*      |              | (fail)              |              **
*      |              |                     |              **
*      |        ERASE SECTOR                |              **
*      |              |                     |              **
*      |              |                     |              **
*      ---------------                      |              **
*                                           |              **
*                                           |              **
*        ---(pass)--CMPTVER------------------              **
*        |             |         |                         **
*        |             |(fail)   |                         **
*        |             |         |                         **
*        |            CMPT--------                         **
*        |                                                 **
*        |                                                 **
*        ------------ERASE VERIFY                          **
*                                                          **
*                                                          **
*   NOTES: - OFFICIAL ERASE ALGO                           ** 
*          - CONTAINS DIAGNOSTIC CODE WHICH CAN            **
*            BE REMOVED TO SAVE SPACE                      **
**                                                         **


	.INCLUDE	..\include\VAR.h		;CALLS VARIABLES USED TO ERASE


	.option X,F
************************************************************************************
* PUBLIC DECLERATIONS                                                              *
************************************************************************************
	.DEF ERVER,READWORD,PASSERVER,EPW,PERASE,COMPARE
	.DEF ERASE,ERROR,CMPCTVER,CMPCT,CLRCMD,CPW,DONE
	.DEF WR_WADDR1,WR_WADDR2
*---------------------------------------------------------* 
*  FLASH ERASE ROUTINE (ARRAY x, SECTOR x, Program Space) *
*---------------------------------------------------------*
*
IMR	.SET	4
ABRPT	.SET	01Fh
T_MODE  .SET    0A1h

	.TEXT


ACCESS_REGS	.macro	
;		SPLK	#ARRAY,REG_ACC
		OUT	07fh,0ff0fh		
		.endm

ACCESS_ARRAY	.macro	
;		SPLK	#0,REG_ACC
		IN	07fh,0ff0fh
		.endm


; -----------------------------------------------------------------------------
; Define Short DELAY loop macro. 
;  This will be used to generate a short delay less than (255 * 50ns) 12.75 us 
; -----------------------------------------------------------------------------

SDELAY  .macro  COUNT
        RPT     COUNT
        NOP
		.endm


**************************************************************
** THE FOLLOWING PROGRAM WILL ERASE FLASH ARRAY x SECTOR x  **
**  USING THE EXTERNAL RAM                                  **                   
**  - THE PRECONDITIONING PROGRAM SHOULD BE EXECUTED PRIOR  **
**    TO RUNNING THIS PROGRAM				    **
**  					                    **
**							    **
**************************************************************
ERASE
******SETUP******

	SPLK	#MX_ECNT,PLS_CNT ;INITIALIZE ERASE PULSE COUNT
	SPLK	#0FFFFh,DATA	;LOAD FFFF FOR ERASE	
	BLDD	#FL_SECST,ADDR	;INITIALIZE START OF SECTOR
	SPLK	#0000,LASTVER	;INITIALIZE LASTVERIFY FLAG 
*	LAR	AR2,#0000h	;INITIALIZE ERASE PULSE COUNTER (OPTIONAL)


**********
ENBL	ACCESS_REGS

	LACC	#SECT		;ENABLE SECTOR
	BLDD	#SECTOR,PAD
	TBLW	PAD	

	LACC	#ENAB		;ENABLE CORE  
	SPLK	#0001h,PAD	
	TBLW	PAD

	B	ERVER		;VERIFY SECTOR ERASED
*********************************************************************
** SUBROUTINE: PERASE						   **
**	- ERASES SECTOR 0 OR 1 (BASED ON "FL_SECST")	 	   **
**	- PROGRAM SPACE						   **							
**								   **
*********************************************************************					

PERASE	LACC	PLS_CNT		;IS MAX # OF ERASE PULSES EXCEEDED?
	BCND	ERROR1,EQ	;IF YES THEN ERROR
	
	LACC	#WADDR		;WADDR = FIRST ADDRESS OF SECTOR
				; UNLOCKS SECTOR FOR ERASE OPERATION	
	NOP
	NOP
WR_WADDR1:
	TBLW	FL_SECST

	LACC	#WDATA		;LOAD WDATA REG WITH FFFF
	TBLW	DATA

	LACC	#CTRL		;ERASE MODE
	SPLK	#0001,PAD
	TBLW	PAD

	SDELAY	#T_esu_er	;T_esu(ER) Delay.

	LACC	#PMPC		;EXECUTE  
	SPLK	#0005h,PAD	
	TBLW	PAD	

*	SETC	XF		 ;USED TO MEASURE ERASE PULSE WIDTH W/ O-SCOPE
EPW	LAR	AR7,#ERASE_PULSE ;ERASE PULSE WIDTH
	CALL 	DELAY,AR7	 ;T_erase(E)

	SPLK	#0000h,PAD1	;CLEAR PMPC
	CALL	CLRCMD

*	CLRC	XF		;(OPTIONAL)

	SDELAY	#T_eh_er	;T_eh(ER)

	LACC	PLS_CNT		;DECREMENT PULSE COUNT
	SUB	#1h
	SACL	PLS_CNT
*****************************************************************
** THIS CODE IS OPTIONAL, STORES # OF ERASE PULSES IN AR2      **
*	FOR CHARACTERIZATION				       **
*                                                              **
*	MAR	*,AR2		;ARP=>AR2                      **
*	ADRK	#1		;INCREMENT ERASE PULSE COUNTER **
*							       **
**                                                             **
*****************************************************************
*****************************************************************
** SUBROUTINE: ERVER					       **
**	- READS FLASH WORDS IN ERVER MODE  		       **
**	- BRANCH TO ERASE IF NOT FFFF			       **
**	- BRANCH TO PASSERVER IF ALL WORDS IN SECTOR ARE FFFFh **
**							       **
**							       **
*****************************************************************
ERVER	BLDD	#FL_SECST,ADDR	;FIRST SECTOR LOCATION
	
B0	LACC	#CTRL		;ERASE VERIFY MODE
	SPLK	#0002,PAD
	TBLW	PAD

	SDELAY	#T_eva_e	;T_eva(E)

	CALL	READWORD	

COMPARE
	LACL	READ		;IS WORD READ = FFFF
	XOR	#0FFFFh		;NO = > ERASE
	BCND	PERASE,NEQ	
	
	LACC	ADDR
	SUB	FL_SECEND
	BCND	PASSERVER,EQ

	ADD	FL_SECEND
	ADD	#1
	SACL	ADDR

	B	B0		;NEXT WORD

******************************************************************
** SUBROUTINE: PASSERVER					**
**	- ENTERED FROM ERVER IF ERVER PASSED			**
**	- CHECKS IF COMPACTION VERIFY HAS PASSED		**
**		- YES => SECTOR IS ERASED (FINISHED)		**
**		- NO  => BRANCH TO COMPACTION VERIFY		**
**							   	**
******************************************************************
PASSERVER
	LACC	LASTVER		;CHECK IF CMPCTVER HAS BEEN PASSED
	BCND	DONE,NEQ	;IF YES => FINISHED (SECTOR ERASED)
	B	CMPCTVER	;ELSE => COMPACTION VERIFY	

ERROR1
	SPLK	#6,PAD1		;CLEAR ALL
	CALL	CLRCMD		;
ERROR	B 	err1
***************************************************************
** SUBROUTINE: READWORD                                      **
**      - READS WORD AT LOCATION "ADDR"                      ** 
**	- STORES WORD AT "READ"                              **
**	- RETURNS TO CALLING ROUTINE IN REGISTER MODE        **
**                                                           **
***************************************************************
READWORD
	ACCESS_ARRAY
	LACL	ADDR		;Read word flash 
	TBLR	READ		;-store word in READ (data space)
	ACCESS_REGS
	RET

*************************************************************************
** SUBROUTINE:CMPCTVER						       **
**   CODE READS FROM EACH COLUMN IN CMPCT VERIFY MODE TO DETERMINE IF  **
**   ANY BITS ARE IN DEPLETION.                                        **
**     	- WILL CALL COMPACTION IF NECESSARY                            **
**	    - ADDR: HOLDS THE ADDRESS OF COLUMN REQUIRING CMPCT        **
**	            (AND COLUMN BEING CHECKED)                         **
**          - READ: HOLDS DATA FOR CMPCT                               **
*************************************************************************
CMPCTVER
	BLDD	#FL_SECST,ADDR	 ;INITIALIZE START OF SECTOR
	SPLK	#0deadh,LASTVER  ;SET LASTVERIFY FLAG	
	
G1	
	SPLK	#MX_CMPCT,PLS_CNT ;INITIALIZE CMPCT PULSE COUNT	

CMPCTVER1
	NOP
	LACC	#WADDR		;LOAD ADDR TO BE VERIFIED
WR_WADDR2:
	TBLW	ADDR

	LACC	#CTRL		;COMPACT VERIFY MODE
	SPLK	#0006,PAD
	TBLW	PAD

	SDELAY	#T_cva_cm	;Delay set to ~50ns (25ns MIN) 	
				;T_cva(CM)

	CALL	READWORD		
	
	LACL	READ		;ACC => VALUE READ
	BCND	CMPCT,NEQ	;IF != 0000 THEN CMPCT **DEPLETED BITS**
	
	LACC	ADDR		   ;CURRENT ADDR
	ADD	#1		   ;INCREMENT ADDR
	SACL	ADDR		   ;STORE NEXT ADDR
	SPLK	#MX_CMPCT,PLS_CNT  ;INITIALIZE CMPCT PULSE COUNT	

	SUB	#STICKS   	   ;STICK COUNT
	SUB	FL_SECST
	BCND	CMPCTVER1,NEQ	   ;CURRENT ADDR - FL_SECST IS # OF STICKS CHECKED 
                                   ; SO CURRENT ADDR-(FL_SECST+STICKS) = 0 ON LAST STICK
	B	ERVER
*************************************************************************
** CODE COMPACTS THE COLUMN ADDRESSED BY ADDR                          **
**    - ADDR: HOLDS THE ADDRESS OF COLUMN REQUIRING CMPCT              **
**    - READ: HOLDS DATA USED TO DETERMINE BIT LINE TO BE CMPCTED      **
**    - CALLED BY CMPCTVER         				       **
**    - RETURNS TO CMPCTVER                                            **
*************************************************************************

CMPCT	
;	B	DONE		;REMOVE COMPACTION	

;	MAR 	*,AR3
;	MAR	*+,AR1		;INCREMENT DIAGNOSTIC CMPCT PULSE COUNT (OPTIONAL)

	LACC	PLS_CNT		;LOAD # OF ALLOWED PULSES LEFT
	BCND	ERROR1,EQ	;IF PULSE CNT = 0 => ERROR
		
;	LACC	#WADDR		;COLUMN ADDRESS => WADDR REG  
;	TBLW	ADDR
	
	LACL	READ		;DATA READ DURING CMPCTVER
	XOR	#0FFFFh		;BITWISE INVERSION
	SACL	READ		;STORE INVERTED DATA

	LACC	#WDATA		;INVERTED DATA => WDATA
	TBLW	READ		

	LACC	#CTRL		;COMPACTION MODE
	SPLK	#0005,PAD
	TBLW	PAD

	SDELAY	#T_csu_cm	;Wait T_csu(CM)

	LACC	#PMPC		;EXECUTE
	SPLK	#0005h,PAD
	TBLW	PAD

;	SETC	XF		 ;USED TO MEASURE CMPCT PULSE WIDTH W/ O-SCOPE
CPW	LAR	AR7,#CMPCT_PULSE ;CMPCT PULSE WIDTH	T_cmpct(E)
	CALL 	DELAY,AR7		
;	CLRC	XF		 ;OPTIONAL

	SPLK	#0000h,PAD1	 ;CLEAR PMPC
	CALL	CLRCMD

	SPLK	#0001h,PAD1	 ;CLEAR CNTL
	CALL	CLRCMD

	SDELAY	#T_ch_cm		; Wait T_ch(CM)

	LACC	PLS_CNT		;DECREMENT PULSE COUNT
	SUB	#1h
	SACL	PLS_CNT

	B  	CMPCTVER1	;RESUME CMPCTVER

DONE	SPLK	#6,PAD1		;CLEAR ALL
	CALL	CLRCMD		;
	ACCESS_ARRAY
	RET			;PASSED CMPCTVER AND ERVER	




*****************************************************************
** SUBROUTINE: CLRCMD                                          **
**      - PLACES FLASH IN NORMAL READ MODE BY:                 **
**	- WRITING 0000 TO THE FIRST TWO LOCATIONS OF           **
**	    THE FLASH CONTROL REGISTER (0X00040)               **                                        
**	    (PMPC,CNTL=>0000)                                  **
**	- RETURNS TO CALLING ROUTINE IN REGISTER MODE          **
*****************************************************************
CLRCMD	ACCESS_REGS
	
	SPLK 	#0,PAD
	LACC 	FL_SECST
 	RPT 	PAD1
 	TBLW 	PAD

	RET





	 

			
;------------------------------------------------------------------------------
;  SUBROUTINE: Delay
;
; DESCRIPTION:
;  This routine executes a delay approximately
;    (DLOOP + 8) + AR7 * (DLOOP + 6) * 1/freq = nsec
;    if AR7  = 0  Delay = 108 cycles
;    if AR7 != 0  Delay = 108 + AR6 * 106 cycles
;
;  A typical call to this subroutine is as follow:
;
;     lar     ar7,delay_param         1 cycles reg/#k, 2 cycles if #lk
;     call    Delay,*,ar7             4 cycles
;
;       minimum delay is when delay_parm=0
;       minimum delay = 113 cycles ( 108 + 5 )
;       for a cycle time of 50 nsec,
;         minimum delay = 5.65 usec   ( 113 cycles * 50 nsec)
;         delay time    = 5.65 usec + AR7 * 106 * 50 nsec
;                       = 5.65 usec + AR7 * 5.3 usec
;
; INPUTS:
;   AR7 = Passed on to this routine to set delay time as required
;   ARP => AR7    
; OUTPUTS:
;       none
;------------------------------------------------------------------------------
DELAY
        RPT     #DLOOP                  ;1 cycles
        NOP                             ;1+DLOOP = 101 CYCLES (FOR DLOOP = 100)
        BANZ    DELAY,*-,ar7            ;   4/2 (True/False)
        RET                             ;   4 cycles
                                        ; for delay_parm = 0
                                        ;   (1+101+2+4 = 108) cycles
                                        ; for delay_parm != 0
                                        ;   108 + AR7 * (1+101+4 = 106) cycles

