;-----------------------------------------------------------------------------
;Variable defines
;-----------------------------------------------------------------------------
		.def	GPR0		;General purpose registers.
		.def	GPR1
		.def	GPR2
		.def	GPR3
		.def	data_buf
		.def	length
		.def	dest_addr
		.def	B2_0
		.def	B2_1
		.def	B2_2
		.def	B2_3
		.def	B2_4
		.def	B2_5
		.def	B2_6
		.def	SPAD1
		.def	SPAD2

		.def	DUMMY
		.def	DLY10
		.def	DLY100
		.def	DLY3K3
		.def	SEG_ST
		.def	SEG_END
		.def	PROTECT

		.def	FL_ADRS
		.def	FL_DATA
		.def	ERROR_FLAG

;Variables for ERASE and CLEAR
		.def	RPG_CNT
		.def	FL_ST
		.def	FL_END

;Variables for PROGRAM
		.def	PRG_paddr
		.def	PRG_length
		.def	PRG_bufaddr
		.def	BYTE_MASK

		.def	VBR_CNTR
		.def	CHAR_RETRY_CNTR
		.def	ABSOLUTE_CHAR_CNT


;-----------------------------------------------------------------------------
; Variable Declarations for on chip RAM Blocks
;-----------------------------------------------------------------------------
		.bss	GPR0,1		;General purpose registers.
		.bss	GPR1,1
		.bss	GPR2,1
		.bss	GPR3,1
		.bss	stk0,1
		.bss	stk1,1
		.bss	data_buf,1
		.bss	length,1
		.bss	dest_addr,1
		.bss	PRG_paddr,1
		.bss	PRG_length,1
		.bss	PRG_bufaddr,1
		.bss	BYTE_MASK,1

		.bss	B2_0,1
		.bss	B2_1,1
		.bss	B2_2,1
		.bss	B2_3,1
		.bss	B2_4,1
		.bss	B2_5,1
		.bss	B2_6,1
		.bss	SPAD1,1
		.bss	SPAD2,1

		.bss	DUMMY,1
		.bss	DLY10,1
		.bss	DLY100,1
		.bss	DLY3K3,1
		.bss	SEG_ST,1
		.bss	SEG_END,1
		.bss	PROTECT,1

		.bss	FL_ADRS,1	;Flash load address.
		.bss	FL_DATA,1	;Flash load data.
		.bss	ERROR_FLAG,1 	;Error flag register.

;Variables for ERASE and CLEAR
		.bss	RPG_CNT,1	;Program pulse count.
		.bss	FL_ST,1 	;Flash start addr/Seg Cntrl Reg.
		.bss	FL_END,1	;Flash end address.

;Misc variables
		.bss	VBR_CNTR,1
		.bss	CHAR_RETRY_CNTR,1
		.bss	ABSOLUTE_CHAR_CNT,1


