	   .length	   60
	   .width	  132

	   .global sysinit,aicreset,com_parm,hcontrol
	   .global hread16,hwrite16,hread32,hwrite32
	   .global wait_transmit_0, dmadone, wordflag

************************************************************************
*      TMS320C30 EVM Monitor/Communications Code		       *
*								       *
*      Texas Instruments Incorporated				       *
*								       *
*      Tools Used:	  TMS320C330 Assy/Lnkr Version 2.10	       *
*      Assembly File:	  evminit.asm				       *
*      Link Command File: evminit.cmd				       *
*      Commands Used:	  asm30 -s evminit.asm			       *
*			  lnk30 evminit evminit.cmd		       *
*								       *
*      Bug Fixes:	10/03/90 TC				       *
*								       *
*      1. Interrupt routines were incorrectly pushing/popping the ST   *
*	  register.  Fix is to push ST first and pop it last.	       *
*								       *
*      2. A fast host would start sending commands to the EVM before   *
*	  it had completed its reset initializaton.  Fix is to signal  *
*	  the host on reset intialization complete.  This also requires*
*	  a fix in evmhost.c to poll for this signal.		       *
************************************************************************

STACK_SIZE .set  400h		 ;size of system stack

stack	   .usect  ".stack",STACK_SIZE

	   .sect   "vectors"
PARMS:
reset	   .word   sysinit
int0	   .word   hcontrol
int1	   .word   hwrite16
int2	   .word   hread16
int3	   .word   null_int
xint0	   .word   transmit0
rint0	   .word   receive0
xint1	   .word   transmit1
rint1	   .word   recieve1
tint0	   .word   null_int
tint1	   .word   timer1
dint0	   .word   dmadone

*****************************************************************
*hosport is placed in the vectors section so that the loader	*
*can modify this value at load time or the user can modify it	*
*at run time.  The value is used to set the address of the host *
*communications port.						*
*****************************************************************

hostport   .word   000804000h
reserved   .space  033h

	   .sect   "comdata"

*****************************************************************
* Varibles used to hold addresses of stack, interrupt routines	*
* that are mapped in/out, and parameters			*
*****************************************************************

stack_addr .word   stack	       ;address of stack
int1_hwr16 .word   hwrite16	       ;Address of 16 bit host write function
int1_hwr32 .word   hwrite32	       ;Address of 32 bit host write function
int1_cwr   .word   cmd_write	       ;Address of command write function
int2_hrd16 .word   hread16	       ;Address of 16 bit host read function
int2_hrd32 .word   hread32	       ;Address of 32 bit host read function
cmd_temp   .word   com_cmd	       ;Temporary address of command parameters
com_parm   .word   com_stat	       ;Address of command parameters
wordflag   .word   0

*****************************************************************
* Addresses of various peripherals and memory control registers *
*****************************************************************

dma_ctl    .word   000808000h	       ;dma global control register
mcntlr0    .word   000808064h	       ;i/o interface control reg. addr.
mcntlr1    .word   000808060h	       ;parallel interf. cntl. reg. addr.
t0_ctladdr .word   000808020h	       ;Timer 0
t1_ctladdr .word   000808030h	       ;Timer 1
p0_addr    .word   000808040h	       ;Serial port 0

*****************************************************************
* Control parameters to large to fit in immediate value 	*
*****************************************************************

enbl_eint1 .word   000020400h	       ;int1 enterrupt dma (host writes)
enbl_eint2 .word   000040400h	       ;int2 interrupt dma (host writes)
enbl_sp0_r .word   000000020h	       ;serial port 0 receive interrupt
intoff	   .word   0fff0fbf1h	       ;turn off int1,int2,int3,eint0,eint1
				       ;eint2, eint3, dma
intclr	   .word   0fffffff9h	       ;clr out int0-2
t0_ctlinit .word   0C00002C1h	       ;set timer as clk out, H1/2 period
				       ;timer will run when cpu stops in
				       ;emulation mode

p0_global  .word   00e970300h	       ;serial port 0 global control register

dma_wctl   .word   0C0000943h	       ;dma write control
				       ;com. reg. -> C30 mem.
				       ;interrupt driven from host writes
dma_rctl   .word   0C0000A13h	       ;dma read control
				       ;c30 mem -> com reg
				       ;interrupt driven from host reads

*****************************************************************
* Host communications command structure 			*
*****************************************************************

com_stat   .word   0000000000h	       ;command status
com_cmd    .word   0000000000h	       ;command
com_countl .word   0000000000h	       ;transfer count low
com_counth .word   0000000000h	       ;transfer count high
com_saddrl .word   0000000000h	       ;source addr low
com_saddrh .word   0000000000h	       ;source addr high
com_daddrl .word   0000000000h	       ;destination address low
com_daddrh .word   0000000000h	       ;destination address high


*****************************************************************
* Various constants						*
*****************************************************************
WAIT0		   .set    0000h       ;memory control reg val, parallel bus
WAIT1		   .set    0000h       ;memory control reg val, i/o bus
CACHE		   .set    1800h       ;clear and enable cache
ENBL_GIE	   .set    2000h       ;global interrupt enable
ENBL_INT0	   .set    0001h       ;interrupt 0 enable
ENBL_INT1	   .set    0002h       ;interrupt 1 enable
ENBL_INT2	   .set    0004h       ;interrupt 2 enable
ENBL_INT3	   .set    0008h       ;interrupt 3 enable
ENBL_XINT0	   .set    0010h       ;serial port 0 transmit int. enable
ENBL_RINT0	   .set    0020h       ;serial port 0 receive  int. enable
ENBL_XINT1	   .set    0040h       ;serial port 1 transmit int. enable
ENBL_RINT1	   .set    0080h       ;serial port 1 receive int. enable
ENBL_TINT0	   .set    0100h       ;timer 0 interrupt enable
ENBL_TINT1	   .set    0200h       ;timer 1 interrupt enable
ENBL_DINT	   .set    0400h       ;dma interrupt enable (cpu)

BEGIN_CMD_SEND	   .set    1	       ;Begin sending cmd parameters
END_CMD_SEND	   .set    2	       ;End sending cmd parameters
INIT_DONE	   .set    5	       ;Reset intialization complete

CMD_OK		   .set    0	       ;Received cmd parameters ok
CMD_ERROR	   .set   -1	       ;Error on receiving command parameters

CMD_FINISH	   .set    0	       ;Status, command is finished
CMD_LOAD	   .set    1	       ;Status, command is being loaded
CMD_ACTIVE	   .set    2	       ;Status, command is currently active

CMD_NOP 	   .set   10	       ;Nop command
CMD_HOST_MR16	   .set   11	       ;C30 memory read, 16 bit mode
CMD_HOST_MW16	   .set   12	       ;C30 memory write, 16 bit mode
CMD_HOST_MR32	   .set   13	       ;C30 memory read, 32 bit mode
CMD_HOST_MW32	   .set   14	       ;C30 memory write, 32 bit mode
CMD_HOST_DMAR	   .set   15	       ;C30 memory read via dma, 16 bit mode
CMD_HOST_DMAW	   .set   16	       ;C30 memory write via dma,16 bit mode


************************************************************************
*      sysinit							       *
*								       *
*      Intializes the TMS320C30 EVM				       *
*								       *
*      Operations:  Disable/clear interrupts			       *
*		    Set the data page and stack pointers	       *
*		    Enable the cache				       *
*		    Intialize the memory ports			       *
*		    Intialize the AIC				       *
*		    Enable INT0 and GIE to handle command interrupts   *
*		    Wait in IDLE loop for interrupts		       *
*								       *
*      Note.  When debugging you may want to change the IDLE ins.      *
*	      to a NOP.  The debugger will not terminate the IDLE      *
*	      instruction.  The user must either do a reset from the   *
*	      debugger or enable/set an interrupt flag to break the    *
*	      IDLE instruction					       *
*								       *
************************************************************************
	   .text
sysinit:   xor	   ie,ie
	   xor	   if,if
	   ldp	   PARMS
	   ldi	   @stack_addr,sp      ;load the address into stack pointer
	   ldi	   CACHE,st	       ;load the status register
	   ldi	   WAIT0,r0	       ;get i/o ready setup
	   ldi	   @mcntlr0,ar0        ;get memcntl reg address
	   sti	   r0,*ar0	       ;set parallel ready
	   ldi	   WAIT1,r0	       ;get i/o ready
	   ldi	   @mcntlr1,ar0        ;get memcntl reg address
	   sti	   r0,*ar0	       ;set io ready
	   call    aicreset	       ;routine to reset aic
	   ldi	   @com_parm,ar0       ;address of host communications parms
	   xor	   r0,r0	       ;clear out host communications
	   rpts    7		       ;paramaters
	   sti	   r0,*ar0++
	   or	   ENBL_INT0,ie        ;enable interrupt 0
	   or	   ENBL_GIE,st	       ;enable global interrupt

;********************************************************************
;The following three lines acknowledge that reset is complete.
;This fixes a timing bug on seen on fast hosts. 10/03/90 TC

	   ldi	   @hostport,ar6       ;load host port address
	   ldi	   INIT_DONE,r0        ;load init done value
	   sti	   r0,*ar6	       ;store to comm register
;********************************************************************

wait_int:  idle 		       ;wait for host to generate interrupts
	   br	   wait_int

************************************************************************
*      aicreset 						       *
*								       *
*      Reset and intialize the AIC				       *
*								       *
*      Operations:  Set up timer 0 to supply AIC master clock	       *
*		    Reset the AIC				       *
*		    Intial the serial ports			       *
*		    Take AIC out of reset			       *
*		    Intialize the AIC				       *
*		    Enable receive interrupts			       *
*								       *
************************************************************************

aicreset:
	   ldi	   2,iof	       ;xf0 to output, set xf0 to 0
	   ldi	   @t0_ctladdr,ar0     ;get address of timer control register
	   ldi	   1,r1 	       ;tclk0 will equal h1/2
	   sti	   r1,*+ar0(8)	       ;set the period register to 1
	   ldi	   @t0_ctlinit,r1      ;get timer 0 setup value
	   sti	   r1,*ar0	       ;set timer 0 to run in pulse mode

	   ldi	   @p0_addr,ar0        ;get address of serial port 0
	   ldi	   111h,r1
	   sti	   r1,*+ar0(2)	       ;intialize transmit port control
	   sti	   r1,*+ar0(3)	       ;intialize receive port control
	   ldi	   @p0_global,r1       ;intialize port 0 global control
	   sti	   r1,*ar0
	   xor	   r1,r1
	   sti	   r1,*+ar0(8)	       ;set transmit data to 0

	   rpts    99
	   nop			       ;wait for 50 timer out clocks
	   ldi	   6,iof	       ;set xf0 to 1, !reset AIC
				       ;set up the aic
	   call    wait_transmit_0     ;poll for transmit interrupt
	   ldi	   3,r1
	   sti	   r1,*+ar0(8)	       ;secondary transmittion
	   call    wait_transmit_0
	   ldi	   1a34h,r1	       ;set the sampling rate
	   sti	   r1,*+ar0(8)
	   ldi	   *+ar0(12),r1

	   call    wait_transmit_0     ;setup aic transmit and recieve
	   ldi	   3,r1 	       ;sampling rates
	   sti	   r1,*+ar0(8)
	   call    wait_transmit_0
	   ldi	   2a7h,r1
	   sti	   r1,*+ar0(8)
	   ldi	   *+ar0(12),r1
	   xor	   if,if	       ;clear out all interrupt flags
	   or	   @enbl_sp0_r,ie      ;enable serial port 0
	   rets

wait_transmit_0:
	   xor	   if,if	       ;wait for the transmit interrupt
wloop:	   tstb    10h,if	       ;flag to be set.
	   bz	   wloop
	   rets

null_int:  reti
transmit0: reti
transmit1: reti
recieve1:  reti
timer1:    reti

*****************************************************************
*  hcontrol()							*
*								*
*  Interrupt routine that controls host command processing.	*
*  Uses INT0.							*
*								*
*****************************************************************

hcontrol:
	   push    st		       ;save registers
	   push    r0
	   push    ar0
	   push    ar6
	   push    dp

	   ldp	   PARMS
	   and	   @intoff,ie	       ;turn off int1,int2, dma
	   ldi	   @intclr,r0	       ;clear old outstanding
	   and	   r0,if	       ;interrupts
	   or	   ENBL_GIE,st	       ;turn global interrupt back on
	   ldi	   @hostport,ar6       ;load host port address
	   ldi	   *ar6,r0	       ;load control request
	   tstb    BEGIN_CMD_SEND,r0   ;test for control start/end
	   bz	   format	       ;format command
	   ldi	   2,ar6	       ;address of interrupt vector 1
	   ldi	   @int1_cwr,r0        ;change interrupt 1 vector
	   sti	   r0,*ar6

	   ldi	   @com_parm,ar0       ;load command parameter address
	   ldi	   CMD_LOAD,r0	       ;set status to command loading
	   brd	   cntl_done	       ;point to status + 1
	   sti	   r0,*ar0++
	   sti	   ar0,@cmd_temp       ;save address to temp location
	   or	   ENBL_INT1,ie        ;enable interrupt 1

	   ;Compress command parameters(build 32 bit parms from 16 bit
	   ;values)
format:    ldi	   @com_parm,ar0       ;load address of parmeter block
	   addi    2,ar0	       ;index into first parameter
	   ldi	   2,rc 	       ;compress  the count, source addr
	   rptb    compress	       ;and dest. addr
	   ldi	   *+ar0,r0	       ;get high half
	   lsh	   16,r0	       ;left justify
	   addi    *ar0,r0	       ;add with low half
compress:  sti	   r0,*ar0++(2)        ;store back to word, point to next

	   ;Check for the command type and branch to spectial handling
cmd_end:   ldi	   @com_parm,ar0
	   ldi	   0,r0
	   sti	   r0,@wordflag        ;set word flag to init. value
	   ldi	   *+ar0,r1	       ;switch on command code

	   cmpi    CMD_HOST_MR16,r1    ;host memory read, 16 bit
	   bz	   mr16

	   cmpi    CMD_HOST_MW16,r1    ;host memory write, 16 bit
	   bz	   mw16

	   cmpi    CMD_HOST_MR32,r1    ;host memory read, 32 bit
	   bz	   mr32

	   cmpi    CMD_HOST_MW32,r1    ;host memory write, 32 bit
	   bz	   mw32

	   cmpi    CMD_HOST_DMAR,r1    ;host read via dma, 16 bit
	   bz	   dmaread

	   cmpi    CMD_HOST_DMAW,r1    ;host write via dma, 16 bit
	   bz	   dmawrite

	   ldi	   CMD_ERROR,r0        ;invalid command, send host error
	   sti	   r0,*ar6	       ;code
	   br	   cntl_done

cmd_ack:   ldi	   @com_parm,ar0
	   ldi	   CMD_ACTIVE,r0       ;set command status to active
	   sti	   r0,*ar0
	   ldi	   CMD_OK,r0	       ;tell host that command is intialized
	   sti	   r0,*ar6	       ;and ok to start data xfer

cntl_done: pop	   dp		       ;restore registers
	   pop	   ar6
	   pop	   ar0
	   pop	   r0
	   pop	   st
	   reti

mr16:	   brd	   cmd_ack
	   ldi	   @int2_hrd16,r0      ;set int2 vector to service routine
	   sti	   r0,@int2	       ;enable int2
	   or	   ENBL_INT2,ie

mw16:	   brd	   cmd_ack
	   ldi	   @int1_hwr16,r0      ;set int1 vector to service routine
	   sti	   r0,@int1	       ;enable int1
	   or	   ENBL_INT1,ie

mr32:	   brd	   cmd_ack
	   ldi	   @int2_hrd32,r0      ;set int2 vector to service routine
	   sti	   r0,@int2	       ;enable int2
	   or	   ENBL_INT2,ie

mw32:	   brd	   cmd_ack
	   ldi	   @int1_hwr32,r0      ;set int1 vector to service routine
	   sti	   r0,@int1	       ;enable int 1
	   or	   ENBL_INT1,ie

*****************************************************************
*  dmaread							*
*								*
*  DMA setup routine to read data C30 memory and write to host	*
*  communications register.  The transfers are interrupt driven *
*  from host reads.						*
*								*
*  As the communications register is only 16 bits wide the	*
*  upper half of the data bus is garbage. The host must do	*
*  one dummy read on the front end to fill the buffer.		*
*****************************************************************
dmaread:
	   ldi	   @dma_ctl,ar0        ;get dma control address
	   ldi	   @com_saddrl,r0      ;fetch source address
	   sti	   r0,*+ar0(4)	       ;set dma source address
	   ldi	   @hostport,r0        ;load host port address
	   sti	   r0,*+ar0(6)	       ;store dma destination address
	   ldi	   @com_countl,r0      ;read count value
	   sti	   r0,*+ar0(8)	       ;store dma count value
	   brd	   cmd_ack	       ;branch back to control
	   ldi	   @dma_rctl,r0        ;fetch dma control word
	   sti	   r0,*ar0	       ;store dma control register
	   or	   @enbl_eint2,ie      ;enable dma read interrupt

*****************************************************************
*  dmawrite							*
*								*
*  DMA setup routine to read data from the communications reg.	*
*  and write to C30 memory.  The transfers are interrupt driven *
*  from host writes.						*
*								*
*  As the communications register is only 16 bits wide the	*
*  upper half of the data bus is garbage.			*
*								*
*****************************************************************
dmawrite:
	   ldi	   @dma_ctl,ar0        ;get dma control address
	   ldi	   @hostport,r0        ;load host port address
	   sti	   r0,*+ar0(4)	       ;set dma source address
	   ldi	   @com_daddrl,r0      ;fetch destination address
	   sti	   r0,*+ar0(6)	       ;store dma destination address
	   ldi	   @com_countl,r0      ;read count value
	   sti	   r0,*+ar0(8)	       ;store dma count value
	   brd	   cmd_ack	       ;branch back to control
	   ldi	   @dma_wctl,r0        ;fetch dma control word
	   sti	   r0,*ar0	       ;store dma control register
	   or	   @enbl_eint1,ie      ;enable dma read interrupt

*****************************************************************
*  cmd_write()							*
*								*
*  Transfer command parameters from the comm. port to command	*
*  structure.							*
*****************************************************************

cmd_write:
	   push    st		       ;save registers
	   push    r0
	   push    ar6
	   push    dp

	   ldp	   PARMS
	   ldi	   @hostport,ar6       ;load host port address
	   ldi	   *ar6,r0	       ;load control request
	   ldi	   @cmd_temp,ar6       ;load current command pointer
	   and	   -1,r0	       ;mask off upper bits
	   sti	   r0,*ar6++	       ;store data to command parameters
	   sti	   ar6,@cmd_temp       ;store command pointer back to memory

	   pop	   dp		       ;restore registers
	   pop	   ar6
	   pop	   r0
	   pop	   st
	   reti

*****************************************************************
*  hwrite16							*
*								*
*  Read data from communications register and store in C30 mem. *
*  Data is stored as 16 bit value with 16 msb's set to zero.    *
*****************************************************************

hwrite16:
	   push    st		       ;save registers
	   push    r0
	   push    ar6
	   push    dp

	   ldp	   PARMS
	   ldi	   @hostport,ar6       ;load host port address
	   ldi	   *ar6,r0	       ;fetch first word of data
	   and	   -1,r0	       ;mask off upper data
	   ldi	   @com_daddrl,ar6     ;load destination address
	   sti	   r0,*ar6++	       ;store data
	   sti	   ar6,@com_daddrl     ;store data pointer back to memory

	   pop	   dp		       ;restore registers
	   pop	   ar6
	   pop	   r0
	   pop	   st
	   reti

*****************************************************************
*  hread()							*
*								*
*  Read data from c30 memory and write to communications reg.	*
*								*
*****************************************************************
hread16:
	   push    st		       ;save registers
	   push    r0
	   push    ar6
	   push    dp

	   ldp	   PARMS
	   ldi	   @com_saddrl,ar6     ;load source address
	   ldi	   *ar6++,r0	       ;fetch first word of data
	   sti	   ar6,@com_saddrl     ;store data pointer back to memory
	   ldi	   @hostport,ar6       ;load host port address
	   sti	   r0,*ar6	       ;store data

	   pop	   dp		       ;restore registers
	   pop	   ar6
	   pop	   r0
	   pop	   st
	   reti

*****************************************************************
*  hwrite32							*
*								*
*  Read data from communications register and store in C30 mem. *
*  Data is read from host as two 16 bit values and added to	*
*  form a 32 bit value. 					*
*****************************************************************

hwrite32:
	   push    st		       ;save registers
	   push    r0
	   push    r1
	   push    ar6
	   push    dp

	   ldp	   PARMS
	   ldi	   @hostport,ar6       ;load host port address
	   ldi	   *ar6,r0	       ;load from host port
	   ldi	   @com_daddrl,ar6     ;load destination address

	   ldi	   @wordflag,r1        ;load current word size
	   tstb    1,r1 	       ;if '1' then msw
	   bzd	   savedata	       ;skip over add
	   addi    1,r1 	       ;increment flag
	   sti	   r1,@wordflag        ;store flag
	   and	   -1,r0	       ;mask off msw

	   lsh	   16,r0	       ;if this is msw, then left justify
	   addi3   r0,*--ar6,r0        ;and add msw to lsw

savedata:  sti	   r0,*ar6++	       ;store data
	   sti	   ar6,@com_daddrl     ;store data pointer back to memory

	   pop	   dp		       ;restore registers
	   pop	   ar6
	   pop	   r1
	   pop	   r0
	   pop	   st
	   reti

*****************************************************************
*  hread32							*
*								*
*  Read data from C30 memory and store to commnunications reg.	*
*  Data is read from c30 memory as 32 bit and adjusted to write *
*  16 bit values as required.					*
*****************************************************************

hread32:
	   push    st		       ;save registers
	   push    r0
	   push    r1
	   push    ar6
	   push    dp

	   ldp	   PARMS
	   ldi	   @com_saddrl,ar6     ;load source address

	   ldi	   @wordflag,r1        ;load current word size
	   tstb    1,r1 	       ;if '1' then send msw
	   bzd	   senddata	       ;skip over shift and addr++ if lsw
	   addi    1,r1 	       ;increment flag
	   sti	   r1,@wordflag        ;store flag
	   ldi	   *ar6,r0	       ;fetch data word

	   lsh	   -16,r0	       ;right justify data
	   addi    1,ar6	       ;increment data pointer

senddata:  sti	   ar6,@com_saddrl     ;store data pointer back to memory
	   ldi	   @hostport,ar6       ;load host port address
	   sti	   r0,*ar6	       ;store data

	   pop	   dp		       ;restore registers
	   pop	   ar6
	   pop	   r1
	   pop	   r0
	   pop	   st
	   reti

*****************************************************************
*  dmadone							*
*								*
*  Turn off DMA on completion.					*
*****************************************************************

dmadone:
	   push    st		       ;save registers
	   push    r0
	   push    ar0
	   push    dp

	   ldp	   PARMS
	   ldi	   @dma_ctl,ar0        ;get dma control address
	   xor	   r0,r0
	   sti	   r0,*ar0	       ;turn off dma

	   pop	   dp		       ;restore registers
	   pop	   ar0
	   pop	   r0
	   pop	   st
	   reti

receive0:  push    st		       ;save registers
	   push    r0
	   push    ar0
	   push    dp

	   ldp	   PARMS
	   ldi	   @p0_addr,ar0        ;get port address
	   ldi	   *+ar0(12),r0        ;read input
	   sti	   r0,*+ar0(8)	       ;send output

	   pop	   dp		       ;restore registers
	   pop	   ar0
	   pop	   r0
	   pop	   st
	   reti

	  .end
