;-------------------------------------------------------------------------;
;                                  TIGA                                   ;
;           Copyright (c) 1990  Texas Instruments Incorporated.           ;
;                          All Rights Reserved                            ;
;-------------------------------------------------------------------------;
;   TIGA - Graphics Manager Core                                          ;
;-------------------------------------------------------------------------;
;   name            cvxyl                                                 ;
;                                                                         ;
;   synopsis	    p = cvxyl(x, y);					  ;
;		    short x, y; 	    /* x-y coordinates */	  ;
;		    unsigned long p;	    /* address of pixel */	  ;
;									  ;
;   description     The cvxyl function converts the x-y coordinates of	  ;
;		    a pixel on the screen to the address of the pixel	  ;
;		    in the TMS340x0's memory.  Arguments x and y are      ;
;		    specified relative to the drawing origin.  The	  ;
;		    address of the pixel is returned.			  ;
;                                                                         ;
;   Note:  The return value replaces the original contents of A8.	  ;
;-------------------------------------------------------------------------;
;   Feb 12/90	Original version written.................Alan T. Beland   ;
;   May 07/90	Converted from drawing coordinates, and 		  ;
;		checked for negative screen coord's......Jerry Van Aken   ;
;-------------------------------------------------------------------------;
        .title    'convert xy to linear'
        .file     'cvxyl.asm'
;
;   DECLARE GLOBALS
;
        .def      _cvxyl
        .def      _dm_cvxyl
;
;   INCLUDE EXTERNAL DEFS
;
	.copy	  gspreg.inc	      ;registers
	.copy	  gsptypes.inc	      ;typedefs
	.copy	  gspglobs.inc	      ;globals
        .mlib     gspmac.lib          ;macros
;
;   C-PACKET ENTRY POINT
;
_cvxyl:
        Popc      A8                  ;get argument x
        Popc      A14                 ;get argument y
        sll       16,A14              ;
        movy      A14,A8              ;concatenate x and y
        jruc      common_ep           ;jump to common entry point
;
;   DIRECT-MODE ENTRY POINT
;
_dm_cvxyl:
        Popc      A8                  ;get pointer to data packet
        move      *A8,A8,1            ;get concatenated x and y
;
;    COMMON ENTRY POINT
;
common_ep:
        move      @(_env+ENVIRONMENT_XYORIGIN),A14,1 ;get drawing origin
        addxy     A14,A8              ;convert to screen coordinates
	jrxn	  NEGX		      ;jump if x < 0
        cvxyl     A8,A8               ;return value = memory address
BACK:
        move      *SP(32),A14,1       ;update program stack pointer
        rets      2                   ;
;
; Jump here if the x screen coordinate is negative.
NEGX:
	movx	  A8,A14	      ;copy negative x value
	sll	  16,A14	      ;shift x sign bit into MSB
	movx	  A14,A8	      ;zero x half of register
	cvxyl	  A8,A8 	      ;(0,y) --> y*DPTCH + OFFSET
	sra	  16,A14	      ;sign-extend negative x value
	abs	  A14		      ;take absolute value of x
	cvxyl	  A14,A14	      ;(|x|,0) --> |x|*PSIZE + OFFSET
	sub	  A14,A8	      ;y*DPTCH - |x|*PSIZE
	move	  OFFSET,A14	      ;
	add	  A14,A8	      ;y*DPTCH - |x|*PSIZE + OFFSET
        jruc      BACK                ;

        .end

