;-------------------------------------------------------------------------;
;                                  TIGA                                   ;
;        Copyright (c) 1986-1990  Texas Instruments Incorporated.         ;
;			   All Rights Reserved				  ;
;-------------------------------------------------------------------------;
;   TIGA - Graphics Manager Core                                          ;
;-------------------------------------------------------------------------;
;                                                                         ;
; get_ppop function                                                       ;
;                                                                         ;
;   Returns the pixel processing operation.  The operation selected       ;
;   determines the manner in which pixels are combined (logically or      ;
;   arithmetically) during pixel move instructions.  This function get    ;
;   the specified pixel processing operation code (legal range from 0     ;
;   21) from the PPOP field of the GSP's CONTROL register.  The effect    ;
;   of the 22 different PPOP values are described in the TMS34010 User    ;
;   Manual.                                                               ;
;                                                                         ;
;   This function is designed to be called from a GSP-C program.          ;
; --------------------------------------------------------------------    ;
; Usage:  get_ppop()                                                      ;
;                                                                         ;
; Description of stack arguments:                                         ;
;   None.                                                                 ;
;                                                                         ;
; Returned in register A8:  Void (undefined).                             ;
;                                                                         ;
; Registers altered:  A8                                                  ;
;                                                                         ;
;-------------------------------------------------------------------------;
; Revision history:                                                       ;
;  11/5/86...Original version written...................Stanley Acton     ;
;   3/02/87...Modified source file header................Jerry Van Aken   ;
;-------------------------------------------------------------------------;
;
        .title    'get ppop'
        .file     'getppop.asm'
;
        .include  gspreg.inc   
;
;     DECLARE GLOBAL FUNCTION NAME
;
        .globl    _get_ppop
;
;     ENTRY POINT
;
_get_ppop:      
        setf    5,0,0               ;ppop field is 5 bits
        move    @CONTROL+10,A8,0    ;read current ppop value
        rets    0                   ;
        .end


