;-------------------------------------------------------------------------;
;                                  TIGA                                   ;
;        Copyright (c) 1988-1990  Texas Instruments Incorporated.         ;
;			   All Rights Reserved				  ;
;-------------------------------------------------------------------------;
;   TIGA - Graphics Manager Core                                          ;
;-------------------------------------------------------------------------;
;   name            get_windowing                                         ;
;                                                                         ;
;   synopsis        w = get_windowing()                                   ;
;                   unsigned short w;       /* windowing mode   */        ;
;                                                                         ;
;   description     The get_windowing() function returns the current      ;
;                   window clipping mode as follows:                      ;
;                                                                         ;
;                       0 = Windowing disabled                            ;
;                       1 = Interrupt on attempt to write inside window   ;
;                       2 = Interrupt on attempt to write outside window  ;
;                       3 = Inhibit writes outside of window              ;
;-------------------------------------------------------------------------;
        .title    'get windowing mode'
        .file     'getwind.asm'
;
;   Declare globals
;
        .globl    _get_windowing
;
;   Include files
        .include  gspreg.inc
        .mlib     gspmac.lib   
;
;   C-packet entry point
;
_get_windowing:
        setf    2,0,0           ;move two bits
        move    @CONTROL+6,A8,0 ;load A8 with CONTROL reg window bits
        rets    
        .end

