/*-----------------------------------------------------------------------*/
/*                                  TIGA                                 */
/*       Copyright (c) 1988-1990 Texas Instruments Incorporated.         */
/*                         All Rights Reserved                           */
/*-----------------------------------------------------------------------*/
/*  TIGA - Graphics Manager Core                                         */
/*-----------------------------------------------------------------------*/
/*  void get_offscreen_memory(NumAreas,offscreen)                        */
/*  short NumAreas;                                                      */
/*  OFFSCREEN_AREA offscreen[];                                          */
/*                                                                       */
/*             typedef struct {                                          */
/*                ulong   addr;                                          */
/*                ushort  xext;                                          */
/*                ushort  yext;                                          */
/*             } OFFSCREEN_AREA;                                         */
/*                                                                       */
/*  This function returns the description of the offscreen memory blocks */
/*  defined in the system configuration file.                            */
/*-----------------------------------------------------------------------*/
/*  11/03/88  Original Version                   A. Sharp                */
/*  11/26/88  Modified for new offscreen def     W.S.Egr                 */
/*-----------------------------------------------------------------------*/
/* Names of GSP I/O registers and B-file registers */
#include <gsptypes.h>
#include <gspglobs.h>

void get_offscreen_memory(NumAreas,offscreen_ptr)
register int NumAreas;
register OFFSCREEN_AREA *offscreen_ptr;         
{
    register int AreasDefined = config.mode.num_offscrn_areas;
    register OFFSCREEN_AREA *oap = offscreen;

    if( NumAreas > AreasDefined )
      NumAreas = AreasDefined;

    while( NumAreas-- )
        *offscreen_ptr++ = *oap++;
}

