;-------------------------------------------------------------------------;
;                                  TIGA                                   ;
;        Copyright (c) 1987-1990  Texas Instruments Incorporated.         ;
;			   All Rights Reserved				  ;
;-------------------------------------------------------------------------;
;   TIGA - Graphics Manager Core                                          ;
;-------------------------------------------------------------------------;
;                                                                         ;
;   void set_fcolor(col)                                                  ;
;   void set_bcolor(col)                                                  ;
;   void set_colors(fcol, bcol)                                           ;
;                                                                         ;
;   Replicate the given value into the COLOR1 or COLOR0 registers.        ;
;   The color is replicated based on the current PSIZE.                   ;
;                                                                         ;
;   Example: set_fcolor(0x5), would result in 0x55555555 in COLOR1        ;
;            if PSIZE was 4, and 0x05050505 if PSIZE was 8.               ;
;                                                                         ;
;   Notes: A8 is destroyed                                                ;
;-------------------------------------------------------------------------;
;   1/24/87  Original Version Written                      Gary Littleton ;
;   7/13/88  Changed to TIGA function names and added dm   Graham Short   ;
;   7/11/89  Modified for 34020                            A. Sharp       ;
;   9/26/90  Modified 34010 code to accept 32-bit pixels   J. Van Aken    ;
;-------------------------------------------------------------------------;

;   Include GSP register definitions
        .include  gspreg.inc
        .include  oem.inc
;
;   Declare function names
        .globl  _set_fcolor
        .globl  _set_bcolor
        .globl  _set_colors
        .globl  _dm_set_fcolor
        .globl  _dm_set_bcolor
        .globl  _dm_set_colors

;--------------------------------------------------------------------
;  Replicate color value throughout COLOR0 register (based on the
;  current pixel size)
;--------------------------------------------------------------------
;
; DIRECT-MODE ENTRY POINT
;
_dm_set_bcolor:
        mmtm    SP,B0,B1,B2
        move    STK,B0
        move    *-B0,COLOR0,1
        move    B0,STK
        move    *COLOR0,COLOR0,1
        jruc    common_ep0
;
; C-PACKET ENTRY POINT
;
_set_bcolor:
        mmtm    SP,B0,B1,B2
        move    STK,B0
        move    *-B0,COLOR0,1
        move    B0,STK
;
; 2 ENTRY POINTS JOIN UP HERE
;
common_ep0:
        .if     GSP_34010 ; Code used if the processor is a 34010
        movk    1,B0
        cvxyl   B0,B0             ;B0 = (PSIZE*1) + OFFSET
        sub     OFFSET,B0         ;B0 = PSIZE
        exgf    B0,0              ;Field 0 = PSIZE
        zext    COLOR0,0          ;isolate significant LSBs
        exgf    B0,0
        lmo     B0,B1
        subk    26,B1             ;B1 -> shift count
        jrz     norep0            ;jump if pixel size is 32 bits
rep0loop:
        move    COLOR0,B2
        sll     B0,COLOR0
        or      B2,COLOR0
        sll     1,B0
        dsjs    B1,rep0loop
norep0:
        .endif
        .if     GSP_34020 ; Code used if the processor is a 34020
        rpix    COLOR0
        .endif
        mmfm    SP,B0,B1,B2
        rets    2

;--------------------------------------------------------------------
;  Replicate color value throughout COLOR1 register (based on the
;  current pixel size)
;--------------------------------------------------------------------
;
; DIRECT-MODE ENTRY POINT
;
_dm_set_fcolor:
        mmtm    SP,B0,B1,B2
        move    STK,B0
        move    *-B0,COLOR1,1
        move    B0,STK
        move    *COLOR1,COLOR1,1
        jruc    common_ep1
;
; C-PACKET ENTRY POINT
;
_set_fcolor:
        mmtm    SP,B0,B1,B2
        move    STK,B0
        move    *-B0,COLOR1,1
        move    B0,STK
;
; 2 ENTRY POINTS JOIN UP HERE
;
common_ep1:
        .if     GSP_34010 ; Code used if the processor is a 34010
        movk    1,B0
        cvxyl   B0,B0
        sub     OFFSET,B0
        exgf    B0,0
        zext    COLOR1,0
        exgf    B0,0
        lmo     B0,B1
        subk    26,B1
        jrz     norep1            ;jump if pixel size is 32 bits
rep1loop:
        move    COLOR1,B2
        sll     B0,COLOR1
        or      B2,COLOR1
        sll     1,B0
        dsjs    B1,rep1loop
norep1:
        .endif
        .if     GSP_34020 ; Code used if the processor is a 34020
        rpix    COLOR1
        .endif
        mmfm    SP,B0,B1,B2
        rets    2

;--------------------------------------------------------------------
;  Replicate color values throughout the COLOR1 and COLOR0 registers
;  based on the current pixel size.
;--------------------------------------------------------------------
;
; DIRECT-MODE ENTRY POINT
;
_dm_set_colors:
        mmtm    SP,B0,B1,B2
        move    STK,B0
        move    *-B0,COLOR0,1
        move    B0,STK
        move    *COLOR0+,COLOR1,1
        move    *COLOR0 ,COLOR0,1
        jruc    common_ep
;
; C-PACKET ENTRY POINT
;
_set_colors:
        mmtm    SP,B0,B1,B2
        move    STK,B0
        move    *-B0,COLOR1,1
        move    *-B0,COLOR0,1
        move    B0,STK
;
; 2 ENTRY POINTS JOIN UP HERE
;
common_ep:
        .if     GSP_34010 ; Code used if the processor is a 34010
        movk    1,B0
        cvxyl   B0,B0             ;get pixel size
        sub     OFFSET,B0         ;subtract off offset
        exgf    B0,0
        zext    COLOR1,0
        zext    COLOR0,0
        exgf    B0,0
        lmo     B0,B1
        subk    26,B1             ;B1 -> shift count
        jrz     noreps            ;jump if pixel size is 32 bits
reploop:
        move    COLOR1,B2
        sll     B0,COLOR1
        or      B2,COLOR1
        move    COLOR0,B2
        sll     B0,COLOR0
        or      B2,COLOR0
        sll     1,B0
        dsjs    B1,reploop
noreps:
        .endif
        .if     GSP_34020 ; Code used if the processor is a 34020
        rpix    COLOR0
        rpix    COLOR1
        .endif
        mmfm    SP,B0,B1,B2
        rets    2
        .end

