;-------------------------------------------------------------------------;
;                                  TIGA                                   ;
;        Copyright (c) 1986-1990  Texas Instruments Incorporated.         ;
;			   All Rights Reserved				  ;
;-------------------------------------------------------------------------;
;   TIGA - Graphics Manager Extension                                     ;
;-------------------------------------------------------------------------;
;                                                                         ;
; draw_point function                                                     ;
;                                                                         ;
;   Draw a single pixel at coordinates (x,y) in the current viewport.     ;
;   The pixel color is contained in the COLOR1 register (B9).             ;
;-------------------------------------------------------------------------;
; Usage:  draw_point(x, y);                                               ;
;                                                                         ;
; Description of stack arguments:                                         ;
;   long x, y;  /* coordinates of pixel */                                ;
;                                                                         ;
; Returned in register A8:  Void (undefined)                              ;
;                                                                         ;
; Registers altered:  A8                                                  ;
;-------------------------------------------------------------------------;
; Revision history:                                                       ;
;   02/05/86...Original version written...................John Black      ;
;   11/19/86...Modified header info, shortened code.......Jerry Van Aken  ;
;   07/12/88...Added TIGA direct mode and dstbm check.....W.S.Egr         ;
;   09/07/88...Access globals thru env struct.............W.S.Egr         ;
;-------------------------------------------------------------------------;
        .title    'draw a point'
        .file     'drawpt.asm'
       .include   gsptypes.inc          ;offsets into environment struct
       .include   gspglobs.inc          
;
;  DECLARE GLOBAL FUNCTION NAME
;
        .globl    _draw_point
        .globl    _dm_draw_point
;
;    DIRECT-MODE ENTRY POINT
;
_dm_draw_point:
        move      A0,*-SP,1           ;save register on stack
        move      -*A14,A8,1          ;get dm-data area pointer
        move      *A8,A0,1            ;1st word is y::x
        jruc      common_ep           ;jump to common entry point
;
;    C-PACKET ENTRY POINT
;
_draw_point:
* Save registers
        MOVE      A0,*-SP,1           ;save register on stack
        MOVE      *-A14,A0,1          ;get argument 'x'
        MOVE      *-A14,A8,1          ;get argument 'y'
        SLL       16,A8               ;
        MOVY      A8,A0               ;form xy address
;
;    2 ENTRY POINTS JOIN UP HERE
;
common_ep:
;
;    Check for destination bitmap pointing to the screen.  If not, abort for
;    now.  Linear drawing capability will be added at a later time.
;
        move      @(_env+ENVIRONMENT_DSTBM),A8,1    ;destination bit-map global variable
        jrnz      EXIT                ;if zero, dstbm is set to screen
        MOVE      @(_env+ENVIRONMENT_XYORIGIN),A8,1     ;
        ADDXY     A8,A0               ;screen relative xy coordinates
        DRAV      A8,A0               ;draw pixel to screen
EXIT:
        MOVE      *SP+,A0,1           ;restore register
        RETS      2                   ;
        .end
