;-------------------------------------------------------------------------;
;                                  TIGA                                   ;
;        Copyright (c) 1986-1990  Texas Instruments Incorporated.         ;
;			   All Rights Reserved				  ;
;-------------------------------------------------------------------------;
;   TIGA - Graphics Manager Extension                                     ;
;-------------------------------------------------------------------------;
;                                                                         ;
; frame_rect function                                                     ;
;                                                                         ;
;   Draw a rectangular frame of specified size and thickness.  The frame  ;
;   is solid filled with color 1.  The dimensions of the outer            ;
;   rectangular edge of the frame are specified in arguments width and    ;
;   height.  The coordinates at the top left corner of the outer          ;
;   rectangle is specified by arguments xleft and ytop.  The thickness    ;
;   of the frame in the x and y directions is given by arguments dx and   ;
;   dy, respectively.                                                     ;
;-------------------------------------------------------------------------;
; Usage:  frame_rect(width, height, xleft, ytop, dx, dy)                  ;
;                                                                         ;
; Stack arguments                                                         ;
;             long width, height;  /* dimensions of outer rectangle */    ;
;             long xleft, ytop;    /* top left corner of outer rect */    ;
;             long dx, dy;         /* thickness of frame in x and y */    ;
;                                                                         ;
; Registers altered:  A8                                                  ;
;-------------------------------------------------------------------------;
; Revision history:                                                       ;
;   2/ 5/86...Original version written...................John Black       ;
;  10/20/86...Added TI copyright notice..................Stanley Acton    ;
;   3/18/87...Added check for case of no hole............Jerry Van Aken   ;
;   9/16/88...Added TIGA dm, globals & check for dstbm...Graham Short     ;
;-------------------------------------------------------------------------;
;
        .title    'frame rectangle'
        .file     'framrect.asm'
;
;     DECLARE GLOBAL FUNCTION NAME
;
        .globl    _frame_rect, _dm_frame_rect
;
;  INCLUDE GLOBAL DEFINITIONS
;
       .include   gsptypes.inc
       .include   gspglobs.inc          
;
;     C-PACKET ENTRY POINT
;
_frame_rect:
        MMTM      SP,A0,A1,A2,A3,A4   ;
        MMTM      SP,B2,B7,B10,B11,B12,B13,B14
* Pop six arguments from operand stack.
        MOVE      *-A14,A0,1                  ;get width w
        MOVE      *-A14,A1,1                  ;get height h
        SLL       16,A1                       ;
        MOVY      A1,A0                       ;concatenate w & h
        MOVE      *-A14,A2,1                  ;get xleft
        MOVE      *-A14,A3,1                  ;get ytop
        SLL       16,A3                       ;
        MOVY      A3,A2                       ;concatenate xleft & ytop
        MOVE      *-A14,A3,1                  ;get dx
        MOVE      *-A14,A4,1                  ;get dy
        SLL       16,A4                       ;
        MOVY      A4,A3                       ;concatenate dx & dy
        jruc      common_ep
;
;     DIRECT MODE ENTRY POINT
;
_dm_frame_rect:
        MMTM      SP,A0,A1,A2,A3,A4   ;
        MMTM      SP,B2,B7,B10,B11,B12,B13,B14
* Get six arguments from data area of command buffer
        MOVE      *-A14,A8,1                  ;get pointer to data area
        MOVE      *A8+,A0,1                   ;get width h::w
        CLRS      A1
        MOVY      A0,A1                       ;get h:0
        MOVE      *A8+,A2,1                   ;get ytop::xleft
        MOVE      *A8,A3,1                    ;get dy::dx
        CLRS      A4                          ;
        MOVY      A3,A4                       ;concatenate dy::0
;
;     TWO ENTRY POINTS JOIN HERE
;
common_ep:
;
; check for destination bitmap pointing to the screen, if not abort for now
; linear drawing capability will be added at a later time
;
        MOVE      @(_env+ENVIRONMENT_DSTBM),A8,1    ; destination bit-map global
        JRNZ      DONE                      ; if zero, dstbm is set to screen
        MOVE      @_env+ENVIRONMENT_XYORIGIN,A8,1   ;viewport origin displacement
        ADDXY     A8,A2                     ;convert to screen coord's
;
;     MAIN ALGORITHM
;

* Check for case of no hole in frame.
        MOVE      A0,A8               ;copy h::w
        SUBXY     A3,A8               ;
        SUBXY     A3,A8               ;(h-2*dy)::(w-2*dx)
        JRLT      NOHOLE              ;jump if hole width <= 0
        JRLS      NOHOLE              ;jump if hole height <= 0
* Fill top slat of frame.
        MOVY      A3,A0               ;concatenate dy::w
        MOVE      A0,B7               ;DYDX = dy::w
        MOVE      A2,B2               ;DADDR = ytop::xleft
        FILL      XY                  ;fill slat
* Fill bottom slat of frame.
        ADDXY     A2,A1               ;
        SUBXY     A4,A1               ;
        MOVE      A1,B2               ;DADDR = (ytop+h-dy)::xleft
        FILL      XY                  ;fill slat
* Fill left slat of frame.
        MOVX      A3,A8               ;
        MOVE      A8,B7               ;DYDX = (h-2*dy)::dx
        ADDXY     A4,A2               ;
        MOVE      A2,B2               ;DADDR = (ytop+dy)::xleft
        FILL      XY                  ;fill slat
* Fill right slat of frame.
        SUBXY     A3,A0               ;
        ADDXY     A0,A2               ;(ytop+dy)::(xleft+w-dx)
        MOVE      A2,B2               ;load DADDR
        FILL      XY                  ;fill slat
* Restore registers and return.
DONE:
        MMFM      SP,B2,B7,B10,B11,B12,B13,B14
        MMFM      SP,A0,A1,A2,A3,A4   ;
        RETS      2                   ;
* Handle special case of no hole.
NOHOLE:
        MOVE      A0,B7               ;DYDX = h::w
        MOVE      A2,B2               ;DADDR = ytop::xleft
        FILL      XY                  ;fill entire rectangle
        JRUC      DONE                ;finished!
        .end

