;-------------------------------------------------------------------------;
;                                  TIGA                                   ;
;          Copyright (c) 1990  Texas Instruments Incorporated.            ;
;			   All Rights Reserved				  ;
;-------------------------------------------------------------------------;
;   TIGA - Graphics Manager Extension                                     ;
;-------------------------------------------------------------------------;
;  in_font - Determine if the specified range of ASCII codes are defined  ;
;  in the currently selected font.  Returns 0 if all codes defined, else  ;
;  returns the number of the first undefined ASCII code encountered.      ;
;                                                                         ;
;  Usage: in_font( first, last)                                           ;
;               short first, last;                                        ;
;                                                                         ;
;-------------------------------------------------------------------------;
;  03/21/90   Original Version Written                     J.G.Littleton  ;
;-------------------------------------------------------------------------;
;  TMS340 register Definitions
        .copy   "gspreg.inc"
	.copy	"gsptypes.inc"
	.copy	"gspglobs.inc"

;  TMS340 Macro Definitions
        .mlib   "gspmac.lib"

;  Global Definitions
        .globl  _in_font    
;
;  Local register usage
Rcode1  .set      A0                  ;Starting ASCII code         
Rcode2  .set      A1                  ;Ending ASCII code         
Rfirst  .set      A2                  ;first character code defined in font
Rpow    .set      A3                  ;pointer to offset/width table
Rcode   .set      A4                  ;holds ASCII character code
Rlast   .set      A5                  ;last character code defined in font
;
_in_font:
        mmtm    SP,A0,A1,A2,A3,A4,A5
        setf    16,0,0
        Popc    Rcode1                ;pop starting ASCII code
        Popc    Rcode2                ;pop ending ASCII code
        cmp     Rcode1,Rcode2         ;q: is code1 < code2?
        jrge    ascending             ;y: leave them alone
        Swap    Rcode1,Rcode2         ;n: reverse their order
ascending:
;  Get font parameters in registers
        move    @_envtext+ENVTEXT_SELECTED,A8,1 ;Get pointer to font record
        move    *A8(FONT_FIRST),Rfirst,0
        move    *A8(FONT_LAST),Rlast,0
        move    *A8(FONT_OOWTBL),Rpow,1 ;offset to offset/width table
        add     A8,Rpow               
        move    *A8(FONT_CHARWIDE),Rcode,0
;
        cmp     Rfirst,Rcode1         ;q: is Code1 >= First?
        jrge    ok1
        move    Rcode1,A8             ;n: exit indicating code1 outside
        jruc    exit_in_font
ok1:
        move    Rcode,Rcode           ;q: proportional font?
        jrz     checkall              ;y: check each code in range...
;        
        cmp     Rlast,Rcode2          ;q: is code2 <= Last?
        jrle    ok2                   ;y: ok so far...
        move    Rlast,A8              ;n: exit indicating code2 outside
        addk    1,A8
        jruc    exit_in_font
ok2:
        clr     A8                    ;n: block font, all codes are defined
        jruc    exit_in_font
checkall:
        clr     A8
        cmp     Rcode1,Rcode2         ;q: all codes checked?
        jrn     exit_in_font          ;y: exit with zero 
        move    Rcode1,Rcode          ;get code to check
        move    Rcode,A8
        cmp     Rlast,Rcode           ;q: is code <= Last?
        jrgt    exit_in_font          ;n: exit indicating not defined
        sub     Rfirst,Rcode          ;index = char code - first char
        sll     4,Rcode               ;index into offset/width table
        add     Rpow,Rcode            ;add address of offset/width table
        move    *Rcode,Rcode,0        ;get offset/width value for code
        sext    Rcode,0               
        cmpi    -1,Rcode              ;if (offset/width == -1) not defined
        jrz     exit_in_font          ;not defined...	
        addk    1,Rcode1              
        jruc    checkall              
exit_in_font:
        mmfm    SP,A0,A1,A2,A3,A4,A5
        rets    2
        .end

