/*-----------------------------------------------------------------------*/
/*                                 TIGA                                  */
/*       Copyright (c) 1987-1990 Texas Instruments Incorporated.         */
/*                         All Rights Reserved                           */
/*-----------------------------------------------------------------------*/
/*  TIGA - Graphics Manager Extension                                    */
/*-----------------------------------------------------------------------*/
/* onarc function                                                        */
/*                                                                       */
/*    The onarc function computes a point on an ellipse given the width  */
/*    w and height h of the minimum enclosing rectangle in which the     */
/*    ellipse is inscribed, and the angle theta made by the point with   */
/*    respect to the horizontal.  The angle is specified in degrees of   */
/*    elliptical arc, and is measured from a horizontal line through the */
/*    center of the ellipse to the right side of the rectangle.          */
/*    Positive angles go clockwise, while negative angles go             */
/*    counterclockwise.  Angles outside the range 0 to 359 degrees are   */
/*    converted to modulus 360 prior to calculation of the arc point     */
/*    coordinates.                                                       */
/*                                                                       */
/*    The x and y coordinates of the arc point are written to addresses  */
/*    &xarc and &yarc, and the quadrant number (range: 0 to 3) is        */
/*    written to address &quad.                                          */
/*-----------------------------------------------------------------------*/
/* Usage:  onarc(w, h, theta, &xarc, &yarc, &quad);                      */
/*                                                                       */
/* Description of the arguments:                                         */
/*   long w, h;  { width and height of minimum enclosing rectangle }     */
/*   long theta;  { angle expressed in degrees of elliptical arc }       */
/*   long *xarc, *yarc;  { pointers to x and y coordinates on arc }      */
/*   long *quad;  { pointer to quadrant number (range 0 to 3) }          */
/*-----------------------------------------------------------------------*/
/* Revision history:                                                     */
/*   6/17/87...Original version written...................Jerry Van Aken */
/*-----------------------------------------------------------------------*/

 /* Sine lookup table for angles 0 to 90 degrees */
 extern unsigned short sin_tbl[];

 onarc(w, h, theta, xarc, yarc, quad)
 long w, h, theta, *xarc, *yarc, *quad;
 {
     long t, x, y;

     if ((t = theta % 360) < 0)
         t += 360;

     if (t < 180) {
         if (t < 90) {
             x = w * ((1<<16) + sin_tbl[90 - t]) + (1<<16) - 1 >> 17;
             y = h * ((1<<16) + sin_tbl[t]) + (1<<16) - 1 >> 17;
         } else {
             x = w * ((1<<16) - sin_tbl[t - 90]) + (1<<16) - 1 >> 17;
             y = h * ((1<<16) + sin_tbl[180 - t]) + (1<<16) - 1 >> 17;
         }
     } else {
         if (t < 270) {
             x = w * ((1<<16) - sin_tbl[270 - t]) + (1<<16) - 1 >> 17;
             y = h * ((1<<16) - sin_tbl[t - 180]) + (1<<16) - 1 >> 17;
         } else {
             x = w * ((1<<16) + sin_tbl[t - 270]) + (1<<16) - 1 >> 17;
             y = h * ((1<<16) - sin_tbl[360 - t]) + (1<<16) - 1 >> 17;
         }
     }
     *xarc = x;
     *yarc = y;
     if (y > (h >> 1)) {
         if (x > (w >> 1))
             *quad = 0;
         else
             *quad = 1;
     } else {
         if (x <= (w >> 1))
             *quad = 2;
         else
             *quad = 3;
     }
 }

