;-------------------------------------------------------------------------;
;                                  TIGA                                   ;
;        Copyright (c) 1986-1990  Texas Instruments Incorporated.         ;
;			   All Rights Reserved				  ;
;-------------------------------------------------------------------------;
;   TIGA - Graphics Manager Extension                                     ;
;-------------------------------------------------------------------------;
; put_pixel function							  ;
;									  ;
;   Writes the specified pixel value to the specified coordinates.  The   ;
;   coordinates are specified relative to the current drawing origin.	  ;
;   Given a pixel size of n bits, the pixel is contained in the n LSBs	  ;
;   of the "value" input argument (the 32-n MSBs are ignored).            ;
;-------------------------------------------------------------------------;
; Usage:  put_pixel(val, xs, ys);					  ;
;                                                                         ;
; Description of stack arguments:                                         ;
;	  long val;	       /* pixel value */			  ;
;	  short xs, ys;        /* coordinates of source pixel */	  ;
;                                                                         ; 
; Returned in register A8:  void					  ;
;                                                                         ;
; Registers altered:  A8                                                  ;
;-------------------------------------------------------------------------;
; Revision history:                                                       ;
;   11/02/86...Original version written..................J.R. Van Aken	  ;
;   01/03/90...Added TIGA direct mode....................J.R.V. 	  ;
;-------------------------------------------------------------------------;
;
	.title	  'put pixel'
	.file	  'putpixel.asm'
;
;
;     DECLARE GLOBAL FUNCTION NAME
;
	.def	  _put_pixel
	.def	  _dm_put_pixel
;
;     REFERENCE EXTERNAL GLOBALS
;
        include gsptypes.inc
        include gspglobs.inc          
;
;     C-PACKET ENTRY POINT
;
_put_pixel:
        MOVE      A0,*-SP,1           ;save register
* Pop arguments off stack.
	MOVE	  *-A14,A8,1	      ;get argument 'val'
	MOVE	  *-A14,A0,1	      ;get argument 'xs'
	MOVE	  *-A14,A14,1	      ;get argument 'ys'
* Concatenate origin-relative x-y coordinates of pixel.
	SLL	  16,A14	      ;
	MOVY	  A14,A0	      ;concatenate xs, ys
        jruc      common_ep

;
;     DIRECT-MODE ENTRY POINT
;
_dm_put_pixel:
        MOVE      A0,*-SP,1           ;save register
* Get arguments from command buffer data area.
	MOVE	  *-A14,A14,1	      ;get pointer to data area
	MOVE	  *A14+,A8,1	      ;get argument 'val'
	MOVE	  *A14+,A0,1	      ;get concatenated args ys:xs

* Calculate screen-relative x-y coordinates of destination pixel.
common_ep:
	MOVE	  @_env+ENVIRONMENT_XYORIGIN,A14,1    ;viewport origin displacement
	ADDXY	  A14,A0		      ;convert to screen coord's
* Write pixel.
	PIXT	  A8,*A0.XY	      ;
* Restore registers and return.
        MOVE      *SP+,A0,1           ;restore register
	MOVE	  *SP(32),A14,1       ;restore program stack pointer
        RETS      2                   ;return
        .end

