;-------------------------------------------------------------------------;
;                                  TIGA                                   ;
;        Copyright (c) 1988-1990  Texas Instruments Incorporated.         ;
;			   All Rights Reserved				  ;
;-------------------------------------------------------------------------;
;   TIGA - Graphics Manager Extension                                     ;
;-------------------------------------------------------------------------;
; set_draw_origin                                                         ;
;                                                                         ;
;   This sets the drawing origin with which all drawing operations are    ;
;   referenced to, to the specified coordinate.                           ;
;-------------------------------------------------------------------------;
; Usage:  set_draw_origin(x, y);                                          ;
;                                                                         ;
; Description of the arguments:                                           ;
;   short x, y;           // coordinates of new origin //                 ;
;-------------------------------------------------------------------------;
; Revision history:                                                       ;
;  09/18/88...Original version written...................Graham Short     ;
;-------------------------------------------------------------------------;
;
        .title    'set draw origin'
        .file     'setdraw.asm'
;
;   INCLUDE FILES
;
       .include   gsptypes.inc          ;offsets into environment structure
       .include   gspglobs.inc          
;
;     DECLARE GLOBAL FUNCTION NAME
;
        .globl    _set_draw_origin
        .globl    _dm_set_draw_origin
;
;    DIRECT-MODE ENTRY POINT
;
_dm_set_draw_origin:
        move      A0,*-SP,1                  ;save A0
        move      -*A14,A8,1                 ;get dm-data area address
        setf      16,1,0                     ;parms are word length
        move      *A8+,A0,0                  ;1st word parm is xorg
        move      *A8,A8,0                   ;2nd word parm is yorg
        jruc      common_ep
;
;    C-PACKET ENTRY POINT
;
_set_draw_origin:
* Save registers and pop arguments
        move      A0,*-SP,1                  ;save A0
        move      -*A14,A0,1                 ;Pop xorg
        move      -*A14,A8,1                 ;Pop yorg
        setf      16,0,0                     ;
;
;    2 ENTRY POINTS JOIN UP HERE
;
common_ep:
        sll       16,A8                      ;Concatenate origin
        movx      A0,A8                      ;  yorg::xorg
        move      A8,@(_env+ENVIRONMENT_XYORIGIN),1  ;Save xyorigin
        move      *SP+,A0,1                  ;restore A0
        rets      2                          ;return
        .end
