;-------------------------------------------------------------------------;
;                                  TIGA                                   ;
;        Copyright (c) 1988-1990  Texas Instruments Incorporated.         ;
;			   All Rights Reserved				  ;
;-------------------------------------------------------------------------;
;   TIGA - Graphics Manager Extension                                     ;
;-------------------------------------------------------------------------;
; set_pensize function                                                    ;
;                                                                         ;
;   Specify new dimensions for drawing pen, whose shape is rectangular.   ;
;-------------------------------------------------------------------------;
; Usage:  set_pensize(width, height);                                     ;
;                                                                         ;
; Description of the arguments:                                           ;
;   short width, height;  // dimensions of pen rectangle //               ;
;-------------------------------------------------------------------------;
; Revision history:                                                       ;
;  07/12/88...Original version written...................W.S.Egr          ;
;  09/09/88...Access globals thru environment struct.....W.S.Egr          ;
;-------------------------------------------------------------------------;
;
        .title    'set pen size'
        .file     'setpens.asm'
;
;   INCLUDE FILES
;
       .include   gsptypes.inc          ;offsets into environment structure
       .include   gspglobs.inc          
;
;     DECLARE GLOBAL FUNCTION NAME
;
        .globl    _set_pensize
        .globl    _dm_set_pensize
;
;     MACROS
;
PUSH    $MACRO    R1
        move      :R1.S:,-*SP,1
        $END

POP     $MACRO    R1
        move      *SP+,:R1.S:,1
        $END
;
;    DIRECT-MODE ENTRY POINT
;
_dm_set_pensize:
        PUSH      A0
        move      -*A14,A8,1          ;get dm-data area address
        setf      16,1,0              ;parms are word length
        move      *A8+,A0,0           ;1st word parm is pen width
        move      *A8,A8,0            ;2nd word parm is pen height
        jruc      common_ep
;
;    C-PACKET ENTRY POINT
;
_set_pensize:
* Save registers and pop arguments
        PUSH      A0                  ;Push A0 on stack
        move      -*A14,A0,1          ;Pop pen width
        move      -*A14,A8,1          ;Pop pen height
        setf      16,0,0              ;
;
;    2 ENTRY POINTS JOIN UP HERE
;
common_ep:
        sll       16,A8               ;Concatenate pen
        movx      A0,A8               ;  height::width
        move      A8,@(_env+ENVIRONMENT_PENSIZE),1  ;Save pen size
        POP       A0                  ;Pop A0 off stack
        rets      2                   ;return
        .end
