/*----------------------------------------------------------------------
 *			 TMS340 Graphics Library
 *       Copyright (c) 1987-1990 Texas Instruments Incorporated.
 *                         All Rights Reserved
 *----------------------------------------------------------------------
 * Demonstration Program
 *
 *   Test the trigonometric and hyperbolic floating-point math functions
 *   from the TMS340-Family C compiler.  The output is graphical, and
 *   shows the shapes of the curves generated by the sin, cos, tan, sinh,
 *   cosh and tanh functions.
 *----------------------------------------------------------------------
 * Revision History:
 *   11/09/87...Original version written...................G. Littleton
 *   03/27/90...Modified for general portability...........J.R. Van Aken
 *----------------------------------------------------------------------
 */
#include <gsptypes.h>
#include "colors.h"

/* If MODE not defined at preprocessor command line, set to default. */
#ifndef  MODE
#define  MODE	  0	  /* default graphics mode */
#endif

#define PI     3.141592654

extern double sin(), cos(), tan(), sinh(), cosh(), tanh();

static CONFIG cfg;
static short hres, vres, d;
static double sx, sy;


main()
{
    /* Initialize graphics environment. */
    if (!set_config(MODE, 1))
	exit(1);		 /* invalid graphics mode number */
    clear_screen(-1);
    get_config(&cfg);
    hres = cfg.mode.disp_hres;	 /* horizontal resolution */
    vres = cfg.mode.disp_vres;	 /* vertical resolution */
    sx = 7*hres/8;
    sy = 7*vres/8;
    d = 1 + hres/144;

    draw_line(0, vres/2, hres-1, vres/2);
    draw_line(hres/2, 0, hres/2, vres-1);

    render_curve(CYAN,	  sinh);
    render_curve(YELLOW,  tanh);
    render_curve(BLUE,	  sin );
    render_curve(RED,	  cos );
    render_curve(GREEN,   tan );
    render_curve(MAGENTA, cosh);
}


render_curve(color, func)
unsigned long color;
double (*func)();
{
    double a;
    int x, y;

    for (a = -2.0*PI; a <= 2.0*PI; a += 0.05) {
	x = hres/2 + (sx*a)/(2.0*PI);
	y = vres/2 - (sy*(*func)(a))/2.0;
	if (cfg.mode.disp_psize >= 4)	/* check for color display */
	    set_fcolor(color);
	fill_oval(d, d, x-d/2, y-d/2);
    }
}

